/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import org.scijava.java3d.IndexedObject;
import org.scijava.java3d.SceneGraphObjectRetained;
import org.scijava.java3d.VirtualUniverse;

class IndexedUnorderSet
implements Cloneable,
Serializable {
    static final boolean debug = false;
    transient IndexedObject[] elementData;
    transient Object[] cloneData;
    transient int cloneSize;
    transient boolean isDirty = true;
    Class componentType;
    int size;
    int listType;
    VirtualUniverse univ;

    IndexedUnorderSet(int initialCapacity, Class componentType, int listType, VirtualUniverse univ) {
        this.componentType = componentType;
        this.elementData = (IndexedObject[])Array.newInstance(componentType, initialCapacity);
        this.listType = listType;
        this.univ = univ;
    }

    IndexedUnorderSet(Class componentType, int listType, VirtualUniverse univ) {
        this(10, componentType, listType, univ);
    }

    IndexedUnorderSet(int initialCapacity, int listType, VirtualUniverse univ) {
        this(initialCapacity, IndexedObject.class, listType, univ);
    }

    IndexedUnorderSet(int listType, VirtualUniverse univ) {
        this(10, IndexedObject.class, listType, univ);
    }

    static final void init(IndexedObject obj, int len) {
        obj.listIdx = new int[3][];
        obj.listIdx[0] = new int[len];
        obj.listIdx[1] = new int[len];
        obj.listIdx[2] = new int[1];
        for (int i = 0; i < len; ++i) {
            obj.listIdx[0][i] = -1;
            obj.listIdx[1][i] = -1;
        }
        obj.listIdx[2][0] = obj instanceof SceneGraphObjectRetained ? 1 : 0;
    }

    final int size() {
        return this.size;
    }

    final int arraySize() {
        return this.cloneSize;
    }

    final boolean isEmpty() {
        return this.size == 0;
    }

    final synchronized boolean contains(IndexedObject o) {
        return o.listIdx[o.getIdxUsed(this.univ)][this.listType] >= 0;
    }

    final synchronized int indexOf(IndexedObject o) {
        return o.listIdx[o.getIdxUsed(this.univ)][this.listType];
    }

    protected final synchronized Object clone() {
        try {
            IndexedUnorderSet v = (IndexedUnorderSet)super.clone();
            v.elementData = (IndexedObject[])Array.newInstance(this.componentType, this.size);
            System.arraycopy(this.elementData, 0, v.elementData, 0, this.size);
            this.isDirty = true;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    final synchronized Object[] toArray(boolean copy) {
        if (copy) {
            if (this.isDirty) {
                if (this.cloneData == null || this.cloneData.length < this.size) {
                    this.cloneData = (Object[])Array.newInstance(this.componentType, this.size);
                }
                System.arraycopy(this.elementData, 0, this.cloneData, 0, this.size);
                this.cloneSize = this.size;
                this.isDirty = false;
            }
            return this.cloneData;
        }
        this.cloneSize = this.size;
        return this.elementData;
    }

    final synchronized Object[] toArray() {
        return this.toArray(true);
    }

    final synchronized Object[] toArray(IndexedObject startElement) {
        int idx = this.indexOf(startElement);
        if (idx < 0) {
            return (Object[])Array.newInstance(this.componentType, 0);
        }
        int s = this.size - idx;
        Object[] data = (Object[])Array.newInstance(this.componentType, s);
        System.arraycopy(this.elementData, idx, data, 0, s);
        return data;
    }

    final synchronized void trimToSize() {
        if (this.elementData.length > this.size) {
            IndexedObject[] oldData = this.elementData;
            this.elementData = (IndexedObject[])Array.newInstance(this.componentType, this.size);
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    final synchronized Object get(int index) {
        return this.elementData[index];
    }

    final synchronized void set(int index, IndexedObject o) {
        IndexedObject oldElm = this.elementData[index];
        if (oldElm != null) {
            oldElm.listIdx[oldElm.getIdxUsed((VirtualUniverse)this.univ)][this.listType] = -1;
        }
        this.elementData[index] = o;
        int univIdx = o.getIdxUsed(this.univ);
        o.listIdx[univIdx][this.listType] = index;
        this.isDirty = true;
    }

    final synchronized void add(IndexedObject o) {
        if (this.elementData.length == this.size) {
            IndexedObject[] oldData = this.elementData;
            this.elementData = (IndexedObject[])Array.newInstance(this.componentType, this.size << 1);
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
        int univIdx = o.getIdxUsed(this.univ);
        int idx = this.size++;
        this.elementData[idx] = o;
        o.listIdx[univIdx][this.listType] = idx;
        this.isDirty = true;
    }

    final synchronized void remove(int index) {
        IndexedObject elm = this.elementData[index];
        int univIdx = elm.getIdxUsed(this.univ);
        elm.listIdx[univIdx][this.listType] = -1;
        --this.size;
        if (index != this.size) {
            elm = this.elementData[this.size];
            elm.listIdx[univIdx][this.listType] = index;
            this.elementData[index] = elm;
        }
        this.elementData[this.size] = null;
        this.isDirty = true;
    }

    final synchronized Object removeLastElement() {
        IndexedObject elm = this.elementData[--this.size];
        this.elementData[this.size] = null;
        elm.listIdx[elm.getIdxUsed((VirtualUniverse)this.univ)][this.listType] = -1;
        this.isDirty = true;
        return elm;
    }

    final synchronized boolean remove(IndexedObject o) {
        int univIdx = o.getIdxUsed(this.univ);
        int idx = o.listIdx[univIdx][this.listType];
        if (idx >= 0) {
            --this.size;
            if (idx != this.size) {
                IndexedObject elm;
                this.elementData[idx] = elm = this.elementData[this.size];
                elm.listIdx[elm.getIdxUsed((VirtualUniverse)this.univ)][this.listType] = idx;
            }
            this.elementData[this.size] = null;
            o.listIdx[univIdx][this.listType] = -1;
            this.isDirty = true;
            return true;
        }
        return false;
    }

    final synchronized void clear() {
        for (int i = this.size - 1; i >= 0; --i) {
            IndexedObject o = this.elementData[i];
            o.listIdx[o.getIdxUsed((VirtualUniverse)this.univ)][this.listType] = -1;
            this.elementData[i] = null;
        }
        this.size = 0;
        this.isDirty = true;
    }

    final synchronized void clearMirror() {
        if (this.cloneData != null) {
            for (int i = this.cloneData.length - 1; i >= 0; --i) {
                this.cloneData[i] = null;
            }
        }
        this.cloneSize = 0;
        this.isDirty = true;
    }

    final Class getComponentType() {
        return this.componentType;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.elementData.length);
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(this.elementData[i]);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        this.elementData = (IndexedObject[])Array.newInstance(this.componentType, arrayLength);
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = (IndexedObject)s.readObject();
        }
    }
}

