/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.assign.noisereduce;

import net.imagej.plugins.commands.assign.noisereduce.Neighborhood;
import net.imagej.plugins.commands.assign.noisereduce.WithinRadiusOfPointSetOriginCondition;
import net.imglib2.ops.condition.Condition;
import net.imglib2.ops.pointset.ConditionalPointSet;
import net.imglib2.ops.pointset.HyperVolumePointSet;
import net.imglib2.ops.pointset.PointSet;

public class RadialNeigh
implements Neighborhood {
    private final PointSet points;
    private final long radius;
    private final int numDims;

    public RadialNeigh(int numDims, long radius) {
        this.numDims = numDims;
        this.radius = radius;
        long[] posOff = new long[numDims];
        long[] negOff = new long[numDims];
        for (int i = 0; i < numDims; ++i) {
            posOff[i] = negOff[i] = radius - 1L;
        }
        HyperVolumePointSet space = new HyperVolumePointSet(new long[numDims], posOff, negOff);
        WithinRadiusOfPointSetOriginCondition condition = new WithinRadiusOfPointSetOriginCondition(radius, (PointSet)space);
        this.points = new ConditionalPointSet((PointSet)space, (Condition)condition);
    }

    @Override
    public PointSet getPoints() {
        return this.points;
    }

    @Override
    public String getDescription() {
        return "" + this.numDims + " dimensional " + this.radius + " pixel radial neighborhood";
    }
}

