/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.assign.noisereduce;

import net.imagej.plugins.commands.assign.noisereduce.Neighborhood;
import net.imagej.plugins.commands.assign.noisereduce.RectangularNeigh;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, label="Rectangular Neighborhood Specification", attrs={@Attr(name="no-legacy")})
public class RectangularNeighborhoodSpecifier
extends ContextCommand {
    @Parameter(label="Dimensionality")
    private int numDims;
    @Parameter(label="Neighborhood: positive width", min="0L")
    private long posX;
    @Parameter(label="Neighborhood: positive height", min="0L")
    private long posY;
    @Parameter(label="Neighborhood: negative width", min="0L")
    private long negX;
    @Parameter(label="Neighborhood: negative height", min="0L")
    private long negY;
    @Parameter(type=ItemIO.OUTPUT)
    private Neighborhood neighborhood;

    public void run() {
        long[] posOffsets = new long[this.numDims];
        long[] negOffsets = new long[this.numDims];
        posOffsets[0] = this.posX;
        negOffsets[0] = this.negX;
        posOffsets[1] = this.posY;
        negOffsets[1] = this.negY;
        this.neighborhood = new RectangularNeigh(posOffsets, negOffsets);
    }

    public void setDimensionality(int d) {
        this.numDims = d;
    }

    public long getDimensionality() {
        return this.numDims;
    }

    public void setPositiveX(long size) {
        this.posX = size;
    }

    public long getPositiveX() {
        return this.posX;
    }

    public void setNegativeX(long size) {
        this.negX = size;
    }

    public long getNegativeX() {
        return this.negX;
    }

    public void setPositiveY(long size) {
        this.posY = size;
    }

    public long getPositiveY() {
        return this.posY;
    }

    public void setNegativeY(long size) {
        this.negY = size;
    }

    public long getNegativeY() {
        return this.negY;
    }

    public Neighborhood getNeighborhood() {
        return this.neighborhood;
    }
}

