/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.renjin.compiler.ir.IRUtils;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.ExpressionVisitor;
import org.renjin.compiler.ir.tac.expressions.LValue;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.eval.Context;
import org.renjin.sexp.SEXP;

public class Temp
implements LValue {
    private static final String TAO = "\u03c4";
    private final int index;

    public Temp(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public Object retrieveValue(Context context, Object[] temps) {
        return temps[this.index];
    }

    @Override
    public void setValue(Context context, Object[] temp, Object value) {
        temp[this.index] = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(TAO);
        IRUtils.appendSubscript(sb, this.index + 1);
        return sb.toString();
    }

    @Override
    public Set<Variable> variables() {
        return Collections.emptySet();
    }

    @Override
    public void setChild(int i, Expression expr) {
        throw new IllegalArgumentException();
    }

    @Override
    public Temp replaceVariable(Variable name, Variable newName) {
        return this;
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Temp other = (Temp)obj;
        return this.index == other.index;
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitTemp(this);
    }

    @Override
    public SEXP getSExpression() {
        throw new UnsupportedOperationException();
    }
}

