/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection.converters;

import org.renjin.invoke.reflection.converters.BooleanArrayConverter;
import org.renjin.invoke.reflection.converters.BooleanConverter;
import org.renjin.invoke.reflection.converters.CollectionConverter;
import org.renjin.invoke.reflection.converters.Converter;
import org.renjin.invoke.reflection.converters.DoubleArrayConverter;
import org.renjin.invoke.reflection.converters.DoubleConverter;
import org.renjin.invoke.reflection.converters.EnumConverter;
import org.renjin.invoke.reflection.converters.IntegerArrayConverter;
import org.renjin.invoke.reflection.converters.IntegerConverter;
import org.renjin.invoke.reflection.converters.LongConverter;
import org.renjin.invoke.reflection.converters.ObjectConverter;
import org.renjin.invoke.reflection.converters.ObjectOfASpecificClassConverter;
import org.renjin.invoke.reflection.converters.SexpConverter;
import org.renjin.invoke.reflection.converters.StringArrayConverter;
import org.renjin.invoke.reflection.converters.StringConverter;
import org.renjin.sexp.SEXP;

public class Converters {
    public static Converter get(Class clazz) {
        if (StringConverter.accept(clazz)) {
            return StringConverter.INSTANCE;
        }
        if (BooleanConverter.accept(clazz)) {
            return BooleanConverter.INSTANCE;
        }
        if (IntegerConverter.accept(clazz)) {
            return IntegerConverter.INSTANCE;
        }
        if (LongConverter.accept(clazz)) {
            return LongConverter.INSTANCE;
        }
        if (DoubleConverter.accept(clazz)) {
            return DoubleConverter.INSTANCE;
        }
        if (SexpConverter.acceptsJava(clazz)) {
            return new SexpConverter(clazz);
        }
        if (EnumConverter.accept(clazz)) {
            return new EnumConverter(clazz);
        }
        if (CollectionConverter.accept(clazz)) {
            return new CollectionConverter();
        }
        if (StringArrayConverter.accept(clazz)) {
            return StringArrayConverter.INSTANCE;
        }
        if (BooleanArrayConverter.accept(clazz)) {
            return BooleanArrayConverter.INSTANCE;
        }
        if (IntegerArrayConverter.accept(clazz)) {
            return IntegerArrayConverter.INSTANCE;
        }
        if (DoubleArrayConverter.accept(clazz)) {
            return new DoubleArrayConverter(clazz);
        }
        if (ObjectConverter.accept(clazz)) {
            return ObjectConverter.INSTANCE;
        }
        return new ObjectOfASpecificClassConverter(clazz);
    }

    public static SEXP fromJava(Object obj) {
        return Converters.get(obj.getClass()).convertToR(obj);
    }
}

