/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Generic;
import org.renjin.invoke.annotations.Internal;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Sort {
    @Internal
    public static Vector sort(StringVector x, boolean decreasing) {
        if (x.getAttribute(Symbols.NAMES) != Null.INSTANCE) {
            throw new EvalException("sorting of vectors with names not yet implemented!", new Object[0]);
        }
        Object[] sorted = x.toArray();
        if (decreasing) {
            Arrays.sort(sorted, Collections.reverseOrder());
        } else {
            Arrays.sort(sorted);
        }
        return new StringArrayVector((String[])sorted, x.getAttributes());
    }

    @Internal
    public static Vector sort(DoubleVector x, boolean decreasing) {
        if (x.getAttribute(Symbols.NAMES) != Null.INSTANCE) {
            throw new EvalException("sorting of vectors with names not yet implemented!", new Object[0]);
        }
        double[] sorted = x.toDoubleArray();
        Arrays.sort(sorted);
        if (decreasing) {
            Sort.reverse(sorted);
        }
        return (Vector)DoubleArrayVector.unsafe(sorted).setAttributes(x.getAttributes());
    }

    private static void reverse(double[] b) {
        int left = 0;
        for (int right = b.length - 1; left < right; ++left, --right) {
            double temp = b[left];
            b[left] = b[right];
            b[right] = temp;
        }
    }

    @Internal
    public static Vector sort(IntVector x, boolean decreasing) {
        if (x.getAttribute(Symbols.NAMES) != Null.INSTANCE) {
            throw new EvalException("sorting of vectors with names not yet implemented!", new Object[0]);
        }
        int[] sorted = x.toIntArray();
        Arrays.sort(sorted);
        if (decreasing) {
            Sort.reverse(sorted);
        }
        return new IntArrayVector(sorted, x.getAttributes());
    }

    @Internal(value="is.unsorted")
    public static boolean isUnsorted(AtomicVector x, boolean strictly) {
        for (int i = 1; i < x.length(); ++i) {
            int z = x.compare(i - 1, i);
            if (z > 0) {
                return true;
            }
            if (!strictly || z != 0) continue;
            return true;
        }
        return false;
    }

    @Internal(value="is.unsorted")
    public static LogicalVector isUnsorted(ListVector x, boolean strictly) {
        return LogicalVector.NA_VECTOR;
    }

    @Internal
    public static DoubleVector qsort(DoubleVector x, LogicalVector returnIndexes) {
        if (returnIndexes.isElementTrue(0)) {
            throw new EvalException("qsort(indexes=TRUE) not yet implemented", new Object[0]);
        }
        double[] values = x.toDoubleArray();
        Arrays.sort(values);
        DoubleArrayVector sorted = new DoubleArrayVector(values, x.getAttributes());
        return (DoubleVector)sorted.setAttribute(Symbols.NAMES, (SEXP)Null.INSTANCE);
    }

    @Internal
    public static DoubleVector psort(DoubleVector x, Vector indexes) {
        return Sort.qsort(x, LogicalVector.FALSE);
    }

    @Internal
    public static IntVector qsort(IntVector x, LogicalVector returnIndexes) {
        if (returnIndexes.isElementTrue(0)) {
            throw new EvalException("qsort(indexes=TRUE) not yet implemented", new Object[0]);
        }
        int[] values = x.toIntArray();
        Arrays.sort(values);
        IntArrayVector sorted = new IntArrayVector(values, x.getAttributes());
        return (IntVector)sorted.setAttribute(Symbols.NAMES, (SEXP)Null.INSTANCE);
    }

    @Internal
    public static IntVector psort(IntVector x, Vector indexes) {
        return Sort.qsort(x, LogicalVector.FALSE);
    }

    @Internal
    public static LogicalVector qsort(LogicalVector x, boolean returnIndexes) {
        if (returnIndexes) {
            throw new EvalException("qsort(indexes=TRUE) not yet implemented", new Object[0]);
        }
        int[] array2 = x.toIntArray();
        Arrays.sort(array2);
        LogicalArrayVector sorted = new LogicalArrayVector(array2, x.getAttributes());
        return (LogicalVector)sorted.setAttribute(Symbols.NAMES, (SEXP)Null.INSTANCE);
    }

    @Internal
    public static LogicalVector psort(LogicalVector x, Vector indexes) {
        return Sort.qsort(x, false);
    }

    private static void reverse(int[] b) {
        int left = 0;
        for (int right = b.length - 1; left < right; ++left, --right) {
            int temp = b[left];
            b[left] = b[right];
            b[right] = temp;
        }
    }

    @Internal
    public static Vector order(boolean naLast, final boolean decreasing, final @ArgumentList ListVector columns) {
        if (columns.length() == 0) {
            return Null.INSTANCE;
        }
        int numRows = columns.getElementAsSEXP(0).length();
        for (int i = 0; i != columns.length(); ++i) {
            if (columns.getElementAsSEXP(i).length() == numRows) continue;
            throw new EvalException("argument lengths differ", new Object[0]);
        }
        ArrayList ordering = Lists.newArrayListWithCapacity((int)numRows);
        for (int i = 0; i != numRows; ++i) {
            ordering.add(i);
        }
        Collections.sort(ordering, new Comparator<Integer>(){

            @Override
            public int compare(Integer row1, Integer row2) {
                int rel;
                int col2 = 0;
                while ((rel = this.compare(row1, row2, col2)) == 0) {
                    if (++col2 != columns.length()) continue;
                    return 0;
                }
                return decreasing ? -rel : rel;
            }

            private int compare(Integer row1, Integer row2, int col2) {
                return ((AtomicVector)columns.get(col2)).compare(row1, row2);
            }
        });
        IntArrayVector.Builder result = new IntArrayVector.Builder();
        for (Integer index : ordering) {
            result.add(index + 1);
        }
        return result.build();
    }

    @Internal(value="which.min")
    public static IntVector whichMin(Vector v) {
        if (v.length() == 0) {
            IntArrayVector.Builder b = new IntArrayVector.Builder();
            return b.build();
        }
        int minIndex = 0;
        double globalMin = v.getElementAsDouble(0);
        for (int i = 0; i < v.length(); ++i) {
            if (!(v.getElementAsDouble(i) < globalMin)) continue;
            globalMin = v.getElementAsDouble(i);
            minIndex = i;
        }
        return new IntArrayVector(minIndex + 1);
    }

    @Internal(value="which.max")
    public static IntVector whichMax(Vector v) {
        if (v.length() == 0) {
            IntArrayVector.Builder b = new IntArrayVector.Builder();
            return b.build();
        }
        int maxIndex = 0;
        double globalMax = v.getElementAsDouble(0);
        for (int i = 0; i < v.length(); ++i) {
            if (!(v.getElementAsDouble(i) > globalMax)) continue;
            globalMax = v.getElementAsDouble(i);
            maxIndex = i;
        }
        return new IntArrayVector(maxIndex + 1);
    }

    @Builtin
    @Generic
    public static SEXP xtfrm(@Current Context context, SEXP x) {
        FunctionCall defaultCall = FunctionCall.newCall(Symbol.get("xtfrm.default"), x);
        return context.evaluate(defaultCall);
    }
}

