/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.vector;

import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class BinCodeVector
extends IntVector {
    private Vector x;
    private double[] breaks;
    private boolean left;
    private boolean includeBorder;

    public BinCodeVector(Vector x, double[] breaks, boolean left, boolean includeBorder, AttributeMap attributes2) {
        super(attributes2);
        this.x = x;
        this.breaks = breaks;
        this.left = left;
        this.includeBorder = includeBorder;
    }

    @Override
    public int length() {
        return this.x.length();
    }

    @Override
    public int getElementAsInt(int i) {
        if (!this.x.isElementNA(i)) {
            boolean outOfBounds;
            int lo = 0;
            int hi = this.breaks.length - 1;
            double xi = this.x.getElementAsDouble(i);
            boolean bl = xi < this.breaks[lo] || this.breaks[hi] < xi || xi == this.breaks[this.left ? hi : lo] && !this.includeBorder ? true : (outOfBounds = false);
            if (!outOfBounds) {
                while (hi - lo >= 2) {
                    int code = (hi + lo) / 2;
                    if (xi > this.breaks[code] || this.left && xi == this.breaks[code]) {
                        lo = code;
                        continue;
                    }
                    hi = code;
                }
                return lo + 1;
            }
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new BinCodeVector(this.x, this.breaks, this.left, this.includeBorder, attributes2);
    }
}

