/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import org.renjin.eval.EvalException;
import org.renjin.invoke.ClassBinding;
import org.renjin.invoke.ClassBindings;
import org.renjin.invoke.reflection.MemberBinding;
import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.Symbol;

public final class ExternalPtr<T>
extends AbstractSEXP {
    private final T instance;
    private final ClassBinding binding;

    public ExternalPtr(T instance, AttributeMap attributes2) {
        super(attributes2);
        this.instance = instance;
        this.binding = instance == null ? null : (instance instanceof Class ? ClassBindings.getClassDefinitionBinding((Class)instance) : ClassBindings.getClassBinding(instance.getClass()));
    }

    public ExternalPtr(T instance) {
        this(instance, AttributeMap.EMPTY);
    }

    @Override
    public String getTypeName() {
        return "externalptr";
    }

    private MemberBinding getMemberBinding(Symbol name) {
        if (this.binding == null) {
            throw new EvalException("ExternalPtr is NULL for name " + name.getPrintName(), new Object[0]);
        }
        return this.binding.getMemberBinding(name);
    }

    public SEXP getMember(Symbol name) {
        return this.getMemberBinding(name).getValue(this.instance);
    }

    public void setMember(Symbol name, SEXP value) {
        this.getMemberBinding(name).setValue(this.instance, value);
    }

    public T getInstance() {
        return this.instance;
    }

    @Override
    public void accept(SexpVisitor visitor) {
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        this.attributes = attributes2;
        return this;
    }
}

