/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.scicomp.n5.zstandard;

import com.github.luben.zstd.BufferPool;
import com.github.luben.zstd.NoPool;
import com.github.luben.zstd.RecyclingBufferPool;
import com.github.luben.zstd.ZstdCompressCtx;
import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.janelia.saalfeldlab.n5.BlockReader;
import org.janelia.saalfeldlab.n5.BlockWriter;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DefaultBlockReader;
import org.janelia.saalfeldlab.n5.DefaultBlockWriter;

@Compression.CompressionType(value="zstd")
public class ZstandardCompression
implements DefaultBlockReader,
DefaultBlockWriter,
Compression {
    private static final long serialVersionUID = 5811954066059985371L;
    public static final int ZSTD_CLEVEL_DEFAULT = 3;
    @Compression.CompressionParameter
    private int level = 3;
    private int nbWorkers = 0;
    private int windowLog = 0;
    private int hashLog = 0;
    private int chainLog = 0;
    private int searchLog = 0;
    private int minMatch = 0;
    private int targetLength = 0;
    private int strategy = 0;
    private int jobSize = 0;
    private int overlapLog = 0;
    private boolean useChecksums = false;
    private boolean setCloseFrameOnFlush = false;
    private byte[] dict = null;
    private BufferPool bufferPool = NoPool.INSTANCE;
    private boolean advancedParameterSet = false;

    public ZstandardCompression() {
        this(3);
    }

    public ZstandardCompression(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getNbWorkers() {
        return this.nbWorkers;
    }

    public void setNbWorkers(int nbWorkers) {
        this.nbWorkers = nbWorkers;
        this.advancedParameterSet = true;
    }

    public int getWindowLog() {
        return this.windowLog;
    }

    public void setWindowLog(int windowLog) {
        this.windowLog = windowLog;
        this.advancedParameterSet = true;
    }

    public int getHashLog() {
        return this.hashLog;
    }

    public void setHashLog(int hashLog) {
        this.hashLog = hashLog;
        this.advancedParameterSet = true;
    }

    public int getChainLog() {
        return this.chainLog;
    }

    public void setChainLog(int chainLog) {
        this.chainLog = chainLog;
        this.advancedParameterSet = true;
    }

    public int getSearchLog() {
        return this.searchLog;
    }

    public void setSearchLog(int searchLog) {
        this.searchLog = searchLog;
        this.advancedParameterSet = true;
    }

    public int getMinMatch() {
        return this.minMatch;
    }

    public void setMinMatch(int minMatch) {
        this.minMatch = minMatch;
        this.advancedParameterSet = true;
    }

    public int getTargetLength() {
        return this.targetLength;
    }

    public void setTargetLength(int targetLength) {
        this.targetLength = targetLength;
        this.advancedParameterSet = true;
    }

    public int getStrategy() {
        return this.strategy;
    }

    public void setStrategy(int strategy) {
        this.strategy = strategy;
        this.advancedParameterSet = true;
    }

    public int getJobSize() {
        return this.jobSize;
    }

    public void setJobSize(int jobSize) {
        this.jobSize = jobSize;
        this.advancedParameterSet = true;
    }

    public int getOverlapLog() {
        return this.overlapLog;
    }

    public void setOverlapLog(int overlapLog) {
        this.overlapLog = overlapLog;
        this.advancedParameterSet = true;
    }

    public boolean isUseChecksums() {
        return this.useChecksums;
    }

    public void setUseChecksums(boolean useChecksums) {
        this.useChecksums = useChecksums;
        this.advancedParameterSet = true;
    }

    public boolean isSetCloseFrameOnFlush() {
        return this.setCloseFrameOnFlush;
    }

    public void setSetCloseFrameOnFlush(boolean setCloseFrameOnFlush) {
        this.setCloseFrameOnFlush = setCloseFrameOnFlush;
        this.advancedParameterSet = true;
    }

    public byte[] getDict() {
        return this.dict;
    }

    public void setDict(byte[] dict) {
        this.dict = dict;
        this.advancedParameterSet = true;
    }

    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public void useRecyclingBufferPool(boolean useRecycling) {
        this.bufferPool = useRecycling ? RecyclingBufferPool.INSTANCE : NoPool.INSTANCE;
    }

    public void setBufferPool(BufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    public BlockReader getReader() {
        return this;
    }

    public BlockWriter getWriter() {
        return this;
    }

    public OutputStream getOutputStream(OutputStream out) throws IOException {
        ZstdOutputStream zstdOut = new ZstdOutputStream(out, this.bufferPool);
        if (this.level != 0) {
            zstdOut.setLevel(this.level);
        }
        if (this.advancedParameterSet) {
            if (this.nbWorkers != 0) {
                zstdOut.setWorkers(this.nbWorkers);
            }
            if (this.windowLog != 0) {
                zstdOut.setLong(this.windowLog);
            }
            if (this.hashLog != 0) {
                zstdOut.setHashLog(this.hashLog);
            }
            if (this.chainLog != 0) {
                zstdOut.setChainLog(this.chainLog);
            }
            if (this.searchLog != 0) {
                zstdOut.setSearchLog(this.searchLog);
            }
            if (this.minMatch != 0) {
                zstdOut.setMinMatch(this.minMatch);
            }
            if (this.targetLength != 0) {
                zstdOut.setTargetLength(this.targetLength);
            }
            if (this.strategy != 0) {
                zstdOut.setStrategy(this.strategy);
            }
            if (this.jobSize != 0) {
                zstdOut.setJobSize(this.jobSize);
            }
            if (this.overlapLog != 0) {
                zstdOut.setOverlapLog(this.overlapLog);
            }
            if (this.useChecksums) {
                zstdOut.setChecksum(this.useChecksums);
            }
            if (this.setCloseFrameOnFlush) {
                zstdOut.setCloseFrameOnFlush(this.setCloseFrameOnFlush);
            }
            if (this.dict != null) {
                zstdOut.setDict(this.dict);
            }
        }
        return zstdOut;
    }

    public InputStream getInputStream(InputStream in) throws IOException {
        ZstdInputStream zstdIn = new ZstdInputStream(in, this.bufferPool);
        zstdIn.setLongMax(this.windowLog);
        if (this.dict != null) {
            zstdIn.setDict(this.dict);
        }
        return zstdIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void write(DataBlock<T> dataBlock, OutputStream out) throws IOException {
        ByteBuffer buffer = dataBlock.toByteBuffer();
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.setLevel(this.level);
            if (this.advancedParameterSet) {
                if (this.chainLog != 0) {
                    ctx.setChainLog(this.chainLog);
                }
                if (this.useChecksums) {
                    ctx.setChecksum(this.useChecksums);
                }
                if (this.hashLog != 0) {
                    ctx.setHashLog(this.hashLog);
                }
                if (this.jobSize != 0) {
                    ctx.setJobSize(this.jobSize);
                }
                if (this.windowLog != 0) {
                    ctx.setLong(this.windowLog);
                }
                if (this.minMatch != 0) {
                    ctx.setMinMatch(this.minMatch);
                }
                if (this.overlapLog != 0) {
                    ctx.setOverlapLog(this.overlapLog);
                }
                if (this.searchLog != 0) {
                    ctx.setSearchLog(this.searchLog);
                }
                if (this.strategy != 0) {
                    ctx.setStrategy(this.strategy);
                }
                if (this.targetLength != 0) {
                    ctx.setTargetLength(this.targetLength);
                }
                if (this.windowLog != 0) {
                    ctx.setWindowLog(this.windowLog);
                }
                if (this.nbWorkers != 0) {
                    ctx.setWorkers(this.nbWorkers);
                }
            }
            byte[] outputBuffer = ctx.compress(buffer.array());
            out.write(outputBuffer);
            out.flush();
        }
    }
}

