/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.network.server;

import edu.utexas.clm.archipelago.Cluster;
import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.listen.ClusterStateListener;
import edu.utexas.clm.archipelago.listen.NodeShellListener;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class ArchipelagoServer
implements ClusterStateListener {
    private static ArchipelagoServer server = null;
    private NodeShellListener nodeListener;
    private ServerSocket socket;
    private int port;
    private AtomicBoolean isRunning;
    private Thread listenThread;
    private final ReentrantLock lock = new ReentrantLock();

    private ArchipelagoServer(NodeShellListener listener, int p) {
        this.nodeListener = listener;
        this.socket = null;
        this.isRunning = new AtomicBoolean(false);
        this.port = p;
    }

    public boolean active() {
        return this.isRunning.get();
    }

    public boolean start() {
        if (this.isRunning.get()) {
            return true;
        }
        int origPort = this.port;
        boolean success = false;
        IOException ioe = null;
        while (!success && this.port - origPort < 10) {
            try {
                this.socket = new ServerSocket(this.port);
                FijiArchipelago.debug("Started server on port " + this.port);
                success = true;
            }
            catch (IOException e) {
                ++this.port;
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (!success) {
            this.port = -1;
            return false;
        }
        this.listenThread = new ListenThread(this.socket);
        this.listenThread.start();
        this.isRunning.set(true);
        return true;
    }

    public synchronized void close() {
        if (this.isRunning.get()) {
            this.isRunning.set(false);
            this.listenThread.interrupt();
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean join() {
        try {
            this.listenThread.join();
            return true;
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void stateChanged(Cluster cluster) {
        Cluster.ClusterState state = cluster.getState();
        final ArchipelagoServer thisServer = this;
        if (state == Cluster.ClusterState.STOPPING || state == Cluster.ClusterState.STOPPED) {
            new Thread(){

                @Override
                public void run() {
                    server = null;
                    Cluster.getCluster().removeStateListener(thisServer);
                    ArchipelagoServer.this.close();
                }
            }.start();
        }
    }

    public void setListener(NodeShellListener listener) {
        this.lock.lock();
        this.nodeListener = listener;
        this.lock.unlock();
    }

    public static synchronized ArchipelagoServer getServer(NodeShellListener listener) {
        if (server == null) {
            server = new ArchipelagoServer(listener, 4012);
            server.start();
            Cluster.getCluster().addStateListener(server);
        } else if (listener != ArchipelagoServer.server.nodeListener) {
            server.setListener(listener);
        }
        return server;
    }

    private class ListenThread
    extends Thread {
        private final ServerSocket socket;

        public ListenThread(ServerSocket ins) {
            this.socket = ins;
        }

        @Override
        public void run() {
            while (ArchipelagoServer.this.isRunning.get()) {
                try {
                    Socket clientSocket = this.socket.accept();
                    FijiArchipelago.log("ArchipelagoServer: Received connection from " + this.socket.getInetAddress());
                    ArchipelagoServer.this.lock.lock();
                    ArchipelagoServer.this.nodeListener.ioStreamsReady(clientSocket.getInputStream(), clientSocket.getOutputStream());
                    ArchipelagoServer.this.lock.unlock();
                }
                catch (IOException ioe) {
                    FijiArchipelago.log("ArchipelagoServer: IOException: " + ioe);
                }
            }
        }
    }
}

