/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.brush;

import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.DiamondShape;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;
import sc.fiji.labkit.ui.labeling.Label;

class FloodFill {
    FloodFill() {
    }

    public static void doFloodFillOnActiveLabels(RandomAccessibleInterval<LabelingType<Label>> labeling, Point seed, Consumer<? super LabelingType<Label>> operation) {
        LabelingType seedValue = FloodFill.getPixel(labeling, (Localizable)seed).copy();
        Predicate<LabelingType> visit = arg_0 -> FloodFill.lambda$doFloodFillOnActiveLabels$0((Set)seedValue, arg_0);
        FloodFill.cachedFloodFill(labeling, (Localizable)seed, visit, operation);
    }

    static <T> void cachedFloodFill(RandomAccessibleInterval<LabelingType<T>> image, Localizable seed, Predicate<? super LabelingType<T>> visit, Consumer<? super LabelingType<T>> operation) {
        CacheForPredicateLabelingType cachedVisit = new CacheForPredicateLabelingType(visit);
        CacheForOperationLabelingType cachedOperation = new CacheForOperationLabelingType(operation);
        FloodFill.doFloodFill(image, seed, cachedVisit, cachedOperation);
    }

    private static <T extends Type<T>> void doFloodFill(RandomAccessibleInterval<T> image, Localizable seed, Predicate<T> visit, Consumer<T> operation) {
        RandomAccess ra = image.randomAccess();
        ra.setPosition(seed);
        Type seedValue = ((Type)ra.get()).copy();
        Type seedValueChanged = seedValue.copy();
        operation.accept(seedValueChanged);
        if (visit.test(seedValueChanged)) {
            return;
        }
        BiPredicate<Type, Type> filter = (f, s) -> visit.test((Type)f);
        ExtendedRandomAccessibleInterval target = Views.extendValue(image, (Type)seedValueChanged);
        DiamondShape shape = new DiamondShape(1L);
        net.imglib2.algorithm.fill.FloodFill.fill((RandomAccessible)target, (RandomAccessible)target, (Localizable)seed, (Shape)shape, filter, operation);
    }

    private static boolean activeLabelsAreEquals(LabelingType<Label> a, Set<Label> b) {
        boolean bIsSubSetOfA = b.stream().filter(Label::isVisible).allMatch(arg_0 -> a.contains(arg_0));
        boolean aIsSubSetOfB = a.stream().filter(Label::isVisible).allMatch(b::contains);
        return aIsSubSetOfB && bIsSubSetOfA;
    }

    private static <T> T getPixel(RandomAccessible<T> image, Localizable position) {
        RandomAccess ra = image.randomAccess();
        ra.setPosition(position);
        return (T)ra.get();
    }

    public static boolean isBackgroundFloodFill(RandomAccessibleInterval<LabelingType<Label>> frame, Point seed, Consumer<Set<Label>> operation) {
        LabelingType seedValue = (LabelingType)frame.randomAccess().setPositionAndGet((Localizable)seed);
        LabelingType changedSeedValue = seedValue.copy();
        operation.accept((Set<Label>)changedSeedValue);
        long numberOfActiveLabelsBefore = seedValue.stream().filter(Label::isVisible).count();
        long numberOfActiveLabelsAfter = changedSeedValue.stream().filter(Label::isVisible).count();
        boolean isBackgroundFill = numberOfActiveLabelsBefore == 0L;
        boolean operationHasEffect = numberOfActiveLabelsAfter > 0L;
        return isBackgroundFill && operationHasEffect;
    }

    private static /* synthetic */ boolean lambda$doFloodFillOnActiveLabels$0(Set seedValue, LabelingType value) {
        return FloodFill.activeLabelsAreEquals((LabelingType<Label>)value, seedValue);
    }

    private static class CacheForOperationLabelingType<T>
    implements Consumer<LabelingType<T>> {
        private final Consumer<? super LabelingType<T>> operation;
        private final TIntIntMap cache = new TIntIntHashMap();
        private final int noEntryValue = this.cache.getNoEntryValue();

        private CacheForOperationLabelingType(Consumer<? super LabelingType<T>> operation) {
            this.operation = operation;
        }

        @Override
        public void accept(LabelingType<T> value) {
            IntegerType valueIndex = value.getIndex();
            int input = valueIndex.getInteger();
            int cached = this.cache.get(input);
            if (cached == this.noEntryValue) {
                this.operation.accept(value);
                this.cache.put(input, valueIndex.getInteger());
            } else {
                valueIndex.setInteger(cached);
            }
        }
    }

    private static class CacheForPredicateLabelingType<T>
    implements Predicate<LabelingType<T>> {
        private final Predicate<? super LabelingType<T>> predicate;
        private final TIntIntMap cache = new TIntIntHashMap();
        private final int noEntryValue = this.cache.getNoEntryValue();

        CacheForPredicateLabelingType(Predicate<? super LabelingType<T>> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean test(LabelingType<T> ts) {
            int input = ts.getIndex().getInteger();
            int cached = this.cache.get(input);
            if (cached == this.noEntryValue) {
                boolean value = this.predicate.test(ts);
                this.cache.put(input, value ? 1 : 0);
                return value;
            }
            return cached == 1;
        }
    }
}

