/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.volatiles;

import net.imglib2.cache.volatiles.LoadingStrategy;

public class CacheHints {
    private final LoadingStrategy loadingStrategy;
    private final int queuePriority;
    private final boolean enqueuToFront;
    private final int hashcode;

    public CacheHints(LoadingStrategy loadingStrategy, int queuePriority, boolean enqueuToFront) {
        this.loadingStrategy = loadingStrategy;
        this.queuePriority = queuePriority;
        this.enqueuToFront = enqueuToFront;
        int value = loadingStrategy.hashCode();
        value = 31 * value + queuePriority;
        this.hashcode = value = 31 * value + Boolean.hashCode(enqueuToFront);
    }

    public LoadingStrategy getLoadingStrategy() {
        return this.loadingStrategy;
    }

    public int getQueuePriority() {
        return this.queuePriority;
    }

    public boolean isEnqueuToFront() {
        return this.enqueuToFront;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CacheHints)) {
            return false;
        }
        CacheHints that = (CacheHints)other;
        return this.loadingStrategy == that.loadingStrategy && this.queuePriority == that.queuePriority && this.enqueuToFront == that.enqueuToFront;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        return "(" + (Object)((Object)this.loadingStrategy) + ", " + this.queuePriority + ", " + Boolean.toString(this.enqueuToFront) + ")";
    }
}

