/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.NodeComponent;
import org.jogamp.java3d.Shader;
import org.jogamp.java3d.ShaderError;
import org.jogamp.java3d.ShaderErrorListener;

public abstract class ShaderProgram
extends NodeComponent {
    public static final int ALLOW_SHADERS_READ = 0;
    public static final int ALLOW_NAMES_READ = 1;
    private static final int[] readCapabilities = new int[]{0, 1};
    private static ShaderErrorListener defaultErrorListener = null;

    ShaderProgram() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public abstract void setVertexAttrNames(String[] var1);

    public abstract String[] getVertexAttrNames();

    public abstract void setShaderAttrNames(String[] var1);

    public abstract String[] getShaderAttrNames();

    public abstract void setShaders(Shader[] var1);

    public abstract Shader[] getShaders();

    static synchronized ShaderErrorListener getDefaultErrorListener() {
        if (defaultErrorListener == null) {
            defaultErrorListener = new DefaultErrorListener();
        }
        return defaultErrorListener;
    }

    static class DefaultErrorListener
    implements ShaderErrorListener {
        DefaultErrorListener() {
        }

        @Override
        public void errorOccurred(ShaderError error) {
            System.err.println();
            System.err.println("DefaultShaderErrorListener.errorOccurred:");
            error.printVerbose();
        }
    }
}

