/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.detection.MaskUtils;
import fiji.plugin.trackmate.detection.SpotDetector;
import java.util.ArrayList;
import java.util.List;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.MultiThreaded;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;

public class ThresholdDetector<T extends RealType<T> & NativeType<T>>
implements SpotDetector<T>,
MultiThreaded {
    private static final String BASE_ERROR_MESSAGE = "ThresholdDetector: ";
    protected RandomAccessible<T> input;
    protected String baseErrorMessage = "ThresholdDetector: ";
    protected String errorMessage;
    protected List<Spot> spots = new ArrayList<Spot>();
    protected long processingTime;
    protected int numThreads;
    protected final Interval interval;
    protected final double[] calibration;
    protected final double threshold;
    protected final boolean simplify;

    public ThresholdDetector(RandomAccessible<T> input, Interval interval, double[] calibration, double threshold, boolean simplify) {
        this.input = input;
        this.interval = DetectionUtils.squeeze(interval);
        this.calibration = calibration;
        this.threshold = threshold;
        this.simplify = simplify;
    }

    public List<Spot> getResult() {
        return this.spots;
    }

    public boolean checkInput() {
        if (null == this.input) {
            this.errorMessage = this.baseErrorMessage + "Image is null.";
            return false;
        }
        if (this.input.numDimensions() > 3 || this.input.numDimensions() < 2) {
            this.errorMessage = this.baseErrorMessage + "Image must be 2D or 3D, got " + this.input.numDimensions() + "D.";
            return false;
        }
        return true;
    }

    public boolean process() {
        long start = System.currentTimeMillis();
        if (this.input.numDimensions() == 2) {
            this.spots = MaskUtils.fromThresholdWithROI(this.input, this.interval, this.calibration, this.threshold, this.simplify, this.numThreads, null);
        } else if (this.input.numDimensions() == 3) {
            this.spots = MaskUtils.fromThreshold(this.input, this.interval, this.calibration, this.threshold, this.numThreads);
        } else {
            this.errorMessage = this.baseErrorMessage + "Required a 2D or 3D input, got " + this.input.numDimensions() + "D.";
            return false;
        }
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public int getNumThreads() {
        return this.numThreads;
    }
}

