/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features.track;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.FeatureModel;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.features.track.TrackAnalyzer;
import fiji.plugin.trackmate.util.Threads;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.swing.ImageIcon;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.scijava.plugin.Plugin;

@Plugin(type=TrackAnalyzer.class, priority=-100.0)
public class TrackMotilityAnalyzer
implements TrackAnalyzer {
    public static final String KEY = "Track motility analysis";
    public static final String TRACK_TOTAL_DISTANCE_TRAVELED = "TOTAL_DISTANCE_TRAVELED";
    public static final String TRACK_MAX_DISTANCE_TRAVELED = "MAX_DISTANCE_TRAVELED";
    public static final String TRACK_CONFINEMENT_RATIO = "CONFINEMENT_RATIO";
    public static final String TRACK_MEAN_STRAIGHT_LINE_SPEED = "MEAN_STRAIGHT_LINE_SPEED";
    public static final String TRACK_LINEARITY_OF_FORWARD_PROGRESSION = "LINEARITY_OF_FORWARD_PROGRESSION";
    public static final String TRACK_MEAN_DIRECTIONAL_CHANGE_RATE = "MEAN_DIRECTIONAL_CHANGE_RATE";
    public static final List<String> FEATURES = new ArrayList<String>(6);
    public static final Map<String, String> FEATURE_NAMES = new HashMap<String, String>(FEATURES.size());
    public static final Map<String, String> FEATURE_SHORT_NAMES = new HashMap<String, String>(FEATURES.size());
    public static final Map<String, Dimension> FEATURE_DIMENSIONS = new HashMap<String, Dimension>(FEATURES.size());
    public static final Map<String, Boolean> IS_INT = new HashMap<String, Boolean>(FEATURES.size());
    private int numThreads;
    private long processingTime;

    public TrackMotilityAnalyzer() {
        this.setNumThreads();
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public Map<String, Dimension> getFeatureDimensions() {
        return FEATURE_DIMENSIONS;
    }

    @Override
    public Map<String, String> getFeatureNames() {
        return FEATURE_NAMES;
    }

    @Override
    public Map<String, String> getFeatureShortNames() {
        return FEATURE_SHORT_NAMES;
    }

    @Override
    public List<String> getFeatures() {
        return FEATURES;
    }

    @Override
    public Map<String, Boolean> getIsIntFeature() {
        return IS_INT;
    }

    @Override
    public boolean isManualFeature() {
        return false;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getInfoText() {
        return null;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String getName() {
        return KEY;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public void process(Collection<Integer> trackIDs, final Model model) {
        if (trackIDs.isEmpty()) {
            return;
        }
        long start = System.currentTimeMillis();
        ArrayList<Object> tasks = new ArrayList<Object>(trackIDs.size());
        for (final Integer trackID : trackIDs) {
            Callable<Void> task = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    TrackMotilityAnalyzer.analyze(trackID, model);
                    return null;
                }
            };
            tasks.add(task);
        }
        ExecutorService executorService = Threads.newFixedThreadPool(this.numThreads);
        try {
            List futures = executorService.invokeAll(tasks);
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        executorService.shutdown();
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
    }

    private static final void analyze(Integer trackID, Model model) {
        FeatureModel fm = model.getFeatureModel();
        ArrayList<Spot> spots = new ArrayList<Spot>(model.getTrackModel().trackSpots(trackID));
        Collections.sort(spots, Spot.frameComparator);
        Spot first = (Spot)spots.get(0);
        Set<DefaultWeightedEdge> edges = model.getTrackModel().trackEdges(trackID);
        double totalDistance = 0.0;
        double maxDistanceSq = Double.NEGATIVE_INFINITY;
        double maxDistance = 0.0;
        double sumAngleSpeed = 0.0;
        int nAngleSpeed = 0;
        for (DefaultWeightedEdge edge : edges) {
            Double val;
            Spot source = model.getTrackModel().getEdgeSource(edge);
            Spot target = model.getTrackModel().getEdgeTarget(edge);
            double d = Math.sqrt(source.squareDistanceTo(target));
            totalDistance += d;
            double dToFirstSq = first.squareDistanceTo(target);
            if (dToFirstSq > maxDistanceSq) {
                maxDistanceSq = dToFirstSq;
                maxDistance = Math.sqrt(maxDistanceSq);
            }
            if (null == (val = fm.getEdgeFeature(edge, "DIRECTIONAL_CHANGE_RATE")) || val.isNaN()) continue;
            sumAngleSpeed += val.doubleValue();
            ++nAngleSpeed;
        }
        double netDistance = fm.getTrackFeature(trackID, "TRACK_DISPLACEMENT");
        double tTotal = fm.getTrackFeature(trackID, "TRACK_DURATION");
        double vMean = fm.getTrackFeature(trackID, "TRACK_MEAN_SPEED");
        double confinmentRatio = netDistance / totalDistance;
        double meanStraightLineSpeed = netDistance / tTotal;
        double linearityForwardProgression = meanStraightLineSpeed / vMean;
        double meanAngleSpeed = sumAngleSpeed / (double)nAngleSpeed;
        fm.putTrackFeature(trackID, TRACK_TOTAL_DISTANCE_TRAVELED, totalDistance);
        fm.putTrackFeature(trackID, TRACK_MAX_DISTANCE_TRAVELED, maxDistance);
        fm.putTrackFeature(trackID, TRACK_CONFINEMENT_RATIO, confinmentRatio);
        fm.putTrackFeature(trackID, TRACK_MEAN_STRAIGHT_LINE_SPEED, meanStraightLineSpeed);
        fm.putTrackFeature(trackID, TRACK_LINEARITY_OF_FORWARD_PROGRESSION, linearityForwardProgression);
        fm.putTrackFeature(trackID, TRACK_MEAN_DIRECTIONAL_CHANGE_RATE, meanAngleSpeed);
    }

    static {
        FEATURES.add(TRACK_TOTAL_DISTANCE_TRAVELED);
        FEATURES.add(TRACK_MAX_DISTANCE_TRAVELED);
        FEATURES.add(TRACK_CONFINEMENT_RATIO);
        FEATURES.add(TRACK_MEAN_STRAIGHT_LINE_SPEED);
        FEATURES.add(TRACK_LINEARITY_OF_FORWARD_PROGRESSION);
        FEATURES.add(TRACK_MEAN_DIRECTIONAL_CHANGE_RATE);
        FEATURE_NAMES.put(TRACK_TOTAL_DISTANCE_TRAVELED, "Total distance traveled");
        FEATURE_NAMES.put(TRACK_MAX_DISTANCE_TRAVELED, "Max distance traveled");
        FEATURE_NAMES.put(TRACK_CONFINEMENT_RATIO, "Confinement ratio");
        FEATURE_NAMES.put(TRACK_MEAN_STRAIGHT_LINE_SPEED, "Mean straight line speed");
        FEATURE_NAMES.put(TRACK_LINEARITY_OF_FORWARD_PROGRESSION, "Linearity of forward progression");
        FEATURE_NAMES.put(TRACK_MEAN_DIRECTIONAL_CHANGE_RATE, "Mean directional change rate");
        FEATURE_SHORT_NAMES.put(TRACK_TOTAL_DISTANCE_TRAVELED, "Total dist.");
        FEATURE_SHORT_NAMES.put(TRACK_MAX_DISTANCE_TRAVELED, "Max dist.");
        FEATURE_SHORT_NAMES.put(TRACK_CONFINEMENT_RATIO, "Cfn. ratio");
        FEATURE_SHORT_NAMES.put(TRACK_MEAN_STRAIGHT_LINE_SPEED, "Mn. v. line");
        FEATURE_SHORT_NAMES.put(TRACK_LINEARITY_OF_FORWARD_PROGRESSION, "Fwd. progr.");
        FEATURE_SHORT_NAMES.put(TRACK_MEAN_DIRECTIONAL_CHANGE_RATE, "Mn. \u03b3 rate");
        FEATURE_DIMENSIONS.put(TRACK_TOTAL_DISTANCE_TRAVELED, Dimension.LENGTH);
        FEATURE_DIMENSIONS.put(TRACK_MAX_DISTANCE_TRAVELED, Dimension.LENGTH);
        FEATURE_DIMENSIONS.put(TRACK_CONFINEMENT_RATIO, Dimension.NONE);
        FEATURE_DIMENSIONS.put(TRACK_MEAN_STRAIGHT_LINE_SPEED, Dimension.VELOCITY);
        FEATURE_DIMENSIONS.put(TRACK_LINEARITY_OF_FORWARD_PROGRESSION, Dimension.NONE);
        FEATURE_DIMENSIONS.put(TRACK_MEAN_DIRECTIONAL_CHANGE_RATE, Dimension.ANGLE_RATE);
        IS_INT.put(TRACK_TOTAL_DISTANCE_TRAVELED, Boolean.FALSE);
        IS_INT.put(TRACK_MAX_DISTANCE_TRAVELED, Boolean.FALSE);
        IS_INT.put(TRACK_CONFINEMENT_RATIO, Boolean.FALSE);
        IS_INT.put(TRACK_MEAN_STRAIGHT_LINE_SPEED, Boolean.FALSE);
        IS_INT.put(TRACK_LINEARITY_OF_FORWARD_PROGRESSION, Boolean.FALSE);
        IS_INT.put(TRACK_MEAN_DIRECTIONAL_CHANGE_RATE, Boolean.FALSE);
    }
}

