/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components;

import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.util.TMUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FeaturePlotSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Dimension BUTTON_SIZE = new Dimension(24, 24);
    private static final Dimension COMBO_BOX_MAX_SIZE = new Dimension(220, 22);
    private static final int MAX_FEATURE_ALLOWED = 10;
    private final JPanel panelYFeatures;
    private final JComboBox<String> cmbboxXFeature;
    private final Stack<JComboBox<String>> comboBoxes = new Stack();
    private final Stack<Component> struts = new Stack();
    private List<String> features;
    private Map<String, String> featureNames;

    public FeaturePlotSelectionPanel(String xKey, String yKey, Collection<String> features, Map<String, String> featureNames, PlotAction plotAction) {
        this.features = new ArrayList<String>(features);
        this.featureNames = featureNames;
        this.setPreferredSize(new Dimension(300, 450));
        this.setLayout(new BorderLayout(0, 0));
        JPanel topPanel = new JPanel();
        topPanel.setPreferredSize(new Dimension(300, 180));
        topPanel.setMinimumSize(new Dimension(300, 100));
        this.add((Component)topPanel, "North");
        topPanel.setLayout(null);
        JButton plotButton = new JButton("Plot features", Icons.PLOT_ICON);
        plotButton.setBounds(80, 27, 140, 40);
        topPanel.add(plotButton);
        plotButton.setFont(Fonts.FONT.deriveFont(1));
        JLabel jLabelXFeature = new JLabel();
        jLabelXFeature.setBounds(10, 93, 170, 13);
        topPanel.add(jLabelXFeature);
        jLabelXFeature.setText("Feature for X axis:");
        jLabelXFeature.setFont(Fonts.FONT.deriveFont(12));
        DefaultComboBoxModel<String> cmbboxXFeatureModel = new DefaultComboBoxModel<String>(TMUtils.getArrayFromMaping(features, featureNames).toArray(new String[0]));
        this.cmbboxXFeature = new JComboBox();
        this.cmbboxXFeature.setBounds(30, 117, FeaturePlotSelectionPanel.COMBO_BOX_MAX_SIZE.width, FeaturePlotSelectionPanel.COMBO_BOX_MAX_SIZE.height);
        topPanel.add(this.cmbboxXFeature);
        this.cmbboxXFeature.setModel(cmbboxXFeatureModel);
        this.cmbboxXFeature.setFont(Fonts.FONT);
        this.cmbboxXFeature.setSelectedItem(xKey);
        JLabel lblYFeatures = new JLabel();
        lblYFeatures.setBounds(10, 149, 280, 20);
        topPanel.add(lblYFeatures);
        lblYFeatures.setPreferredSize(new Dimension(250, 20));
        lblYFeatures.setText("Features for Y axis:");
        lblYFeatures.setFont(Fonts.FONT.deriveFont(12));
        JPanel centerPanel = new JPanel();
        centerPanel.setBorder(null);
        this.add((Component)centerPanel, "Center");
        centerPanel.setLayout(new BorderLayout(0, 0));
        JScrollPane scrlpnYFeatures = new JScrollPane();
        scrlpnYFeatures.setBorder(null);
        centerPanel.add(scrlpnYFeatures);
        scrlpnYFeatures.setPreferredSize(new Dimension(169, 137));
        scrlpnYFeatures.setHorizontalScrollBarPolicy(31);
        this.panelYFeatures = new JPanel();
        this.panelYFeatures.setBorder(null);
        this.panelYFeatures.setLayout(new BoxLayout(this.panelYFeatures, 1));
        scrlpnYFeatures.setViewportView(this.panelYFeatures);
        JPanel panelButtons = new JPanel();
        panelButtons.setPreferredSize(new Dimension(250, 50));
        BoxLayout jPanelButtonsLayout = new BoxLayout(panelButtons, 0);
        panelButtons.setLayout(jPanelButtonsLayout);
        this.add((Component)panelButtons, "South");
        JButton btnAdd = new JButton();
        panelButtons.add(btnAdd);
        btnAdd.setIcon(Icons.ADD_ICON);
        btnAdd.setMaximumSize(BUTTON_SIZE);
        btnAdd.addActionListener(e -> this.addFeature());
        JButton btnRemove = new JButton();
        panelButtons.add(btnRemove);
        btnRemove.setIcon(Icons.REMOVE_ICON);
        btnRemove.setMaximumSize(BUTTON_SIZE);
        btnRemove.addActionListener(e -> this.removeFeature());
        DefaultComboBoxModel<String> jComboBoxYFeatureModel = new DefaultComboBoxModel<String>(TMUtils.getArrayFromMaping(features, featureNames).toArray(new String[0]));
        JComboBox<String> cmbboxYFeature = new JComboBox<String>();
        cmbboxYFeature.setModel(jComboBoxYFeatureModel);
        cmbboxYFeature.setPreferredSize(COMBO_BOX_MAX_SIZE);
        cmbboxYFeature.setMaximumSize(COMBO_BOX_MAX_SIZE);
        cmbboxYFeature.setFont(Fonts.FONT);
        this.addFeature(yKey);
        plotButton.addActionListener(e -> {
            String sKey = this.features.get(this.cmbboxXFeature.getSelectedIndex());
            ArrayList<String> yKeys = new ArrayList<String>(this.comboBoxes.size());
            for (JComboBox jComboBox : this.comboBoxes) {
                yKeys.add(this.features.get(jComboBox.getSelectedIndex()));
            }
            plotAction.plot(sKey, yKeys);
        });
    }

    public void setFeatures(Collection<String> features, Map<String, String> featureNames) {
        this.features = new ArrayList<String>(features);
        this.featureNames = featureNames;
        Object previousKey = this.cmbboxXFeature.getSelectedItem();
        DefaultComboBoxModel<String> cmbboxXFeatureModel = new DefaultComboBoxModel<String>(TMUtils.getArrayFromMaping(features, featureNames).toArray(new String[0]));
        this.cmbboxXFeature.setModel(cmbboxXFeatureModel);
        this.cmbboxXFeature.setSelectedItem(previousKey);
        for (JComboBox jComboBox : this.comboBoxes) {
            Object previousYKey = jComboBox.getSelectedItem();
            DefaultComboBoxModel<String> cmbboxYFeatureModel = new DefaultComboBoxModel<String>(TMUtils.getArrayFromMaping(features, featureNames).toArray(new String[0]));
            jComboBox.setModel(cmbboxYFeatureModel);
            jComboBox.setSelectedItem(previousYKey);
        }
    }

    private void addFeature(String yKey) {
        if (this.comboBoxes.size() > 10) {
            return;
        }
        DefaultComboBoxModel<String> cmbboxYFeatureModel = new DefaultComboBoxModel<String>(TMUtils.getArrayFromMaping(this.features, this.featureNames).toArray(new String[0]));
        JComboBox<String> cmbboxYFeature = new JComboBox<String>();
        cmbboxYFeature.setModel(cmbboxYFeatureModel);
        cmbboxYFeature.setMaximumSize(COMBO_BOX_MAX_SIZE);
        cmbboxYFeature.setFont(Fonts.FONT);
        cmbboxYFeature.setSelectedItem(yKey);
        Component strut = Box.createVerticalStrut(10);
        this.panelYFeatures.add(strut);
        this.panelYFeatures.add(cmbboxYFeature);
        this.panelYFeatures.revalidate();
        this.comboBoxes.push(cmbboxYFeature);
        this.struts.push(strut);
    }

    private void addFeature() {
        String nextFeature = "";
        if (!this.comboBoxes.isEmpty()) {
            int newIndex = ((JComboBox)this.comboBoxes.get(this.comboBoxes.size() - 1)).getSelectedIndex() + 1;
            if (newIndex >= this.features.size()) {
                newIndex = 0;
            }
            nextFeature = this.featureNames.get(this.features.get(newIndex));
        }
        this.addFeature(nextFeature);
    }

    private void removeFeature() {
        if (this.comboBoxes.size() <= 1) {
            return;
        }
        this.panelYFeatures.remove(this.comboBoxes.pop());
        this.panelYFeatures.remove(this.struts.pop());
        this.panelYFeatures.revalidate();
        this.panelYFeatures.repaint();
    }

    public static interface PlotAction {
        public void plot(String var1, List<String> var2);
    }
}

