/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components.tracker;

import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;

public class KalmanTrackerConfigPanel
extends ConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private final JFormattedTextField tfInitSearchRadius;
    private final JFormattedTextField tfSearchRadius;
    private final JFormattedTextField tfMaxFrameGap;

    public KalmanTrackerConfigPanel(String trackerName, String infoText, String spaceUnits) {
        this.setLayout(null);
        JLabel lbl1 = new JLabel("Settings for tracker:");
        lbl1.setBounds(6, 6, 288, 16);
        lbl1.setFont(Fonts.FONT);
        this.add(lbl1);
        JLabel lblTrackerName = new JLabel(trackerName);
        lblTrackerName.setFont(Fonts.BIG_FONT);
        lblTrackerName.setHorizontalAlignment(0);
        lblTrackerName.setBounds(6, 34, 288, 32);
        this.add(lblTrackerName);
        JLabel lblTrackerDescription = new JLabel("<tracker description>");
        lblTrackerDescription.setFont(Fonts.FONT.deriveFont(2));
        lblTrackerDescription.setVerticalAlignment(1);
        lblTrackerDescription.setBounds(6, 81, 288, 175);
        lblTrackerDescription.setText(infoText.replace("<br>", "").replace("<p>", "<p align=\"justify\">").replace("<html>", "<html><p align=\"justify\">"));
        this.add(lblTrackerDescription);
        JLabel lblInitSearchRadius = new JLabel("Initial search radius:");
        lblInitSearchRadius.setFont(Fonts.FONT);
        lblInitSearchRadius.setBounds(6, 348, 173, 16);
        this.add(lblInitSearchRadius);
        JLabel lblSearchRadius = new JLabel("Search radius:");
        lblSearchRadius.setFont(Fonts.FONT);
        lblSearchRadius.setBounds(6, 376, 173, 16);
        this.add(lblSearchRadius);
        JLabel lblMaxFrameGap = new JLabel("Max frame gap:");
        lblMaxFrameGap.setFont(Fonts.FONT);
        lblMaxFrameGap.setBounds(6, 404, 173, 16);
        this.add(lblMaxFrameGap);
        this.tfInitSearchRadius = new JFormattedTextField(15.0);
        this.tfInitSearchRadius.setHorizontalAlignment(0);
        this.tfInitSearchRadius.setFont(Fonts.FONT);
        this.tfInitSearchRadius.setBounds(167, 348, 60, 28);
        this.add(this.tfInitSearchRadius);
        this.tfInitSearchRadius.setSize(Fonts.TEXTFIELD_DIMENSION);
        this.tfSearchRadius = new JFormattedTextField(15.0);
        this.tfSearchRadius.setHorizontalAlignment(0);
        this.tfSearchRadius.setFont(Fonts.FONT);
        this.tfSearchRadius.setBounds(167, 376, 60, 28);
        this.add(this.tfSearchRadius);
        this.tfSearchRadius.setSize(Fonts.TEXTFIELD_DIMENSION);
        this.tfMaxFrameGap = new JFormattedTextField((Object)2);
        this.tfMaxFrameGap.setHorizontalAlignment(0);
        this.tfMaxFrameGap.setFont(Fonts.FONT);
        this.tfMaxFrameGap.setBounds(167, 404, 60, 28);
        this.add(this.tfMaxFrameGap);
        this.tfMaxFrameGap.setSize(Fonts.TEXTFIELD_DIMENSION);
        JLabel lblSpaceUnits1 = new JLabel(spaceUnits);
        lblSpaceUnits1.setFont(Fonts.FONT);
        lblSpaceUnits1.setBounds(219, 348, 51, 16);
        this.add(lblSpaceUnits1);
        JLabel lblSpaceUnits2 = new JLabel(spaceUnits);
        lblSpaceUnits2.setFont(Fonts.FONT);
        lblSpaceUnits2.setBounds(219, 376, 51, 16);
        this.add(lblSpaceUnits2);
        JLabel lblFrameUnits = new JLabel("frames");
        lblFrameUnits.setFont(Fonts.FONT);
        lblFrameUnits.setBounds(219, 404, 51, 16);
        this.add(lblFrameUnits);
        GuiUtils.selectAllOnFocus(this.tfInitSearchRadius);
        GuiUtils.selectAllOnFocus(this.tfMaxFrameGap);
        GuiUtils.selectAllOnFocus(this.tfSearchRadius);
    }

    @Override
    public void setSettings(Map<String, Object> settings) {
        this.tfInitSearchRadius.setValue(settings.get("LINKING_MAX_DISTANCE"));
        this.tfSearchRadius.setValue(settings.get("KALMAN_SEARCH_RADIUS"));
        this.tfMaxFrameGap.setValue(settings.get("MAX_FRAME_GAP"));
    }

    @Override
    public Map<String, Object> getSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("LINKING_MAX_DISTANCE", ((Number)this.tfInitSearchRadius.getValue()).doubleValue());
        settings.put("KALMAN_SEARCH_RADIUS", ((Number)this.tfSearchRadius.getValue()).doubleValue());
        settings.put("MAX_FRAME_GAP", ((Number)this.tfMaxFrameGap.getValue()).intValue());
        return settings;
    }

    @Override
    public void clean() {
    }
}

