/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util;

import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.filechooser.FileFilter;

public class DefaultFileFilter
extends FileFilter {
    protected String ext;
    protected String desc;

    public DefaultFileFilter(String extension, String description) {
        this.ext = extension.toLowerCase();
        this.desc = description;
    }

    @Override
    public boolean accept(File file) {
        return file.isDirectory() || file.getName().toLowerCase().endsWith(this.ext);
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    public String getExtension() {
        return this.ext;
    }

    public void setExtension(String extension) {
        this.ext = extension;
    }

    public static class EditorFileFilter
    extends FileFilter {
        protected String desc;

        public EditorFileFilter(String description) {
            this.desc = description;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String filename = file.getName().toLowerCase();
            return filename.endsWith(".xml") || filename.endsWith(".xml.gz");
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }

    public static class ImageFileFilter
    extends FileFilter {
        protected static String[] imageFormats = ImageIO.getReaderFormatNames();
        protected String desc;

        public ImageFileFilter(String description) {
            this.desc = description;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String filename = file.toString().toLowerCase();
            for (int j = 0; j < imageFormats.length; ++j) {
                if (!filename.endsWith("." + imageFormats[j].toLowerCase())) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }
}

