/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.table;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.graph.ConvexBranchesDecomposition;
import fiji.plugin.trackmate.graph.TimeDirectedNeighborIndex;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.util.FileChooser;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.visualization.TrackMateModelView;
import fiji.plugin.trackmate.visualization.table.TablePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleDirectedGraph;

public class BranchTableView
extends JFrame
implements TrackMateModelView {
    private static final long serialVersionUID = 1L;
    private static final String KEY = "SPOT_TABLE";
    private String selectedFile = System.getProperty("user.home") + File.separator + "branches.csv";
    private final Model model;
    private final TablePanel<Branch> branchTable;
    private static final String TRACK_ID = "TRACK_ID";
    private static final String N_PREDECESSORS = "N_PREDECESSORS";
    private static final String N_SUCCESSORS = "N_SUCCESSORS";
    private static final String DELTA_T = "DELTA_T";
    private static final String DISTANCE = "DISTANCE";
    private static final String MEAN_VELOCITY = "MEAN_VELOCITY";
    private static final String TOTAL_DISTANCE = "TOTAL_DISTANCE";
    private static final String FIRST = "FIRST";
    private static final String LAST = "LAST";
    private static final String MEAN_SUCCESSORS_DELAY = "MEAN_SUCCESSORS_DELAY";
    private static final String MEAN_PREDECESSORS_DELAY = "MEAN_PREDECESSORS_DELAY";
    private static final List<String> BRANCH_FEATURES = Arrays.asList("TRACK_ID", "N_PREDECESSORS", "N_SUCCESSORS", "DELTA_T", "DISTANCE", "MEAN_VELOCITY", "TOTAL_DISTANCE", "FIRST", "LAST", "MEAN_SUCCESSORS_DELAY", "MEAN_PREDECESSORS_DELAY");
    private static final Map<String, String> BRANCH_FEATURES_NAMES = new HashMap<String, String>();
    private static final Map<String, String> BRANCH_FEATURES_SHORTNAMES = new HashMap<String, String>();
    private static final Map<String, Boolean> BRANCH_FEATURES_ISINTS = new HashMap<String, Boolean>();
    private static final Map<String, Dimension> BRANCH_FEATURES_DIMENSIONS = new HashMap<String, Dimension>();

    public BranchTableView(Model model, SelectionModel selectionModel, String imageFileName) {
        super("Branch table");
        this.setIconImage(Icons.TRACKMATE_ICON.getImage());
        this.model = model;
        this.selectedFile = imageFileName + "_branches.csv";
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        this.branchTable = BranchTableView.createBranchTable(model, selectionModel);
        mainPanel.add((Component)this.branchTable.getPanel(), "Center");
        JPanel toolbar = new JPanel();
        BoxLayout layout = new BoxLayout(toolbar, 2);
        toolbar.setLayout(layout);
        JButton exportBtn = new JButton("Export to CSV", Icons.CSV_ICON);
        exportBtn.addActionListener(e -> this.exportToCsv());
        toolbar.add(exportBtn);
        toolbar.add(Box.createHorizontalGlue());
        mainPanel.add((Component)toolbar, "North");
        this.getContentPane().add(mainPanel);
        this.pack();
    }

    public TablePanel<Branch> getBranchTable() {
        return this.branchTable;
    }

    public void exportToCsv() {
        File file = FileChooser.chooseFile(this, this.selectedFile, new FileNameExtensionFilter("CSV files", "csv"), "Export table to CSV", FileChooser.DialogType.SAVE, FileChooser.SelectionMode.FILES_ONLY);
        if (null == file) {
            return;
        }
        this.selectedFile = file.getAbsolutePath();
        this.exportToCsv(this.selectedFile);
    }

    public void exportToCsv(String csvFile) {
        try {
            this.branchTable.exportToCsv(new File(csvFile));
        }
        catch (IOException e) {
            this.model.getLogger().error("Problem exporting to file " + csvFile + "\n" + e.getMessage());
        }
    }

    public static final TablePanel<Branch> createBranchTable(Model model, SelectionModel selectionModel) {
        Logger logger = model.getLogger();
        logger.log("Generating track branches analysis.\n");
        int ntracks = model.getTrackModel().nTracks(true);
        if (ntracks == 0) {
            logger.log("No visible track found. Aborting.\n");
        }
        TimeDirectedNeighborIndex neighborIndex = model.getTrackModel().getDirectedNeighborIndex();
        ArrayList brs = new ArrayList();
        for (Integer trackID : model.getTrackModel().unsortedTrackIDs(true)) {
            ConvexBranchesDecomposition.TrackBranchDecomposition branchDecomposition = ConvexBranchesDecomposition.processTrack(trackID, model.getTrackModel(), neighborIndex, true, false);
            SimpleDirectedGraph<List<Spot>, DefaultEdge> branchGraph = ConvexBranchesDecomposition.buildBranchGraph(branchDecomposition);
            HashMap successorMap = new HashMap();
            HashMap predecessorMap = new HashMap();
            HashMap<List, Branch> branchMap = new HashMap<List, Branch>();
            for (List branch : branchGraph.vertexSet()) {
                double sum;
                double meanV;
                Branch br2 = new Branch();
                branchMap.put(branch, br2);
                br2.trackName = model.getTrackModel().name(trackID);
                br2.putFeature(TRACK_ID, (double)trackID);
                Spot first = (Spot)branch.get(0);
                br2.first = first;
                br2.putFeature(FIRST, Double.valueOf(first.ID()));
                Spot last = (Spot)branch.get(branch.size() - 1);
                br2.last = last;
                br2.putFeature(LAST, Double.valueOf(last.ID()));
                br2.putFeature(DELTA_T, br2.dt());
                double distanceTraveled = Math.sqrt(br2.last.squareDistanceTo(br2.first));
                br2.putFeature(DISTANCE, distanceTraveled);
                if (branch.size() < 2) {
                    meanV = Double.NaN;
                    sum = 0.0;
                } else {
                    Iterator it = branch.iterator();
                    Spot previous = (Spot)it.next();
                    sum = 0.0;
                    while (it.hasNext()) {
                        Spot next = (Spot)it.next();
                        double dr = Math.sqrt(next.squareDistanceTo(previous));
                        sum += dr;
                        previous = next;
                    }
                    meanV = sum / Double.valueOf(br2.dt());
                }
                br2.putFeature(MEAN_VELOCITY, meanV);
                br2.putFeature(TOTAL_DISTANCE, sum);
                Set incomingEdges = branchGraph.incomingEdgesOf((Object)branch);
                HashSet<List> predecessors = new HashSet<List>(incomingEdges.size());
                for (DefaultEdge edge : incomingEdges) {
                    List predecessorBranch = (List)branchGraph.getEdgeSource((Object)edge);
                    predecessors.add(predecessorBranch);
                }
                Set outgoingEdges = branchGraph.outgoingEdgesOf((Object)branch);
                HashSet<List> successors = new HashSet<List>(outgoingEdges.size());
                for (DefaultEdge edge : outgoingEdges) {
                    List successorBranch = (List)branchGraph.getEdgeTarget((Object)edge);
                    successors.add(successorBranch);
                }
                successorMap.put(br2, successors);
                predecessorMap.put(br2, predecessors);
            }
            for (Branch br3 : successorMap.keySet()) {
                Set succs = (Set)successorMap.get(br3);
                HashSet<Branch> succBrs = new HashSet<Branch>(succs.size());
                double meanDeltaTSucc = 0.0;
                for (List branch : succs) {
                    Branch succBr = (Branch)branchMap.get(branch);
                    meanDeltaTSucc += succBr.first.diffTo(br3.last, "POSITION_T");
                    succBrs.add(succBr);
                }
                br3.successors = succBrs;
                br3.putFeature(N_SUCCESSORS, Double.valueOf(succBrs.size()));
                if (br3.getFeature(N_SUCCESSORS) > 0.0) {
                    br3.putFeature(MEAN_SUCCESSORS_DELAY, meanDeltaTSucc / br3.getFeature(N_SUCCESSORS));
                } else {
                    br3.putFeature(MEAN_SUCCESSORS_DELAY, 0.0);
                }
                Set preds = (Set)predecessorMap.get(br3);
                HashSet<Branch> predBrs = new HashSet<Branch>(preds.size());
                double meanDeltaTPred = 0.0;
                for (List branch : preds) {
                    Branch predBr = (Branch)branchMap.get(branch);
                    meanDeltaTPred += br3.first.diffTo(predBr.last, "POSITION_T");
                    predBrs.add(predBr);
                }
                br3.predecessors = predBrs;
                br3.putFeature(N_PREDECESSORS, Double.valueOf(predBrs.size()));
                if (br3.getFeature(N_PREDECESSORS) > 0.0) {
                    br3.putFeature(MEAN_PREDECESSORS_DELAY, meanDeltaTPred / br3.getFeature(N_PREDECESSORS));
                    continue;
                }
                br3.putFeature(MEAN_PREDECESSORS_DELAY, 0.0);
            }
            brs.addAll(successorMap.keySet());
        }
        Collections.sort(brs);
        ArrayList objects = brs;
        BiFunction<Branch, String, Double> featureFun = (br, feature) -> br.getFeature((String)feature);
        HashMap<String, String> featureUnits = new HashMap<String, String>();
        BRANCH_FEATURES_DIMENSIONS.forEach((f, d) -> featureUnits.put((String)f, TMUtils.getUnitsFor(d, model.getSpaceUnits(), model.getTimeUnits())));
        HashMap<String, String> infoTexts = new HashMap<String, String>();
        Function<Branch, String> labelGenerator = b -> b.toString();
        BiConsumer labelSetter = null;
        Supplier colorSupplier = () -> b -> Color.WHITE;
        TablePanel<Branch> table = new TablePanel<Branch>(objects, BRANCH_FEATURES, featureFun, BRANCH_FEATURES_NAMES, BRANCH_FEATURES_SHORTNAMES, featureUnits, BRANCH_FEATURES_ISINTS, infoTexts, colorSupplier, labelGenerator, labelSetter);
        table.getTable().getSelectionModel().addListSelectionListener(new BranchTableSelectionListener(table, model, selectionModel));
        return table;
    }

    @Override
    public void render() {
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    @Override
    public void refresh() {
        this.repaint();
    }

    @Override
    public void centerViewOn(Spot spot) {
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void clear() {
    }

    static {
        BRANCH_FEATURES_NAMES.put(TRACK_ID, "Track ID");
        BRANCH_FEATURES_SHORTNAMES.put(TRACK_ID, "Track ID");
        BRANCH_FEATURES_ISINTS.put(TRACK_ID, Boolean.TRUE);
        BRANCH_FEATURES_DIMENSIONS.put(TRACK_ID, Dimension.NONE);
        BRANCH_FEATURES_NAMES.put(N_PREDECESSORS, "Track ID");
        BRANCH_FEATURES_SHORTNAMES.put(N_PREDECESSORS, "N predecessors");
        BRANCH_FEATURES_ISINTS.put(N_PREDECESSORS, Boolean.TRUE);
        BRANCH_FEATURES_DIMENSIONS.put(N_PREDECESSORS, Dimension.NONE);
        BRANCH_FEATURES_NAMES.put(N_SUCCESSORS, "Track ID");
        BRANCH_FEATURES_SHORTNAMES.put(N_SUCCESSORS, "N successors");
        BRANCH_FEATURES_ISINTS.put(N_SUCCESSORS, Boolean.TRUE);
        BRANCH_FEATURES_DIMENSIONS.put(N_SUCCESSORS, Dimension.NONE);
        BRANCH_FEATURES_NAMES.put(DELTA_T, "Branch duration");
        BRANCH_FEATURES_SHORTNAMES.put(DELTA_T, "Delta T");
        BRANCH_FEATURES_ISINTS.put(DELTA_T, Boolean.FALSE);
        BRANCH_FEATURES_DIMENSIONS.put(DELTA_T, Dimension.TIME);
        BRANCH_FEATURES_NAMES.put(DISTANCE, "Distance traveled");
        BRANCH_FEATURES_SHORTNAMES.put(DISTANCE, "Dist");
        BRANCH_FEATURES_ISINTS.put(DISTANCE, Boolean.FALSE);
        BRANCH_FEATURES_DIMENSIONS.put(DISTANCE, Dimension.LENGTH);
        BRANCH_FEATURES_NAMES.put(MEAN_VELOCITY, "Mean velocity");
        BRANCH_FEATURES_SHORTNAMES.put(MEAN_VELOCITY, "Mean V");
        BRANCH_FEATURES_ISINTS.put(MEAN_VELOCITY, Boolean.FALSE);
        BRANCH_FEATURES_DIMENSIONS.put(MEAN_VELOCITY, Dimension.VELOCITY);
        BRANCH_FEATURES_NAMES.put(TOTAL_DISTANCE, "Total distance");
        BRANCH_FEATURES_SHORTNAMES.put(TOTAL_DISTANCE, "Tot Dist");
        BRANCH_FEATURES_ISINTS.put(TOTAL_DISTANCE, Boolean.FALSE);
        BRANCH_FEATURES_DIMENSIONS.put(TOTAL_DISTANCE, Dimension.LENGTH);
        BRANCH_FEATURES_NAMES.put(FIRST, "First spot ID");
        BRANCH_FEATURES_SHORTNAMES.put(FIRST, "First ID");
        BRANCH_FEATURES_ISINTS.put(FIRST, Boolean.TRUE);
        BRANCH_FEATURES_DIMENSIONS.put(FIRST, Dimension.NONE);
        BRANCH_FEATURES_NAMES.put(LAST, "Last spot ID");
        BRANCH_FEATURES_SHORTNAMES.put(LAST, "Last ID");
        BRANCH_FEATURES_ISINTS.put(LAST, Boolean.TRUE);
        BRANCH_FEATURES_DIMENSIONS.put(LAST, Dimension.NONE);
        BRANCH_FEATURES_NAMES.put(MEAN_SUCCESSORS_DELAY, "Mean successors delay");
        BRANCH_FEATURES_SHORTNAMES.put(MEAN_SUCCESSORS_DELAY, "Succ Delay");
        BRANCH_FEATURES_ISINTS.put(MEAN_SUCCESSORS_DELAY, Boolean.FALSE);
        BRANCH_FEATURES_DIMENSIONS.put(MEAN_SUCCESSORS_DELAY, Dimension.TIME);
        BRANCH_FEATURES_NAMES.put(MEAN_PREDECESSORS_DELAY, "Mean predecessors delay");
        BRANCH_FEATURES_SHORTNAMES.put(MEAN_PREDECESSORS_DELAY, "Pred Delay");
        BRANCH_FEATURES_ISINTS.put(MEAN_PREDECESSORS_DELAY, Boolean.FALSE);
        BRANCH_FEATURES_DIMENSIONS.put(MEAN_PREDECESSORS_DELAY, Dimension.TIME);
    }

    public static class Branch
    implements Comparable<Branch> {
        private final Map<String, Double> features = new HashMap<String, Double>();
        private String trackName;
        private Spot first;
        private Spot last;
        private Set<Branch> predecessors;
        private Set<Branch> successors;

        public String toString() {
            return this.trackName + ": " + this.first + " \u2192 " + this.last;
        }

        double dt() {
            return this.last.diffTo(this.first, "POSITION_T");
        }

        public final Double getFeature(String feature) {
            return this.features.get(feature);
        }

        public final void putFeature(String feature, Double value) {
            this.features.put(feature, value);
        }

        @Override
        public int compareTo(Branch o) {
            if (this.predecessors.size() != o.predecessors.size()) {
                return this.predecessors.size() - o.predecessors.size();
            }
            if (this.successors.size() != o.successors.size()) {
                return this.successors.size() - o.successors.size();
            }
            if (this.first.getName().compareTo(o.first.getName()) != 0) {
                return this.first.getName().compareTo(o.first.getName());
            }
            return this.last.getName().compareTo(o.last.getName());
        }
    }

    private static final class BranchTableSelectionListener
    implements ListSelectionListener {
        private final TablePanel<Branch> branchTable;
        private final Model model;
        private final SelectionModel selectionModel;

        public BranchTableSelectionListener(TablePanel<Branch> branchTable, Model model, SelectionModel selectionModel) {
            this.branchTable = branchTable;
            this.model = model;
            this.selectionModel = selectionModel;
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            int[] selectedRows;
            if (event.getValueIsAdjusting()) {
                return;
            }
            for (int row : selectedRows = this.branchTable.getTable().getSelectedRows()) {
                Branch br = this.branchTable.getObjectForViewRow(row);
                if (null == br) continue;
                List<DefaultWeightedEdge> edges = this.model.getTrackModel().dijkstraShortestPath(br.first, br.last);
                HashSet<Spot> spots = new HashSet<Spot>();
                for (DefaultWeightedEdge edge : edges) {
                    spots.add(this.model.getTrackModel().getEdgeSource(edge));
                    spots.add(this.model.getTrackModel().getEdgeTarget(edge));
                }
                this.selectionModel.clearSelection();
                this.selectionModel.addEdgeToSelection(edges);
                this.selectionModel.addSpotToSelection(spots);
            }
        }
    }
}

