/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;

public class Eigen {
    private static final double ONE_THIRD = 0.3333333333333333;
    private static final double ONE_OVER_SQRT3 = 1.0 / ArrayMath.sqrt(3.0);

    public static void solveSymmetric22(float[][] a, float[][] v, float[] d) {
        float a00 = a[0][0];
        float a01 = a[0][1];
        float a11 = a[1][1];
        float v00 = 1.0f;
        float v01 = 0.0f;
        float v10 = 0.0f;
        float v11 = 1.0f;
        if (a01 != 0.0f) {
            float r;
            float tiny = 0.1f * ArrayMath.sqrt(1.1920929E-7f);
            float u = a11 - a00;
            float t = ArrayMath.abs(a01) < tiny * ArrayMath.abs(u) ? a01 / u : ((r = 0.5f * u / a01) >= 0.0f ? 1.0f / (r + ArrayMath.sqrt(1.0f + r * r)) : 1.0f / (r - ArrayMath.sqrt(1.0f + r * r)));
            float c = 1.0f / ArrayMath.sqrt(1.0f + t * t);
            float s = t * c;
            u = s / (1.0f + c);
            r = t * a01;
            a00 -= r;
            a11 += r;
            float vpr = v00;
            float vqr = v10;
            v00 = vpr - s * (vqr + vpr * u);
            v10 = vqr + s * (vpr - vqr * u);
            vpr = v01;
            vqr = v11;
            v01 = vpr - s * (vqr + vpr * u);
            v11 = vqr + s * (vpr - vqr * u);
        }
        d[0] = a00;
        d[1] = a11;
        v[0][0] = v00;
        v[0][1] = v01;
        v[1][0] = v10;
        v[1][1] = v11;
        if (d[0] < d[1]) {
            float dt = d[1];
            d[1] = d[0];
            d[0] = dt;
            float[] vt = v[1];
            v[1] = v[0];
            v[0] = vt;
        }
    }

    public static void solveSymmetric22(double[][] a, double[][] v, double[] d) {
        double a00 = a[0][0];
        double a01 = a[0][1];
        double a11 = a[1][1];
        double v00 = 1.0;
        double v01 = 0.0;
        double v10 = 0.0;
        double v11 = 1.0;
        if (a01 != 0.0) {
            double r;
            double tiny = 0.1 * ArrayMath.sqrt(2.220446049250313E-16);
            double u = a11 - a00;
            double t = ArrayMath.abs(a01) < tiny * ArrayMath.abs(u) ? a01 / u : ((r = 0.5 * u / a01) >= 0.0 ? 1.0 / (r + ArrayMath.sqrt(1.0 + r * r)) : 1.0 / (r - ArrayMath.sqrt(1.0 + r * r)));
            double c = 1.0 / ArrayMath.sqrt(1.0 + t * t);
            double s = t * c;
            u = s / (1.0 + c);
            r = t * a01;
            a00 -= r;
            a11 += r;
            double vpr = v00;
            double vqr = v10;
            v00 = vpr - s * (vqr + vpr * u);
            v10 = vqr + s * (vpr - vqr * u);
            vpr = v01;
            vqr = v11;
            v01 = vpr - s * (vqr + vpr * u);
            v11 = vqr + s * (vpr - vqr * u);
        }
        d[0] = a00;
        d[1] = a11;
        v[0][0] = v00;
        v[0][1] = v01;
        v[1][0] = v10;
        v[1][1] = v11;
        if (d[0] < d[1]) {
            double dt = d[1];
            d[1] = d[0];
            d[0] = dt;
            double[] vt = v[1];
            v[1] = v[0];
            v[0] = vt;
        }
    }

    public static void solveSymmetric33(double[][] a, double[][] v, double[] d) {
        Eigen.solveSymmetric33Jacobi(a, v, d);
    }

    public static void solveSymmetric33Fast(double[][] a, double[][] v, double[] d) {
        Eigen.solveSymmetric33Hybrid(a, v, d);
    }

    private static void sortDescending33(double[][] v, double[] d) {
        for (int i = 0; i < 3; ++i) {
            for (int j = i; j > 0 && d[j - 1] < d[j]; --j) {
                double dj = d[j];
                d[j] = d[j - 1];
                d[j - 1] = dj;
                double[] vj = v[j];
                v[j] = v[j - 1];
                v[j - 1] = vj;
            }
        }
    }

    private static void getEigenvaluesSymmetric33(double[][] a, double[] d) {
        double a00 = a[0][0];
        double a01 = a[0][1];
        double a11 = a[1][1];
        double a02 = a[0][2];
        double a12 = a[1][2];
        double a22 = a[2][2];
        double de = a01 * a12;
        double dd = a01 * a01;
        double ee = a12 * a12;
        double ff = a02 * a02;
        double c2 = a00 + a11 + a22;
        double c1 = a00 * a11 + a00 * a22 + a11 * a22 - (dd + ee + ff);
        double c0 = a22 * dd + a00 * ee + a11 * ff - a00 * a11 * a22 - 2.0 * a02 * de;
        double p = c2 * c2 - 3.0 * c1;
        double q = c2 * (p - 1.5 * c1) - 13.5 * c0;
        double t = 27.0 * (0.25 * c1 * c1 * (p - c1) + c0 * (q + 6.75 * c0));
        double phi = 0.3333333333333333 * ArrayMath.atan2(ArrayMath.sqrt(ArrayMath.abs(t)), q);
        double sqrtp = ArrayMath.sqrt(ArrayMath.abs(p));
        double c = sqrtp * ArrayMath.cos(phi);
        double s = ONE_OVER_SQRT3 * sqrtp * ArrayMath.sin(phi);
        double dt = 0.3333333333333333 * (c2 - c);
        d[0] = dt + c;
        d[1] = dt + s;
        d[2] = dt - s;
    }

    private static void solveSymmetric33Hybrid(double[][] a, double[][] v, double[] d) {
        double v1s;
        double error;
        double v12;
        double v02;
        double v11;
        double v01;
        double v10;
        double v00;
        double v0s;
        Eigen.getEigenvaluesSymmetric33(a, d);
        double a00 = a[0][0];
        double a01 = a[0][1];
        double a11 = a[1][1];
        double a02 = a[0][2];
        double a12 = a[1][2];
        double d0 = d[0];
        double d1 = d[1];
        double d2 = d[2];
        double n0 = a00 * a00 + a01 * a01 + a02 * a02;
        double n1 = a01 * a01 + a11 * a11 + a12 * a12;
        double t = ArrayMath.abs(d0);
        double u = ArrayMath.abs(d1);
        if (u > t) {
            t = u;
        }
        if ((u = ArrayMath.abs(d2)) > t) {
            t = u;
        }
        if ((v0s = (v00 = (v10 = a01 * a12 - a02 * a11) + a02 * d0) * v00 + (v01 = (v11 = a02 * a01 - a12 * a00) + a12 * d0) * v01 + (v02 = (a00 - d0) * (a11 - d0) - (v12 = a01 * a01)) * v02) <= (error = 5.684341886080802E-14 * (n0 + (u = t < 1.0 ? t : ArrayMath.sqrt(t))) * (n1 + u))) {
            Eigen.solveSymmetric33Ql(a, v, d);
            return;
        }
        v0s = ArrayMath.sqrt(1.0 / v0s);
        v00 *= v0s;
        v01 *= v0s;
        v02 *= v0s;
        if ((v1s = (v10 += a02 * d1) * v10 + (v11 += a12 * d1) * v11 + (v12 = (a00 - d1) * (a11 - d1) - v12) * v12) <= error) {
            Eigen.solveSymmetric33Ql(a, v, d);
            return;
        }
        v1s = ArrayMath.sqrt(1.0 / v1s);
        double v20 = v01 * (v12 *= v1s) - v02 * (v11 *= v1s);
        double v21 = v02 * (v10 *= v1s) - v00 * v12;
        double v22 = v00 * v11 - v01 * v10;
        v[0][0] = v00;
        v[0][1] = v01;
        v[0][2] = v02;
        v[1][0] = v10;
        v[1][1] = v11;
        v[1][2] = v12;
        v[2][0] = v20;
        v[2][1] = v21;
        v[2][2] = v22;
    }

    private static void solveSymmetric33Ql(double[][] a, double[][] v, double[] d) {
        double[] e = new double[3];
        Eigen.reduceSymmetric33(a, v, d, e);
        block0: for (int l = 0; l < 2; ++l) {
            for (int niter = 0; niter <= 100; ++niter) {
                double g;
                int m;
                if (niter == 100) {
                    System.out.println("A =");
                    ArrayMath.dump(a);
                    System.out.println("V =");
                    ArrayMath.dump(v);
                    System.out.println("d =");
                    ArrayMath.dump(d);
                }
                Check.state(niter < 100, "number of QL iterations is less than 100");
                for (m = l; m < 2; ++m) {
                    g = ArrayMath.abs(d[m]) + ArrayMath.abs(d[m + 1]);
                    if (ArrayMath.abs(e[m]) + g == g) break;
                }
                if (m == l) continue block0;
                g = (d[l + 1] - d[l]) / (e[l] + e[l]);
                double r = ArrayMath.sqrt(g * g + 1.0);
                g = g > 0.0 ? d[m] - d[l] + e[l] / (g + r) : d[m] - d[l] + e[l] / (g - r);
                double s = 1.0;
                double c = 1.0;
                double p = 0.0;
                for (int i = m - 1; i >= l; --i) {
                    double f = s * e[i];
                    double b = c * e[i];
                    if (ArrayMath.abs(f) > ArrayMath.abs(g)) {
                        c = g / f;
                        r = ArrayMath.sqrt(c * c + 1.0);
                        e[i + 1] = f * r;
                        s = 1.0 / r;
                        c *= s;
                    } else {
                        s = f / g;
                        r = ArrayMath.sqrt(s * s + 1.0);
                        e[i + 1] = g * r;
                        c = 1.0 / r;
                        s *= c;
                    }
                    g = d[i + 1] - p;
                    r = (d[i] - g) * s + 2.0 * c * b;
                    p = s * r;
                    d[i + 1] = g + p;
                    g = c * r - b;
                    for (int k = 0; k < 3; ++k) {
                        double t = v[i + 1][k];
                        v[i + 1][k] = s * v[i][k] + c * t;
                        v[i][k] = c * v[i][k] - s * t;
                    }
                }
                int n = l;
                d[n] = d[n] - p;
                e[l] = g;
                e[m] = 0.0;
            }
        }
        Eigen.sortDescending33(v, d);
    }

    private static void reduceSymmetric33(double[][] a, double[][] v, double[] d, double[] e) {
        double e1;
        double d2;
        double d1;
        double d0;
        double g;
        double a00 = a[0][0];
        double a01 = a[0][1];
        double a11 = a[1][1];
        double a02 = a[0][2];
        double a12 = a[1][2];
        double a22 = a[2][2];
        double v11 = 1.0;
        double v12 = 0.0;
        double v21 = 0.0;
        double v22 = 1.0;
        double h = a01 * a01 + a02 * a02;
        double e0 = g = a01 > 0.0 ? -ArrayMath.sqrt(h) : ArrayMath.sqrt(h);
        double f = g * a01;
        double u1 = a01 - g;
        double u2 = a02;
        double omega = h - f;
        if (omega > 0.0) {
            omega = 1.0 / omega;
            double s = 0.0;
            f = a11 * u1 + a12 * u2;
            double q1 = omega * f;
            s += u1 * f;
            f = a12 * u1 + a22 * u2;
            double q2 = omega * f;
            s += u2 * f;
            d0 = a00;
            d1 = a11 - 2.0 * (q1 -= (s *= 0.5 * omega * omega) * u1) * u1;
            d2 = a22 - 2.0 * (q2 -= s * u2) * u2;
            f = omega * u1;
            v11 -= f * u1;
            v12 -= f * u2;
            f = omega * u2;
            v21 -= f * u1;
            v22 -= f * u2;
            e1 = a12 - q1 * u2 - u1 * q2;
        } else {
            d0 = a00;
            d1 = a11;
            d2 = a22;
            e1 = a12;
        }
        d[0] = d0;
        d[1] = d1;
        d[2] = d2;
        e[0] = e0;
        e[1] = e1;
        v[0][0] = 1.0;
        v[0][1] = 0.0;
        v[0][2] = 0.0;
        v[1][0] = 0.0;
        v[1][1] = v11;
        v[1][2] = v12;
        v[2][0] = 0.0;
        v[2][1] = v21;
        v[2][2] = v22;
    }

    private static void solveSymmetric33Jacobi(double[][] a, double[][] v, double[] d) {
        double a00 = a[0][0];
        double a01 = a[0][1];
        double a11 = a[1][1];
        double a02 = a[0][2];
        double a12 = a[1][2];
        double a22 = a[2][2];
        double v00 = 1.0;
        double v01 = 0.0;
        double v02 = 0.0;
        double v10 = 0.0;
        double v11 = 1.0;
        double v12 = 0.0;
        double v20 = 0.0;
        double v21 = 0.0;
        double v22 = 1.0;
        double tiny = 0.1 * ArrayMath.sqrt(2.220446049250313E-16);
        double aa01 = ArrayMath.abs(a01);
        double aa02 = ArrayMath.abs(a02);
        double aa12 = ArrayMath.abs(a12);
        int nrot = 0;
        while (aa01 + aa02 + aa12 > 0.0) {
            double vqr;
            double vpr;
            double aqr;
            double apr;
            double s;
            double c;
            double t;
            double r;
            double u;
            Check.state(nrot < 100, "number of Jacobi rotations is less than 100");
            if (aa01 >= aa02 && aa01 >= aa12) {
                u = a11 - a00;
                t = ArrayMath.abs(a01) < tiny * ArrayMath.abs(u) ? a01 / u : ((r = 0.5 * u / a01) >= 0.0 ? 1.0 / (r + ArrayMath.sqrt(1.0 + r * r)) : 1.0 / (r - ArrayMath.sqrt(1.0 + r * r)));
                c = 1.0 / ArrayMath.sqrt(1.0 + t * t);
                s = t * c;
                u = s / (1.0 + c);
                r = t * a01;
                a00 -= r;
                a11 += r;
                a01 = 0.0;
                apr = a02;
                aqr = a12;
                a02 = apr - s * (aqr + apr * u);
                a12 = aqr + s * (apr - aqr * u);
                vpr = v00;
                vqr = v10;
                v00 = vpr - s * (vqr + vpr * u);
                v10 = vqr + s * (vpr - vqr * u);
                vpr = v01;
                vqr = v11;
                v01 = vpr - s * (vqr + vpr * u);
                v11 = vqr + s * (vpr - vqr * u);
                vpr = v02;
                vqr = v12;
                v02 = vpr - s * (vqr + vpr * u);
                v12 = vqr + s * (vpr - vqr * u);
            } else if (aa02 >= aa01 && aa02 >= aa12) {
                u = a22 - a00;
                t = ArrayMath.abs(a02) < tiny * ArrayMath.abs(u) ? a02 / u : ((r = 0.5 * u / a02) >= 0.0 ? 1.0 / (r + ArrayMath.sqrt(1.0 + r * r)) : 1.0 / (r - ArrayMath.sqrt(1.0 + r * r)));
                c = 1.0 / ArrayMath.sqrt(1.0 + t * t);
                s = t * c;
                u = s / (1.0 + c);
                r = t * a02;
                a00 -= r;
                a22 += r;
                a02 = 0.0;
                apr = a01;
                aqr = a12;
                a01 = apr - s * (aqr + apr * u);
                a12 = aqr + s * (apr - aqr * u);
                vpr = v00;
                vqr = v20;
                v00 = vpr - s * (vqr + vpr * u);
                v20 = vqr + s * (vpr - vqr * u);
                vpr = v01;
                vqr = v21;
                v01 = vpr - s * (vqr + vpr * u);
                v21 = vqr + s * (vpr - vqr * u);
                vpr = v02;
                vqr = v22;
                v02 = vpr - s * (vqr + vpr * u);
                v22 = vqr + s * (vpr - vqr * u);
            } else {
                u = a22 - a11;
                t = ArrayMath.abs(a12) < tiny * ArrayMath.abs(u) ? a12 / u : ((r = 0.5 * u / a12) >= 0.0 ? 1.0 / (r + ArrayMath.sqrt(1.0 + r * r)) : 1.0 / (r - ArrayMath.sqrt(1.0 + r * r)));
                c = 1.0 / ArrayMath.sqrt(1.0 + t * t);
                s = t * c;
                u = s / (1.0 + c);
                r = t * a12;
                a11 -= r;
                a22 += r;
                a12 = 0.0;
                apr = a01;
                aqr = a02;
                a01 = apr - s * (aqr + apr * u);
                a02 = aqr + s * (apr - aqr * u);
                vpr = v10;
                vqr = v20;
                v10 = vpr - s * (vqr + vpr * u);
                v20 = vqr + s * (vpr - vqr * u);
                vpr = v11;
                vqr = v21;
                v11 = vpr - s * (vqr + vpr * u);
                v21 = vqr + s * (vpr - vqr * u);
                vpr = v12;
                vqr = v22;
                v12 = vpr - s * (vqr + vpr * u);
                v22 = vqr + s * (vpr - vqr * u);
            }
            aa01 = ArrayMath.abs(a01);
            aa02 = ArrayMath.abs(a02);
            aa12 = ArrayMath.abs(a12);
            ++nrot;
        }
        d[0] = a00;
        d[1] = a11;
        d[2] = a22;
        v[0][0] = v00;
        v[0][1] = v01;
        v[0][2] = v02;
        v[1][0] = v10;
        v[1][1] = v11;
        v[1][2] = v12;
        v[2][0] = v20;
        v[2][1] = v21;
        v[2][2] = v22;
        Eigen.sortDescending33(v, d);
    }
}

