/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.EigenTensors3;
import edu.mines.jtk.util.ArrayMath;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EigenTensors3Test
extends TestCase {
    private static Random r = new Random();

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(EigenTensors3Test.class);
        TestRunner.run((Test)suite);
    }

    public static void testRandom() {
        EigenTensors3Test.testRandom(true, 1.0, 0.001, 0.01);
        EigenTensors3Test.testRandom(false, 0.1, 1.0E-6, 0.001);
    }

    private static void testRandom(boolean compressed, double errorAngle, double errorValue, double errorTensor) {
        int n1 = 19;
        int n2 = 20;
        int n3 = 21;
        EigenTensors3 et = new EigenTensors3(n1, n2, n3, compressed);
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    float[] a = EigenTensors3Test.makeRandomEigenvalues();
                    float[] u = EigenTensors3Test.makeRandomEigenvector();
                    float[] w = EigenTensors3Test.makeOrthogonalVector(u);
                    et.setEigenvalues(i1, i2, i3, a);
                    et.setEigenvectorU(i1, i2, i3, u);
                    et.setEigenvectorW(i1, i2, i3, w);
                    float[] c = et.getEigenvectorU(i1, i2, i3);
                    EigenTensors3Test.checkEigenvectors(u, c, errorAngle);
                    c = et.getEigenvectorW(i1, i2, i3);
                    EigenTensors3Test.checkEigenvectors(w, c, errorAngle);
                    c = et.getEigenvalues(i1, i2, i3);
                    EigenTensors3Test.checkEigenvalues(a, c, errorValue);
                    float[] t1 = et.getTensor(i1, i2, i3);
                    et.setTensor(i1, i2, i3, t1);
                    float[] t2 = et.getTensor(i1, i2, i3);
                    EigenTensors3Test.checkTensors(t1, t2, errorTensor);
                }
            }
        }
    }

    public void testIO() throws IOException, ClassNotFoundException {
        int n1 = 3;
        int n2 = 4;
        int n3 = 5;
        EigenTensors3 et1 = new EigenTensors3(n1, n2, n3, false);
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    float[] a = EigenTensors3Test.makeRandomEigenvalues();
                    float[] u = EigenTensors3Test.makeRandomEigenvector();
                    float[] w = EigenTensors3Test.makeOrthogonalVector(u);
                    et1.setEigenvalues(i1, i2, i3, a);
                    et1.setEigenvectorU(i1, i2, i3, u);
                    et1.setEigenvectorW(i1, i2, i3, w);
                }
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(et1);
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        EigenTensors3 et2 = (EigenTensors3)ois.readObject();
        bais.close();
        float[] a1 = new float[3];
        float[] u1 = new float[3];
        float[] w1 = new float[3];
        float[] a2 = new float[3];
        float[] u2 = new float[3];
        float[] w2 = new float[3];
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    et1.getEigenvalues(i1, i2, i3, a1);
                    et1.getEigenvectorU(i1, i2, i3, u1);
                    et1.getEigenvectorW(i1, i2, i3, w1);
                    et2.getEigenvalues(i1, i2, i3, a2);
                    et2.getEigenvectorU(i1, i2, i3, u2);
                    et2.getEigenvectorW(i1, i2, i3, w2);
                    this.assertEqual(a1, a2);
                    this.assertEqual(u1, u2);
                    this.assertEqual(w1, w2);
                }
            }
        }
    }

    private void assertEqual(float[] e, float[] a) {
        for (int i = 0; i < e.length; ++i) {
            EigenTensors3Test.assertEquals((double)e[i], (double)a[i], (double)0.0);
        }
    }

    private static void checkEigenvalues(float[] a, float[] b, double e) {
        EigenTensors3Test.assertEquals((double)a[0], (double)b[0], (double)e);
        EigenTensors3Test.assertEquals((double)a[1], (double)b[1], (double)e);
        EigenTensors3Test.assertEquals((double)a[2], (double)b[2], (double)e);
    }

    private static void checkEigenvectors(float[] u, float[] v, double e) {
        boolean ok;
        float uv = Math.abs(u[0] * v[0] + u[1] * v[1] + u[2] * v[2]);
        double ce = 1.0 - Math.cos(Math.toRadians(e));
        boolean bl = ok = Math.abs(1.0 - (double)uv) < ce;
        if (!ok) {
            System.out.println("uv=" + uv + " ce=" + ce);
            System.out.println("expect:");
            ArrayMath.dump(u);
            System.out.println("actual:");
            ArrayMath.dump(v);
        }
        EigenTensors3Test.assertEquals((double)1.0, (double)uv, (double)ce);
    }

    private static void checkTensors(float[] s, float[] t, double e) {
        for (int i = 0; i < 6; ++i) {
            EigenTensors3Test.assertEquals((double)s[i], (double)t[i], (double)e);
        }
    }

    private static float[] makeRandomEigenvalues() {
        float a1 = r.nextFloat();
        float a2 = r.nextFloat();
        float a3 = r.nextFloat();
        float au = Math.max(Math.max(a1, a2), a3);
        float aw = Math.min(Math.min(a1, a2), a3);
        float av = a1 + a2 + a3 - au - aw;
        return new float[]{au, av, aw};
    }

    private static float[] makeRandomEigenvector() {
        float a = r.nextFloat() - 0.5f;
        float b = r.nextFloat() - 0.5f;
        float c = r.nextFloat() - 0.5f;
        if (c < 0.0f) {
            a = -a;
            b = -b;
            c = -c;
        }
        float s = 1.0f / (float)Math.sqrt(a * a + b * b + c * c);
        return new float[]{a * s, b * s, c * s};
    }

    private static float[] makeOrthogonalVector(float[] v1) {
        float a1 = v1[0];
        float b1 = v1[1];
        float c1 = v1[2];
        float a2 = r.nextFloat() - 0.5f;
        float b2 = r.nextFloat() - 0.5f;
        float c2 = r.nextFloat() - 0.5f;
        float d11 = a1 * a1 + b1 * b1 + c1 * c1;
        float d12 = a1 * a2 + b1 * b2 + c1 * c2;
        float s = d12 / d11;
        float a = a2 - s * a1;
        float b = b2 - s * b1;
        float c = c2 - s * c1;
        if (c < 0.0f) {
            a = -a;
            b = -b;
            c = -c;
        }
        s = 1.0f / (float)Math.sqrt(a * a + b * b + c * c);
        return new float[]{a * s, b * s, c * s};
    }
}

