/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.awt.ColorMap;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.interp.SibsonInterpolator2;
import edu.mines.jtk.interp.TestFunction;
import edu.mines.jtk.mosaic.PixelsView;
import edu.mines.jtk.mosaic.PointsView;
import edu.mines.jtk.mosaic.SimplePlot;
import edu.mines.jtk.util.ArrayMath;
import javax.swing.SwingUtilities;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SibsonInterpolator2Test
extends TestCase {
    private static final float XMIN = 0.0f;
    private static final float XMAX = 1.0f;
    private static final int NS = 49;
    private static final int NX = 201;
    private static final double DX = (double)0.005f;
    private static final double FX = 0.0;
    private static final Sampling SX = new Sampling(201, 0.005f, 0.0);
    private static SibsonInterpolator2.Method HL = SibsonInterpolator2.Method.HALE_LIANG;
    private static SibsonInterpolator2.Method BS = SibsonInterpolator2.Method.BRAUN_SAMBRIDGE;
    private static SibsonInterpolator2.Method WS = SibsonInterpolator2.Method.WATSON_SAMBRIDGE;
    private static final double TOLERANCE = 1.0E-5;

    public static void main(String[] args) {
        if (args.length >= 1 && args[0].equals("demo")) {
            SibsonInterpolator2Test.demo();
            return;
        }
        TestSuite suite = new TestSuite(SibsonInterpolator2Test.class);
        TestRunner.run((Test)suite);
    }

    public void testSimpleTri() {
        this.testSimpleTri(HL);
        this.testSimpleTri(BS);
        this.testSimpleTri(WS);
    }

    private void testSimpleTri(SibsonInterpolator2.Method m) {
        float[] f = new float[]{-2.0f, 0.0f, 1.0f};
        float[] x1 = new float[]{-1.0f, 1.0f, 0.0f};
        float[] x2 = new float[]{-1.0f, -1.0f, 1.0f};
        SibsonInterpolator2 si = new SibsonInterpolator2(m, f, x1, x2);
        this.assertValue(si, -0.5f, -0.5f, -1.0f);
        this.assertValue(si, 0.5f, -0.5f, 0.0f);
        this.assertValue(si, 0.0f, 0.5f, 0.5f);
        this.assertValue(si, 0.0f, 0.0f, 0.0f);
    }

    public void testSimpleSquare() {
        this.testSimpleSquare(HL);
        this.testSimpleSquare(BS);
    }

    private void testSimpleSquare(SibsonInterpolator2.Method m) {
        float[] f = new float[]{-2.0f, 0.0f, 0.0f, 2.0f};
        float[] x1 = new float[]{-1.0f, 1.0f, -1.0f, 1.0f};
        float[] x2 = new float[]{-1.0f, -1.0f, 1.0f, 1.0f};
        SibsonInterpolator2 si = new SibsonInterpolator2(m, f, x1, x2);
        si.setNullValue(999.0f);
        this.assertValue(si, 0.0f, 0.0f, 0.0f);
        this.assertValue(si, -0.5f, -0.5f, -1.0f);
        this.assertValue(si, 0.5f, -0.5f, 0.0f);
        this.assertValue(si, -0.5f, 0.5f, 0.0f);
        this.assertValue(si, 0.5f, 0.5f, 1.0f);
    }

    public void testLinear() {
        this.testLinear(HL);
        this.testLinear(BS);
    }

    private void testLinear(SibsonInterpolator2.Method m) {
        TestFunction tf = TestFunction.makeLinear();
        float[][] fx = tf.sampleUniform2(49, 0.0f, 1.0f, 0.0f, 1.0f);
        float[] f = fx[0];
        float[] x1 = fx[1];
        float[] x2 = fx[2];
        SibsonInterpolator2 si = new SibsonInterpolator2(m, f, x1, x2);
        si.setNullValue(999.0f);
        int n1 = 201;
        int n2 = 201;
        Sampling s1 = SX;
        Sampling s2 = SX;
        float[][] g = si.interpolate(s1, s2);
        for (int i2 = 0; i2 < n2; ++i2) {
            float x2i = (float)s2.getValue(i2);
            for (int i1 = 0; i1 < n1; ++i1) {
                float x1i = (float)s1.getValue(i1);
                float fe = tf.f(x1i, x2i);
                this.assertEquals(fe, g[i2][i1]);
            }
        }
    }

    private void assertEquals(float e, float a) {
        SibsonInterpolator2Test.assertEquals((double)e, (double)a, (double)1.0E-5);
    }

    private void assertValue(SibsonInterpolator2 si, float x1, float x2, float f) {
        float g = si.interpolate(x1, x2);
        this.assertEquals(f, g);
    }

    public static void demo() {
        TestFunction[] tfa;
        TestFunction tfs = TestFunction.makeSine();
        TestFunction tfl = TestFunction.makeLinear();
        TestFunction tfq = TestFunction.makeSphericalQuadratic();
        for (TestFunction tf : tfa = new TestFunction[]{tfs, tfl, tfq}) {
            SibsonInterpolator2Test.doScattered(tf);
            SibsonInterpolator2Test.doUniform(tf);
        }
    }

    private static void doScattered(TestFunction tf) {
        float[][] fx = tf.sampleScattered2(49, 0.0f, 1.0f, 0.0f, 1.0f);
        SibsonInterpolator2Test.doMethods(tf, fx);
    }

    private static void doUniform(TestFunction tf) {
        float[][] fx = tf.sampleUniform2(49, 0.0f, 1.0f, 0.0f, 1.0f);
        SibsonInterpolator2Test.doMethods(tf, fx);
    }

    private static void doSkinnyTriangle() {
        float xmin = 0.25f;
        float xmax = 0.75f;
        float xmid = 0.5f * (xmin + xmax);
        float xtop = xmid + 0.1f * (xmax - xmin);
        float[] x1 = new float[]{xmin, xmax, xmid};
        float[] x2 = new float[]{xmid, xmid, xtop};
        float[] f = new float[]{1.0f, 0.5f, 1.0f};
        float[][] fx = new float[][]{f, x1, x2};
        SibsonInterpolator2Test.doMethods(null, fx);
    }

    private static void doSimpleTriangle() {
        float xmin = 0.35f;
        float xmax = 0.65f;
        float xavg = 0.5f * (xmin + xmax);
        float[] x1 = new float[]{xmin, xmax, xavg};
        float[] x2 = new float[]{xmin, xmin, xmax};
        float[] f = new float[]{xmin + xmin, xmax + xmin, xavg + xmax};
        float[][] fx = new float[][]{f, x1, x2};
        SibsonInterpolator2Test.doMethods(null, fx);
    }

    private static void doSimpleSquare() {
        float xmin = 0.35f;
        float xmax = 0.65f;
        float[] x1 = new float[]{xmin, xmax, xmin, xmax};
        float[] x2 = new float[]{xmin, xmin, xmax, xmax};
        float[] f = new float[]{xmin + xmin, xmax + xmin, xmin + xmax, xmax + xmax};
        float[][] fx = new float[][]{f, x1, x2};
        SibsonInterpolator2Test.doMethods(null, fx);
    }

    private static void doMethods(TestFunction tf, float[][] fx) {
        SibsonInterpolator2.Method[] methods;
        float[] f = fx[0];
        float[] x1 = fx[1];
        float[] x2 = fx[2];
        float[][] fk = null;
        float fkmin = 0.0f;
        float fkmax = 0.0f;
        if (tf != null) {
            fk = tf.sampleUniform2(SX, SX);
            fkmin = ArrayMath.min(fk);
            fkmax = ArrayMath.max(fk);
            SibsonInterpolator2Test.plot("known", fkmin, fkmax, fk, x1, x2);
        }
        for (SibsonInterpolator2.Method method : methods = new SibsonInterpolator2.Method[]{HL}) {
            SibsonInterpolator2 si = new SibsonInterpolator2(method, f, x1, x2);
            si.setNullValue(1.0f);
            si.setBounds(SX, SX);
            si.setGradientPower(1.0);
            float[][] fi = si.interpolate(SX, SX);
            SibsonInterpolator2Test.plot(method.toString() + " interpolated", fkmin, fkmax, fi, x1, x2);
            if (fk == null) continue;
            float[][] fe = ArrayMath.sub(fi, fk);
            SibsonInterpolator2Test.plot(method.toString() + " interpolation error", 0.0f, 0.0f, fe, x1, x2);
        }
    }

    private static void plot(final String method, final float cmin, final float cmax, final float[][] g, final float[] x1, final float[] x2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.out.println("min=" + ArrayMath.min(g) + " max=" + ArrayMath.max(g));
                SimplePlot sp = new SimplePlot();
                sp.setTitle(method);
                sp.setSize(847, 740);
                sp.addColorBar();
                sp.getPlotPanel().setColorBarWidthMinimum(100);
                PixelsView pv = sp.addPixels(SX, SX, g);
                pv.setColorModel(ColorMap.JET);
                pv.setInterpolation(PixelsView.Interpolation.LINEAR);
                if (cmin < cmax) {
                    pv.setClips(cmin, cmax);
                }
                PointsView px = sp.addPoints(x1, x2);
                px.setLineStyle(PointsView.Line.NONE);
                px.setMarkStyle(PointsView.Mark.FILLED_CIRCLE);
                px.setMarkSize(6.0f);
            }
        });
    }
}

