/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.interp.LasserreVolume;
import edu.mines.jtk.la.DMatrix;
import edu.mines.jtk.la.DMatrixQrd;
import edu.mines.jtk.mesh.Geometry;
import edu.mines.jtk.mesh.TetMesh;
import edu.mines.jtk.util.Check;
import java.util.ArrayList;
import java.util.logging.Logger;

public class SibsonInterpolator3 {
    private static Logger log = Logger.getLogger(SibsonInterpolator3.class.getName());
    private TetMesh _mesh;
    private TetMesh.Node[] _nodes;
    private TetMesh.NodeList _nodeList;
    private TetMesh.TetList _tetList;
    private VolumeAccumulator _va;
    private boolean _haveGradients;
    private double _gradientPower;
    private float _fnull;
    private float _x1min;
    private float _x1max;
    private float _x2min;
    private float _x2max;
    private float _x3min;
    private float _x3max;
    private float _x1bmn;
    private float _x1bmx;
    private float _x2bmn;
    private float _x2bmx;
    private float _x3bmn;
    private float _x3bmx;
    private boolean _useBoundingBox;

    public SibsonInterpolator3(float[] x1, float[] x2, float[] x3) {
        this(Method.HALE_LIANG, null, x1, x2, x3);
    }

    public SibsonInterpolator3(float[] f, float[] x1, float[] x2, float[] x3) {
        this(Method.HALE_LIANG, f, x1, x2, x3);
    }

    public SibsonInterpolator3(Method method, float[] x1, float[] x2, float[] x3) {
        this(method, null, x1, x2, x3);
    }

    public SibsonInterpolator3(Method method, float[] f, float[] x1, float[] x2, float[] x3) {
        this.makeMesh(f, x1, x2, x3);
        this._nodeList = new TetMesh.NodeList();
        this._tetList = new TetMesh.TetList();
        if (method == Method.WATSON_SAMBRIDGE) {
            this._va = new WatsonSambridge();
        } else if (method == Method.BRAUN_SAMBRIDGE) {
            this._va = new BraunSambridge();
        } else if (method == Method.HALE_LIANG) {
            this._va = new HaleLiang();
        }
    }

    public void setSamples(float[] f, float[] x1, float[] x2, float[] x3) {
        this.makeMesh(f, x1, x2, x3);
        this._haveGradients = false;
        if (this._gradientPower > 0.0) {
            this.estimateGradients();
        }
    }

    public void setGradients(float[] g1, float[] g2, float[] g3) {
        int n = g1.length;
        for (int i = 0; i < n; ++i) {
            TetMesh.Node node = this._nodes[i];
            NodeData data = SibsonInterpolator3.data(node);
            data.gx = g1[i];
            data.gy = g2[i];
            data.gz = g3[i];
        }
        this._haveGradients = true;
        if (this._gradientPower == 0.0) {
            this._gradientPower = 1.0;
        }
    }

    public void setGradientPower(double gradientPower) {
        if (!this._haveGradients && gradientPower > 0.0) {
            this.estimateGradients();
        }
        this._gradientPower = gradientPower;
    }

    public void setNullValue(float fnull) {
        this._fnull = fnull;
    }

    public void setBounds(float x1min, float x1max, float x2min, float x2max, float x3min, float x3max) {
        Check.argument(x1min < x1max, "x1min<x1max");
        Check.argument(x2min < x2max, "x2min<x2max");
        Check.argument(x3min < x3max, "x3min<x3max");
        this._x1bmn = x1min;
        this._x1bmx = x1max;
        this._x2bmn = x2min;
        this._x2bmx = x2max;
        this._x3bmn = x3min;
        this._x3bmx = x3max;
        this._useBoundingBox = true;
        float scale = 1.0f;
        float x1avg = 0.5f * (x1min + x1max);
        float x2avg = 0.5f * (x2min + x2max);
        float x3avg = 0.5f * (x3min + x3max);
        float x1dif = Math.max(x1max - this._x1min, this._x1max - x1min);
        float x2dif = Math.max(x2max - this._x2min, this._x2max - x2min);
        float x3dif = Math.max(x3max - this._x3min, this._x3max - x3min);
        float x1pad = scale * x1dif;
        float x2pad = scale * x2dif;
        float x3pad = scale * x3dif;
        float[] x1g = new float[]{x1min -= x1pad, x1max += x1pad, x1avg, x1avg, x1avg, x1avg};
        float[] x2g = new float[]{x2avg, x2avg, x2min -= x2pad, x2max += x2pad, x2avg, x2avg};
        float[] x3g = new float[]{x3avg, x3avg, x3avg, x3avg, x3min -= x3pad, x3max += x2pad};
        this.addGhostNodes(x1g, x2g, x3g);
    }

    public void setBounds(Sampling s1, Sampling s2, Sampling s3) {
        this.setBounds((float)s1.getFirst(), (float)s1.getLast(), (float)s2.getFirst(), (float)s2.getLast(), (float)s3.getFirst(), (float)s3.getLast());
    }

    public void useConvexHullBounds() {
        this._useBoundingBox = false;
        this.removeGhostNodes();
    }

    public float interpolate(float x1, float x2, float x3) {
        if (!this.inBounds(x1, x2, x3)) {
            return this._fnull;
        }
        double vsum = this.computeVolumes(x1, x2, x3);
        if (vsum <= 0.0) {
            return this._fnull;
        }
        if (this.usingGradients()) {
            return this.interpolate1(vsum, x1, x2, x3);
        }
        return this.interpolate0(vsum);
    }

    public float[][][] interpolate(Sampling s1, Sampling s2, Sampling s3) {
        log.fine("interpolate: begin");
        int n1 = s1.getCount();
        int n2 = s2.getCount();
        int n3 = s2.getCount();
        float[][][] f = new float[n3][n2][n1];
        for (int i3 = 0; i3 < n3; ++i3) {
            log.fine("interpolate: i3=" + i3);
            float x3 = (float)s3.getValue(i3);
            for (int i2 = 0; i2 < n2; ++i2) {
                log.finer("interpolate: i2=" + i2);
                float x2 = (float)s2.getValue(i2);
                for (int i1 = 0; i1 < n1; ++i1) {
                    float x1 = (float)s1.getValue(i1);
                    f[i3][i2][i1] = this.interpolate(x1, x2, x3);
                }
            }
        }
        log.fine("interpolate: end");
        return f;
    }

    public IndexWeight[] getIndexWeights(float x1, float x2, float x3) {
        if (!this.inBounds(x1, x2, x3)) {
            return null;
        }
        float wsum = (float)this.computeVolumes(x1, x2, x3);
        if (wsum == 0.0f) {
            return null;
        }
        float wscl = 1.0f / wsum;
        int nnode = this._nodeList.nnode();
        TetMesh.Node[] nodes = this._nodeList.nodes();
        IndexWeight[] iw = new IndexWeight[nnode];
        for (int inode = 0; inode < nnode; ++inode) {
            TetMesh.Node node = nodes[inode];
            int i = node.index;
            float w = (float)SibsonInterpolator3.volume(node) * wscl;
            iw[inode] = new IndexWeight(i, w);
        }
        return iw;
    }

    public float validate(int i) {
        return this.validate(new int[]{i})[0];
    }

    public float[] validate(int[] i) {
        int iv;
        int nv = i.length;
        for (int iv2 = 0; iv2 < nv; ++iv2) {
            this._mesh.removeNode(this._nodes[i[iv2]]);
        }
        float[] fv = new float[nv];
        for (iv = 0; iv < nv; ++iv) {
            TetMesh.Node node = this._nodes[i[iv]];
            float xn = node.x();
            float yn = node.y();
            float zn = node.z();
            fv[iv] = this.interpolate(xn, yn, zn);
        }
        for (iv = 0; iv < nv; ++iv) {
            this._mesh.addNode(this._nodes[i[iv]]);
        }
        return fv;
    }

    private static NodeData data(TetMesh.Node node) {
        return (NodeData)node.data;
    }

    private static float f(TetMesh.Node node) {
        return SibsonInterpolator3.data((TetMesh.Node)node).f;
    }

    private static float gx(TetMesh.Node node) {
        return SibsonInterpolator3.data((TetMesh.Node)node).gx;
    }

    private static float gy(TetMesh.Node node) {
        return SibsonInterpolator3.data((TetMesh.Node)node).gy;
    }

    private static float gz(TetMesh.Node node) {
        return SibsonInterpolator3.data((TetMesh.Node)node).gz;
    }

    private static double volume(TetMesh.Node node) {
        return SibsonInterpolator3.data((TetMesh.Node)node).volume;
    }

    private static boolean ghost(TetMesh.Node node) {
        return node.index < 0;
    }

    private void makeMesh(float[] f, float[] x1, float[] x2, float[] x3) {
        int i;
        int n = x1.length;
        this._x1min = x1[0];
        this._x1max = x1[0];
        this._x2min = x2[0];
        this._x2max = x2[0];
        this._x3min = x3[0];
        this._x3max = x3[0];
        for (i = 1; i < n; ++i) {
            if (x1[i] < this._x1min) {
                this._x1min = x1[i];
            }
            if (x1[i] > this._x1max) {
                this._x1max = x1[i];
            }
            if (x2[i] < this._x2min) {
                this._x2min = x2[i];
            }
            if (x2[i] > this._x2max) {
                this._x2max = x2[i];
            }
            if (x3[i] < this._x3min) {
                this._x3min = x3[i];
            }
            if (!(x3[i] > this._x3max)) continue;
            this._x3max = x3[i];
        }
        this._nodes = new TetMesh.Node[n];
        this._mesh = new TetMesh();
        for (i = 0; i < n; ++i) {
            float x1i = x1[i];
            float x2i = x2[i];
            float x3i = x3[i];
            if (x1i == this._x1min) {
                x1i -= Math.ulp(x1i);
            }
            if (x1i == this._x1max) {
                x1i += Math.ulp(x1i);
            }
            if (x2i == this._x2min) {
                x2i -= Math.ulp(x2i);
            }
            if (x2i == this._x2max) {
                x2i += Math.ulp(x2i);
            }
            if (x3i == this._x3min) {
                x3i -= Math.ulp(x3i);
            }
            if (x3i == this._x3max) {
                x3i += Math.ulp(x3i);
            }
            TetMesh.Node node = new TetMesh.Node(x1i, x2i, x3i);
            boolean added = this._mesh.addNode(node);
            Check.argument(added, "each sample has unique coordinates");
            NodeData data = new NodeData();
            node.data = data;
            node.index = i;
            if (f != null) {
                data.f = f[i];
            }
            this._nodes[i] = node;
        }
    }

    private boolean usingGradients() {
        return this._haveGradients && this._gradientPower > 0.0;
    }

    private void addGhostNodes(float[] x, float[] y, float[] z) {
        int ng = x.length;
        for (int ig = 0; ig < ng; ++ig) {
            float xg = x[ig];
            float yg = y[ig];
            float zg = z[ig];
            TetMesh.PointLocation pl = this._mesh.locatePoint(xg, yg, zg);
            if (!pl.isOutside()) continue;
            TetMesh.Node n = new TetMesh.Node(xg, yg, zg);
            n.data = new NodeData();
            n.index = -1 - ig;
            this._mesh.addNode(n);
        }
    }

    private void addGhostNodesWithValues(float[] x, float[] y, float[] z) {
        int ig;
        int ng = x.length;
        int nn = this._nodes.length;
        DMatrix[] a = new DMatrix[ng];
        DMatrix[] b = new DMatrix[ng];
        for (ig = 0; ig < ng; ++ig) {
            a[ig] = new DMatrix(nn, 4);
            b[ig] = new DMatrix(nn, 1);
        }
        for (int in = 0; in < nn; ++in) {
            TetMesh.Node n = this._nodes[in];
            double fn = SibsonInterpolator3.f(n);
            double xn = n.xp();
            double yn = n.yp();
            double zn = n.zp();
            for (int ig2 = 0; ig2 < ng; ++ig2) {
                double xg = x[ig2];
                double yg = y[ig2];
                double zg = z[ig2];
                double dx = xn - xg;
                double dy = yn - yg;
                double dz = zn - zg;
                double wn = 1.0 / Math.sqrt(dx * dx + dy * dy + dz * dz);
                a[ig2].set(in, 0, wn);
                a[ig2].set(in, 1, wn * dx);
                a[ig2].set(in, 2, wn * dy);
                a[ig2].set(in, 3, wn * dz);
                b[ig2].set(in, 0, wn * fn);
            }
        }
        for (ig = 0; ig < ng; ++ig) {
            float xg = x[ig];
            float yg = y[ig];
            float zg = z[ig];
            TetMesh.PointLocation pl = this._mesh.locatePoint(xg, yg, zg);
            if (!pl.isOutside()) continue;
            TetMesh.Node n = new TetMesh.Node(xg, yg, zg);
            n.index = -1 - ig;
            this._mesh.addNode(n);
            NodeData data = new NodeData();
            n.data = data;
            DMatrixQrd qrd = new DMatrixQrd(a[ig]);
            if (qrd.isFullRank()) {
                DMatrix s = qrd.solve(b[ig]);
                data.f = (float)s.get(0, 0);
                data.gx = (float)s.get(1, 0);
                data.gy = (float)s.get(2, 0);
                data.gz = (float)s.get(3, 0);
                continue;
            }
            TetMesh.Node m = this._mesh.findNodeNearest(xg, yg, zg);
            data.f = SibsonInterpolator3.f(m);
            data.gx = 0.0f;
            data.gy = 0.0f;
            data.gz = 0.0f;
        }
    }

    private void removeGhostNodes() {
        ArrayList<TetMesh.Node> gnodes = new ArrayList<TetMesh.Node>(8);
        TetMesh.NodeIterator ni = this._mesh.getNodes();
        while (ni.hasNext()) {
            TetMesh.Node n = ni.next();
            if (!SibsonInterpolator3.ghost(n)) continue;
            gnodes.add(n);
        }
        for (TetMesh.Node gnode : gnodes) {
            this._mesh.removeNode(gnode);
        }
    }

    private double computeVolumes(float x, float y, float z) {
        if (!this.getNaturalNabors(x, y, z)) {
            return 0.0;
        }
        return this._va.accumulateVolumes(x, y, z, this._mesh, this._nodeList, this._tetList);
    }

    private boolean inBounds(float x1, float x2, float x3) {
        return !this._useBoundingBox || this._x1bmn <= x1 && x1 <= this._x1bmx && this._x2bmn <= x2 && x2 <= this._x2bmx && this._x3bmn <= x3 && x3 <= this._x3bmx;
    }

    private boolean getNaturalNabors(float x, float y, float z) {
        this._mesh.clearNodeMarks();
        this._mesh.clearTetMarks();
        this._nodeList.clear();
        this._tetList.clear();
        TetMesh.PointLocation pl = this._mesh.locatePoint(x, y, z);
        if (pl.isOutside()) {
            return false;
        }
        this.addTet(x, y, z, pl.tet());
        return true;
    }

    private void addTet(double xp, double yp, double zp, TetMesh.Tet tet) {
        this._mesh.mark(tet);
        this._tetList.add(tet);
        this.addNode(tet.nodeA());
        this.addNode(tet.nodeB());
        this.addNode(tet.nodeC());
        this.addNode(tet.nodeD());
        TetMesh.Tet ta = tet.tetA();
        TetMesh.Tet tb = tet.tetB();
        TetMesh.Tet tc = tet.tetC();
        TetMesh.Tet td = tet.tetD();
        if (this.needTet(xp, yp, zp, ta)) {
            this.addTet(xp, yp, zp, ta);
        }
        if (this.needTet(xp, yp, zp, tb)) {
            this.addTet(xp, yp, zp, tb);
        }
        if (this.needTet(xp, yp, zp, tc)) {
            this.addTet(xp, yp, zp, tc);
        }
        if (this.needTet(xp, yp, zp, td)) {
            this.addTet(xp, yp, zp, td);
        }
    }

    private void addNode(TetMesh.Node node) {
        if (this._mesh.isMarked(node)) {
            return;
        }
        this._mesh.mark(node);
        this._nodeList.add(node);
        NodeData data = SibsonInterpolator3.data(node);
        data.volume = 0.0;
    }

    private boolean needTet(double xp, double yp, double zp, TetMesh.Tet tet) {
        double zd;
        double yd;
        double xd;
        double zc;
        double yc;
        double xc;
        double zb;
        double yb;
        double xb;
        double za;
        double ya;
        if (tet == null || this._mesh.isMarked(tet)) {
            return false;
        }
        TetMesh.Node na = tet.nodeA();
        TetMesh.Node nb = tet.nodeB();
        TetMesh.Node nc = tet.nodeC();
        TetMesh.Node nd = tet.nodeD();
        double xa = na.xp();
        return Geometry.inSphere(xa, ya = na.yp(), za = na.zp(), xb = nb.xp(), yb = nb.yp(), zb = nb.zp(), xc = nc.xp(), yc = nc.yp(), zc = nc.zp(), xd = nd.xp(), yd = nd.yp(), zd = nd.zp(), xp, yp, zp) > 0.0;
    }

    private float interpolate0(double vsum) {
        double vfsum = 0.0;
        int nnode = this._nodeList.nnode();
        TetMesh.Node[] nodes = this._nodeList.nodes();
        for (int inode = 0; inode < nnode; ++inode) {
            TetMesh.Node node = nodes[inode];
            float f = SibsonInterpolator3.f(node);
            double v = SibsonInterpolator3.volume(node);
            vfsum += v * (double)f;
        }
        return (float)(vfsum / vsum);
    }

    private float interpolate1(double vsum, double x, double y, double z) {
        int nnode = this._nodeList.nnode();
        TetMesh.Node[] nodes = this._nodeList.nodes();
        double fs = 0.0;
        double es = 0.0;
        double wds = 0.0;
        double wdds = 0.0;
        double wods = 0.0;
        for (int inode = 0; inode < nnode; ++inode) {
            double zn;
            double dz;
            double yn;
            double dy;
            TetMesh.Node n = nodes[inode];
            double f = SibsonInterpolator3.f(n);
            double gx = SibsonInterpolator3.gx(n);
            double gy = SibsonInterpolator3.gy(n);
            double gz = SibsonInterpolator3.gz(n);
            double v = SibsonInterpolator3.volume(n);
            double w = v / vsum;
            double xn = n.xp();
            double dx = x - xn;
            double dd = dx * dx + (dy = y - (yn = n.yp())) * dy + (dz = z - (zn = n.zp())) * dz;
            if (dd == 0.0) {
                return (float)f;
            }
            double d = Math.pow(dd, 0.5 * this._gradientPower);
            double wd = w * d;
            double wod = w / d;
            double wdd = w * dd;
            es += wod * (f + gx * dx + gy * dy + gz * dz);
            fs += w * f;
            wds += wd;
            wdds += wdd;
            wods += wod;
        }
        double alpha = wds / wods;
        double beta = wdds;
        return (float)((alpha * fs + beta * (es /= wods)) / (alpha + beta));
    }

    private void estimateGradients() {
        int nnode = this._nodes.length;
        for (int inode = 0; inode < nnode; ++inode) {
            this.estimateGradient(this._nodes[inode]);
        }
        this._haveGradients = true;
    }

    private void estimateGradient(TetMesh.Node n) {
        NodeData data = SibsonInterpolator3.data(n);
        double fn = data.f;
        double xn = n.xp();
        double yn = n.yp();
        double zn = n.zp();
        this._mesh.removeNode(n);
        double vsum = this.computeVolumes((float)xn, (float)yn, (float)zn);
        this._mesh.addNode(n);
        if (vsum > 0.0) {
            int nm = this._nodeList.nnode();
            TetMesh.Node[] ms = this._nodeList.nodes();
            double hxx = 0.0;
            double hxy = 0.0;
            double hxz = 0.0;
            double hyy = 0.0;
            double hyz = 0.0;
            double hzz = 0.0;
            double px = 0.0;
            double py = 0.0;
            double pz = 0.0;
            double nr = 0.0;
            for (int im = 0; im < nm; ++im) {
                TetMesh.Node m = ms[im];
                if (SibsonInterpolator3.ghost(m)) continue;
                double fm = SibsonInterpolator3.f(m);
                double wm = SibsonInterpolator3.volume(m);
                double xm = m.xp();
                double ym = m.yp();
                double zm = m.zp();
                double df = fn - fm;
                double dx = xn - xm;
                double dy = yn - ym;
                double dz = zn - zm;
                double ds = wm / (dx * dx + dy * dy + dz * dz);
                hxx += ds * dx * dx;
                hxy += ds * dx * dy;
                hxz += ds * dx * dz;
                hyy += ds * dy * dy;
                hyz += ds * dy * dz;
                hzz += ds * dz * dz;
                px += ds * dx * df;
                py += ds * dy * df;
                pz += ds * dz * df;
                nr += 1.0;
            }
            if (nr > 2.0) {
                double lxx = Math.sqrt(hxx);
                double lxy = hxy / lxx;
                double lxz = hxz / lxx;
                double dyy = hyy - lxy * lxy;
                double lyy = Math.sqrt(dyy);
                double lyz = (hyz - lxz * lxy) / lyy;
                double dzz = hzz - lxz * lxz - lyz * lyz;
                double lzz = Math.sqrt(dzz);
                double qx = px / lxx;
                double qy = (py - lxy * qx) / lyy;
                double qz = (pz - lxz * qx - lyz * qy) / lzz;
                double gz = qz / lzz;
                double gy = (qy - lyz * gz) / lyy;
                double gx = (qx - lxy * gy - lxz * gz) / lxx;
                data.gx = (float)gx;
                data.gy = (float)gy;
                data.gz = (float)gz;
            }
        }
    }

    private static class HaleLiang
    extends VolumeAccumulator {
        private FaceList _faceList = new FaceList();
        private double[] _xyz = new double[3];

        private HaleLiang() {
        }

        @Override
        public double accumulateVolumes(double xp, double yp, double zp, TetMesh mesh, TetMesh.NodeList nodeList, TetMesh.TetList tetList) {
            this.clear();
            this.processTets(xp, yp, zp, mesh, tetList);
            boolean ok = this.processFaces(xp, yp, zp);
            return ok ? this.sum() : 0.0;
        }

        private void processTets(double xp, double yp, double zp, TetMesh mesh, TetMesh.TetList tetList) {
            this._faceList.clear();
            int ntet = tetList.ntet();
            TetMesh.Tet[] tets = tetList.tets();
            for (int itet = 0; itet < ntet; ++itet) {
                TetMesh.Tet tet = tets[itet];
                TetMesh.Tet ta = tet.tetA();
                TetMesh.Tet tb = tet.tetB();
                TetMesh.Tet tc = tet.tetC();
                TetMesh.Tet td = tet.tetD();
                TetMesh.Node na = tet.nodeA();
                TetMesh.Node nb = tet.nodeB();
                TetMesh.Node nc = tet.nodeC();
                TetMesh.Node nd = tet.nodeD();
                tet.centerSphere(this._xyz);
                double xt = this._xyz[0] - xp;
                double yt = this._xyz[1] - yp;
                double zt = this._xyz[2] - zp;
                this.processTetNabor(xp, yp, zp, xt, yt, zt, mesh, ta, nb, nc, nd);
                this.processTetNabor(xp, yp, zp, xt, yt, zt, mesh, tb, nc, na, nd);
                this.processTetNabor(xp, yp, zp, xt, yt, zt, mesh, tc, nd, na, nb);
                this.processTetNabor(xp, yp, zp, xt, yt, zt, mesh, td, na, nc, nb);
            }
        }

        private void processTetNabor(double xp, double yp, double zp, double xt, double yt, double zt, TetMesh mesh, TetMesh.Tet ta, TetMesh.Node nb, TetMesh.Node nc, TetMesh.Node nd) {
            boolean saveFace = true;
            if (ta != null && mesh.isMarked(ta)) {
                ta.centerSphere(this._xyz);
                double xa = this._xyz[0] - xp;
                double ya = this._xyz[1] - yp;
                double za = this._xyz[2] - zp;
                double xb = nb.xp() - xp;
                double yb = nb.yp() - yp;
                double zb = nb.zp() - zp;
                double xd = nd.xp() - xp;
                double yd = nd.yp() - yp;
                double zd = nd.zp() - zp;
                double xc = nc.xp() - xp;
                double yc = nc.yp() - yp;
                double zc = nc.zp() - zp;
                double xbd = xb + xd;
                double ybd = yb + yd;
                double zbd = zb + zd;
                double xdc = xd + xc;
                double ydc = yd + yc;
                double zdc = zd + zc;
                double xcb = xc + xb;
                double ycb = yc + yb;
                double zcb = zc + zb;
                double xyz = yt * za - ya * zt;
                double yzx = zt * xa - za * xt;
                double zxy = xt * ya - xa * yt;
                this.accumulate(nb, xbd * xyz + ybd * yzx + zbd * zxy);
                this.accumulate(nd, xdc * xyz + ydc * yzx + zdc * zxy);
                this.accumulate(nc, xcb * xyz + ycb * yzx + zcb * zxy);
                saveFace = false;
            }
            if (saveFace) {
                this.addFace(xp, yp, zp, xt, yt, zt, nb, nc, nd);
            }
        }

        private void addFace(double xp, double yp, double zp, double xr, double yr, double zr, TetMesh.Node na, TetMesh.Node nb, TetMesh.Node nc) {
            double xa = na.xp();
            double ya = na.yp();
            double za = na.zp();
            double xb = nb.xp();
            double yb = nb.yp();
            double zb = nb.zp();
            double xc = nc.xp();
            double yc = nc.yp();
            double zc = nc.zp();
            Geometry.centerSphere(xp, yp, zp, xa, ya, za, xb, yb, zb, xc, yc, zc, this._xyz);
            double xf = this._xyz[0] - xp;
            double yf = this._xyz[1] - yp;
            double zf = this._xyz[2] - zp;
            this._faceList.add(na, nb, nc, xf, yf, zf, xr, yr, zr);
        }

        private boolean faceNaborsOk() {
            int nface = this._faceList.nface();
            ArrayList<Face> faces = this._faceList.faces();
            for (int iface = 0; iface < nface; ++iface) {
                Face face = faces.get(iface);
                if (face.fa != null && face.fb != null && face.fc != null) continue;
                return false;
            }
            return true;
        }

        private boolean processFaces(double xp, double yp, double zp) {
            if (!this.faceNaborsOk()) {
                return false;
            }
            int nface = this._faceList.nface();
            ArrayList<Face> faces = this._faceList.faces();
            for (int iface = 0; iface < nface; ++iface) {
                this.processFace(xp, yp, zp, faces.get(iface));
            }
            return true;
        }

        private void processFace(double xp, double yp, double zp, Face face) {
            TetMesh.Node na = face.na;
            TetMesh.Node nb = face.nb;
            TetMesh.Node nc = face.nc;
            double xa = na.xp() - xp;
            double ya = na.yp() - yp;
            double za = na.zp() - zp;
            double xb = nb.xp() - xp;
            double yb = nb.yp() - yp;
            double zb = nb.zp() - zp;
            double xc = nc.xp() - xp;
            double yc = nc.yp() - yp;
            double zc = nc.zp() - zp;
            double xab = xa + xb;
            double yab = ya + yb;
            double zab = za + zb;
            double xbc = xb + xc;
            double ybc = yb + yc;
            double zbc = zb + zc;
            double xca = xc + xa;
            double yca = yc + ya;
            double zca = zc + za;
            double x1 = face.xf;
            double y1 = face.yf;
            double z1 = face.zf;
            double x2 = face.xr;
            double y2 = face.yr;
            double z2 = face.zr;
            double xyz = y1 * z2 - y2 * z1;
            double yzx = z1 * x2 - z2 * x1;
            double zxy = x1 * y2 - x2 * y1;
            double vab = xab * xyz + yab * yzx + zab * zxy;
            double vbc = xbc * xyz + ybc * yzx + zbc * zxy;
            double vca = xca * xyz + yca * yzx + zca * zxy;
            this.accumulate(na, vab);
            this.accumulate(nb, -vab);
            this.accumulate(nb, vbc);
            this.accumulate(nc, -vbc);
            this.accumulate(nc, vca);
            this.accumulate(na, -vca);
            Face fa = face.fa;
            x2 = fa.xf;
            y2 = fa.yf;
            z2 = fa.zf;
            xyz = y1 * z2 - y2 * z1;
            yzx = z1 * x2 - z2 * x1;
            zxy = x1 * y2 - x2 * y1;
            this.accumulate(nb, xb * xyz + yb * yzx + zb * zxy);
            this.accumulate(nc, xbc * xyz + ybc * yzx + zbc * zxy);
            Face fb = face.fb;
            x2 = fb.xf;
            y2 = fb.yf;
            z2 = fb.zf;
            xyz = y1 * z2 - y2 * z1;
            yzx = z1 * x2 - z2 * x1;
            zxy = x1 * y2 - x2 * y1;
            this.accumulate(nc, xc * xyz + yc * yzx + zc * zxy);
            this.accumulate(na, xca * xyz + yca * yzx + zca * zxy);
            Face fc = face.fc;
            x2 = fc.xf;
            y2 = fc.yf;
            z2 = fc.zf;
            xyz = y1 * z2 - y2 * z1;
            yzx = z1 * x2 - z2 * x1;
            zxy = x1 * y2 - x2 * y1;
            this.accumulate(na, xa * xyz + ya * yzx + za * zxy);
            this.accumulate(nb, xab * xyz + yab * yzx + zab * zxy);
        }

        private static class FaceList {
            private int _nface;
            private ArrayList<Face> _faces = new ArrayList(48);

            private FaceList() {
            }

            int nface() {
                return this._nface;
            }

            ArrayList<Face> faces() {
                return this._faces;
            }

            void clear() {
                this._nface = 0;
            }

            void add(TetMesh.Node na, TetMesh.Node nb, TetMesh.Node nc, double xf, double yf, double zf, double xr, double yr, double zr) {
                if (this._nface == this._faces.size()) {
                    this._faces.add(new Face());
                }
                Face face = this._faces.get(this._nface);
                int nfound = 0;
                Face fa = null;
                Face fb = null;
                Face fc = null;
                for (int iface = 0; iface < this._nface && nfound < 3; ++iface) {
                    Face fi = this._faces.get(iface);
                    TetMesh.Node nai = fi.na;
                    TetMesh.Node nbi = fi.nb;
                    TetMesh.Node nci = fi.nc;
                    if (fa == null) {
                        if (nb == nci && nc == nbi) {
                            fa = fi;
                            fi.fa = face;
                            ++nfound;
                        } else if (nb == nbi && nc == nai) {
                            fa = fi;
                            fi.fc = face;
                            ++nfound;
                        } else if (nb == nai && nc == nci) {
                            fa = fi;
                            fi.fb = face;
                            ++nfound;
                        }
                    }
                    if (fb == null) {
                        if (nc == nai && na == nci) {
                            fb = fi;
                            fi.fb = face;
                            ++nfound;
                        } else if (nc == nci && na == nbi) {
                            fb = fi;
                            fi.fa = face;
                            ++nfound;
                        } else if (nc == nbi && na == nai) {
                            fb = fi;
                            fi.fc = face;
                            ++nfound;
                        }
                    }
                    if (fc != null) continue;
                    if (na == nbi && nb == nai) {
                        fc = fi;
                        fi.fc = face;
                        ++nfound;
                        continue;
                    }
                    if (na == nai && nb == nci) {
                        fc = fi;
                        fi.fb = face;
                        ++nfound;
                        continue;
                    }
                    if (na != nci || nb != nbi) continue;
                    fc = fi;
                    fi.fa = face;
                    ++nfound;
                }
                face.na = na;
                face.nb = nb;
                face.nc = nc;
                face.xf = xf;
                face.yf = yf;
                face.zf = zf;
                face.xr = xr;
                face.yr = yr;
                face.zr = zr;
                face.fa = fa;
                face.fb = fb;
                face.fc = fc;
                ++this._nface;
            }
        }

        private static class Face {
            TetMesh.Node na;
            TetMesh.Node nb;
            TetMesh.Node nc;
            double xf;
            double yf;
            double zf;
            double xr;
            double yr;
            double zr;
            Face fa;
            Face fb;
            Face fc;

            private Face() {
            }
        }
    }

    private static class BraunSambridge
    extends VolumeAccumulator {
        private LasserreVolume _lv = new LasserreVolume(3);

        private BraunSambridge() {
        }

        @Override
        public double accumulateVolumes(double x1i, double x2i, double x3i, TetMesh mesh, TetMesh.NodeList nodeList, TetMesh.TetList tetList) {
            this.clear();
            int nnode = nodeList.nnode();
            TetMesh.Node[] nodes = nodeList.nodes();
            for (int j = 0; j < nnode; ++j) {
                TetMesh.Node jnode = nodes[j];
                double x1j = jnode.xp();
                double x2j = jnode.yp();
                double x3j = jnode.zp();
                this._lv.clear();
                double x1s = 0.5 * (x1j + x1i);
                double x2s = 0.5 * (x2j + x2i);
                double x3s = 0.5 * (x3j + x3i);
                double x1d = x1j - x1i;
                double x2d = x2j - x2i;
                double x3d = x3j - x3i;
                this._lv.addHalfSpace(x1d, x2d, x3d, 0.0);
                for (int k = 0; k < nnode; ++k) {
                    TetMesh.Node knode;
                    if (j == k || mesh.findTet(jnode, knode = nodes[k]) == null) continue;
                    double x1k = knode.xp();
                    double x2k = knode.yp();
                    double x3k = knode.zp();
                    double x1e = x1k - x1j;
                    double x2e = x2k - x2j;
                    double x3e = x3k - x3j;
                    double x1t = 0.5 * (x1k + x1j) - x1s;
                    double x2t = 0.5 * (x2k + x2j) - x2s;
                    double x3t = 0.5 * (x3k + x3j) - x3s;
                    this._lv.addHalfSpace(x1e, x2e, x3e, x1e * x1t + x2e * x2t + x3e * x3t);
                }
                double vj = this._lv.getVolume();
                this.accumulate(jnode, vj);
            }
            return this.sum();
        }
    }

    private static class WatsonSambridge
    extends VolumeAccumulator {
        private double[] _ca = new double[3];
        private double[] _cb = new double[3];
        private double[] _cc = new double[3];
        private double[] _cd = new double[3];
        private double[] _ct = new double[3];

        private WatsonSambridge() {
        }

        @Override
        public double accumulateVolumes(double xp, double yp, double zp, TetMesh mesh, TetMesh.NodeList nodeList, TetMesh.TetList tetList) {
            this.clear();
            int ntet = tetList.ntet();
            TetMesh.Tet[] tets = tetList.tets();
            for (int itet = 0; itet < ntet; ++itet) {
                TetMesh.Tet tet = tets[itet];
                TetMesh.Node na = tet.nodeA();
                TetMesh.Node nb = tet.nodeB();
                TetMesh.Node nc = tet.nodeC();
                TetMesh.Node nd = tet.nodeD();
                double xa = na.xp();
                double ya = na.yp();
                double za = na.zp();
                double xb = nb.xp();
                double yb = nb.yp();
                double zb = nb.zp();
                double xc = nc.xp();
                double yc = nc.yp();
                double zc = nc.zp();
                double xd = nd.xp();
                double yd = nd.yp();
                double zd = nd.zp();
                Geometry.centerSphere(xp, yp, zp, xb, yb, zb, xc, yc, zc, xd, yd, zd, this._ca);
                Geometry.centerSphere(xp, yp, zp, xa, ya, za, xd, yd, zd, xc, yc, zc, this._cb);
                Geometry.centerSphere(xp, yp, zp, xa, ya, za, xb, yb, zb, xd, yd, zd, this._cc);
                Geometry.centerSphere(xp, yp, zp, xa, ya, za, xc, yc, zc, xb, yb, zb, this._cd);
                Geometry.centerSphere(xa, ya, za, xb, yb, zb, xc, yc, zc, xd, yd, zd, this._ct);
                double va = this.volume(this._cb, this._cc, this._cd, this._ct);
                double vb = this.volume(this._ca, this._cd, this._cc, this._ct);
                double vc = this.volume(this._ca, this._cb, this._cd, this._ct);
                double vd = this.volume(this._ca, this._cc, this._cb, this._ct);
                this.accumulate(na, va);
                this.accumulate(nb, vb);
                this.accumulate(nc, vc);
                this.accumulate(nd, vd);
            }
            return this.sum();
        }

        private double volume(double[] ci, double[] cj, double[] ck, double[] ct) {
            double xt = ct[0];
            double yt = ct[1];
            double zt = ct[2];
            double xi = ci[0] - xt;
            double yi = ci[1] - yt;
            double zi = ci[2] - zt;
            double xj = cj[0] - xt;
            double yj = cj[1] - yt;
            double zj = cj[2] - zt;
            double xk = ck[0] - xt;
            double yk = ck[1] - yt;
            double zk = ck[2] - zt;
            return xi * (yj * zk - yk * zj) + yi * (zj * xk - zk * xj) + zi * (xj * yk - xk * yj);
        }
    }

    private static abstract class VolumeAccumulator {
        private double _sum;

        private VolumeAccumulator() {
        }

        public abstract double accumulateVolumes(double var1, double var3, double var5, TetMesh var7, TetMesh.NodeList var8, TetMesh.TetList var9);

        protected void clear() {
            this._sum = 0.0;
        }

        protected double sum() {
            return this._sum;
        }

        protected void accumulate(TetMesh.Node node, double volume) {
            if (SibsonInterpolator3.ghost(node)) {
                return;
            }
            NodeData data = SibsonInterpolator3.data(node);
            data.volume += volume;
            this._sum += volume;
        }
    }

    private static class NodeData {
        float f;
        float gx;
        float gy;
        float gz;
        double volume;

        private NodeData() {
        }
    }

    public static class IndexWeight {
        public int index;
        public float weight;

        IndexWeight(int index, float weight) {
            this.index = index;
            this.weight = weight;
        }
    }

    public static enum Method {
        HALE_LIANG,
        BRAUN_SAMBRIDGE,
        WATSON_SAMBRIDGE;

    }
}

