/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.la;

import edu.mines.jtk.la.DMatrix;
import edu.mines.jtk.util.Check;

public class DMatrixLud {
    int _m;
    int _n;
    double[][] _lu;
    int[] _piv;
    int _pivsign;

    public DMatrixLud(DMatrix a) {
        int m = this._m = a.getM();
        int n = this._n = a.getN();
        this._lu = a.get();
        double[][] lu = this._lu;
        this._piv = new int[m];
        for (int i = 0; i < m; ++i) {
            this._piv[i] = i;
        }
        this._pivsign = 1;
        double[] lucolj = new double[m];
        for (int j = 0; j < n; ++j) {
            int i;
            int i2;
            for (i2 = 0; i2 < m; ++i2) {
                lucolj[i2] = lu[i2][j];
            }
            i2 = 0;
            while (i2 < m) {
                double[] lurowi = lu[i2];
                int kmax = Math.min(i2, j);
                double s = 0.0;
                for (int k = 0; k < kmax; ++k) {
                    s += lurowi[k] * lucolj[k];
                }
                int n2 = i2++;
                double d = lucolj[n2] - s;
                lucolj[n2] = d;
                lurowi[j] = d;
            }
            int p = j;
            for (i = j + 1; i < m; ++i) {
                if (!(Math.abs(lucolj[i]) > Math.abs(lucolj[p]))) continue;
                p = i;
            }
            if (p != j) {
                int k;
                for (k = 0; k < n; ++k) {
                    double t = lu[p][k];
                    lu[p][k] = lu[j][k];
                    lu[j][k] = t;
                }
                k = this._piv[p];
                this._piv[p] = this._piv[j];
                this._piv[j] = k;
                this._pivsign = -this._pivsign;
            }
            if (j >= m || lu[j][j] == 0.0) continue;
            for (i = j + 1; i < m; ++i) {
                double[] dArray = lu[i];
                int n3 = j;
                dArray[n3] = dArray[n3] / lu[j][j];
            }
        }
    }

    public boolean isNonSingular() {
        for (int j = 0; j < this._n; ++j) {
            if (this._lu[j][j] != 0.0) continue;
            return false;
        }
        return true;
    }

    public boolean isSingular() {
        return !this.isNonSingular();
    }

    public DMatrix getL() {
        double[][] l = new double[this._m][this._n];
        for (int i = 0; i < this._m; ++i) {
            for (int j = 0; j < this._n; ++j) {
                l[i][j] = i > j ? this._lu[i][j] : (i == j ? 1.0 : 0.0);
            }
        }
        return new DMatrix(this._m, this._n, l);
    }

    public DMatrix getU() {
        double[][] u = new double[this._n][this._n];
        for (int i = 0; i < this._n; ++i) {
            for (int j = 0; j < this._n; ++j) {
                u[i][j] = i <= j ? this._lu[i][j] : 0.0;
            }
        }
        return new DMatrix(this._n, this._n, u);
    }

    public int[] getPivot() {
        int[] p = new int[this._m];
        for (int i = 0; i < this._m; ++i) {
            p[i] = this._piv[i];
        }
        return p;
    }

    public DMatrix solve(DMatrix b) {
        int j;
        int i;
        int k;
        Check.argument(b.getM() == this._m, "A and B have the same number of rows");
        Check.state(this.isNonSingular(), "A is non-singular");
        int nx = b.getN();
        DMatrix xx = b.get(this._piv, 0, nx - 1);
        double[][] x = xx.getArray();
        for (k = 0; k < this._n; ++k) {
            for (i = k + 1; i < this._n; ++i) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = x[i];
                    int n = j;
                    dArray[n] = dArray[n] - x[k][j] * this._lu[i][k];
                }
            }
        }
        for (k = this._n - 1; k >= 0; --k) {
            int j2 = 0;
            while (j2 < nx) {
                double[] dArray = x[k];
                int n = j2++;
                dArray[n] = dArray[n] / this._lu[k][k];
            }
            for (i = 0; i < k; ++i) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = x[i];
                    int n = j;
                    dArray[n] = dArray[n] - x[k][j] * this._lu[i][k];
                }
            }
        }
        return xx;
    }

    public double det() {
        Check.state(this._m == this._n, "A is square");
        double d = this._pivsign;
        for (int j = 0; j < this._n; ++j) {
            d *= this._lu[j][j];
        }
        return d;
    }
}

