/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.awt.ColorMap;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.mosaic.PixelsView;
import edu.mines.jtk.mosaic.PlotFrame;
import edu.mines.jtk.mosaic.PlotPanelPixels3;
import edu.mines.jtk.util.ArrayMath;
import java.awt.Color;
import javax.swing.SwingUtilities;

public class PlotPanelPixels3Test {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlotPanelPixels3Test.test1();
                PlotPanelPixels3Test.test2();
            }
        });
    }

    private static void test1() {
        int n1 = 11;
        int n2 = 17;
        int n3 = 13;
        Sampling s1 = new Sampling(n1);
        Sampling s2 = new Sampling(n2);
        Sampling s3 = new Sampling(n3);
        float d1 = 1.0f / (float)Math.max(1, n1 - 1);
        float d2 = 1.0f / (float)Math.max(1, n2 - 1);
        float d3 = 1.0f / (float)Math.max(1, n3 - 1);
        float[][][] f = ArrayMath.rampfloat(0.0f, d1, d2, d3, n1, n2, n3);
        PlotPanelPixels3 plot = new PlotPanelPixels3(PlotPanelPixels3.Orientation.X1RIGHT, PlotPanelPixels3.AxesPlacement.LEFT_BOTTOM, s1, s2, s3, f);
        plot.addColorBar();
        plot.setLabel1("axis 1");
        plot.setLabel2("axis 2");
        plot.setLabel3("axis 3");
        plot.setLineColor(null);
        plot.setColorModel(ColorMap.JET);
        plot.setLineColor(Color.BLACK);
        plot.setInterpolation(PixelsView.Interpolation.NEAREST);
        PlotFrame frame = new PlotFrame(plot);
        frame.setFontSize(18.0f);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private static void test2() {
        int n1 = 11;
        int n2 = 17;
        int n3 = 13;
        Sampling s1 = new Sampling(n1);
        Sampling s2 = new Sampling(n2);
        Sampling s3 = new Sampling(n3);
        float[][][] f0 = ArrayMath.randfloat(n1, n2, n3);
        float[][][] f1 = ArrayMath.randfloat(n1, n2, n3);
        float[][][] f2 = ArrayMath.randfloat(n1, n2, n3);
        float[][][][] f = new float[][][][]{f0, f1, f2};
        PlotPanelPixels3 plot = new PlotPanelPixels3(PlotPanelPixels3.Orientation.X1DOWN, PlotPanelPixels3.AxesPlacement.LEFT_BOTTOM, s1, s2, s3, f);
        plot.setLabel1("axis 1");
        plot.setLabel2("axis 2");
        plot.setLabel3("axis 3");
        plot.setLineColor(Color.YELLOW);
        plot.setInterpolation(PixelsView.Interpolation.NEAREST);
        plot.setClips(0.0f, 1.0f);
        PlotFrame frame = new PlotFrame(plot);
        frame.setFontSize(18.0f);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

