/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.awt.ModeManager;
import edu.mines.jtk.awt.ModeToggleButton;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.sgl.AxesOrientation;
import edu.mines.jtk.sgl.BoundingBox;
import edu.mines.jtk.sgl.BoundingSphere;
import edu.mines.jtk.sgl.ImagePanelGroup;
import edu.mines.jtk.sgl.OrbitView;
import edu.mines.jtk.sgl.OrbitViewMode;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.SelectDragMode;
import edu.mines.jtk.sgl.TriangleGroup;
import edu.mines.jtk.sgl.ViewCanvas;
import edu.mines.jtk.sgl.World;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;

public class SimpleFrame
extends JFrame {
    private ViewCanvas _canvas;
    private OrbitView _view;
    private World _world;
    private ModeManager _modeManager;
    private JToolBar _toolBar;
    private static final int SIZE = 600;

    public SimpleFrame() {
        this((World)null, (AxesOrientation)null);
    }

    public SimpleFrame(AxesOrientation ao) {
        this(null, ao);
    }

    public SimpleFrame(World world) {
        this(world, null);
    }

    public SimpleFrame(World world, AxesOrientation ao) {
        if (world == null) {
            world = new World();
        }
        if (ao == null) {
            ao = AxesOrientation.XRIGHT_YOUT_ZDOWN;
        }
        this._world = world;
        this._view = new OrbitView(this._world);
        this._view.setAxesOrientation(ao);
        this._canvas = new ViewCanvas();
        this._canvas.setView(this._view);
        this._modeManager = new ModeManager();
        this._modeManager.add((Component)((Object)this._canvas));
        OrbitViewMode ovm = new OrbitViewMode(this._modeManager);
        SelectDragMode sdm = new SelectDragMode(this._modeManager);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        AbstractAction exitAction = new AbstractAction("Exit"){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        };
        JMenuItem exitItem = fileMenu.add(exitAction);
        exitItem.setMnemonic('X');
        JMenu modeMenu = new JMenu("Mode");
        modeMenu.setMnemonic('M');
        JMenuItem ovmItem = new JMenuItem(ovm);
        modeMenu.add(ovmItem);
        JMenuItem sdmItem = new JMenuItem(sdm);
        modeMenu.add(sdmItem);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(modeMenu);
        this._toolBar = new JToolBar(1);
        this._toolBar.setRollover(true);
        ModeToggleButton ovmButton = new ModeToggleButton(ovm);
        this._toolBar.add(ovmButton);
        ModeToggleButton sdmButton = new ModeToggleButton(sdm);
        this._toolBar.add(sdmButton);
        ovm.setActive(true);
        this.setDefaultCloseOperation(3);
        this.setSize(new Dimension(600, 600));
        this.add((Component)((Object)this._canvas), "Center");
        this.add((Component)this._toolBar, "West");
        this.setJMenuBar(menuBar);
        this.setVisible(true);
    }

    public ModeManager getModeManager() {
        return this._modeManager;
    }

    public JToolBar getJToolBar() {
        return this._toolBar;
    }

    public static SimpleFrame asTriangles(float[] xyz) {
        return SimpleFrame.asTriangles(true, xyz);
    }

    public static SimpleFrame asTriangles(boolean vn, float[] xyz) {
        return SimpleFrame.asTriangles(vn, xyz, null);
    }

    public static SimpleFrame asTriangles(float[] xyz, float[] rgb) {
        return SimpleFrame.asTriangles(true, xyz, rgb);
    }

    public static SimpleFrame asTriangles(boolean vn, Sampling sx, Sampling sy, float[][] z) {
        return SimpleFrame.asTriangles(new TriangleGroup(vn, sx, sy, z));
    }

    public static SimpleFrame asTriangles(boolean vn, Sampling sx, Sampling sy, float[][] z, float[][] r, float[][] g, float[][] b) {
        return SimpleFrame.asTriangles(new TriangleGroup(vn, sx, sy, z, r, g, b));
    }

    public static SimpleFrame asTriangles(boolean vn, float[] xyz, float[] rgb) {
        return SimpleFrame.asTriangles(new TriangleGroup(vn, xyz, rgb));
    }

    public static SimpleFrame asTriangles(TriangleGroup tg) {
        SimpleFrame sf = new SimpleFrame();
        sf.addTriangles(tg);
        sf.getOrbitView().setWorldSphere(tg.getBoundingSphere(true));
        return sf;
    }

    public static SimpleFrame asImagePanels(float[][][] f) {
        return SimpleFrame.asImagePanels(new ImagePanelGroup(f));
    }

    public static SimpleFrame asImagePanels(Sampling s1, Sampling s2, Sampling s3, float[][][] f) {
        return SimpleFrame.asImagePanels(new ImagePanelGroup(s1, s2, s3, f));
    }

    public static SimpleFrame asImagePanels(ImagePanelGroup ipg) {
        SimpleFrame sf = new SimpleFrame();
        sf.addImagePanels(ipg);
        sf.getOrbitView().setWorldSphere(ipg.getBoundingSphere(true));
        return sf;
    }

    public TriangleGroup addTriangles(float[] xyz) {
        return this.addTriangles(new TriangleGroup(true, xyz, null));
    }

    public TriangleGroup addTriangles(float[] xyz, float[] rgb) {
        return this.addTriangles(new TriangleGroup(true, xyz, rgb));
    }

    public TriangleGroup addTriangles(Sampling sx, Sampling sy, float[][] z) {
        return this.addTriangles(new TriangleGroup(true, sx, sy, z));
    }

    public TriangleGroup addTriangles(TriangleGroup tg) {
        this._world.addChild(tg);
        return tg;
    }

    public ImagePanelGroup addImagePanels(float[][][] f) {
        return this.addImagePanels(new Sampling(f[0][0].length), new Sampling(f[0].length), new Sampling(f.length), f);
    }

    public ImagePanelGroup addImagePanels(Sampling s1, Sampling s2, Sampling s3, float[][][] f) {
        return this.addImagePanels(new ImagePanelGroup(s1, s2, s3, f));
    }

    public ImagePanelGroup addImagePanels(ImagePanelGroup ipg) {
        this._world.addChild(ipg);
        return ipg;
    }

    public ViewCanvas getViewCanvas() {
        return this._canvas;
    }

    public OrbitView getOrbitView() {
        return this._view;
    }

    public World getWorld() {
        return this._world;
    }

    public void setWorldSphere(Point3 p, int r) {
        this.setWorldSphere(new BoundingSphere(p, r));
    }

    public void setWorldSphere(double x, double y, double z, double r) {
        this.setWorldSphere(new BoundingSphere(x, y, z, r));
    }

    public void setWorldSphere(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax) {
        this.setWorldSphere(new BoundingSphere(new BoundingBox(xmin, ymin, zmin, xmax, ymax, zmax)));
    }

    public void setWorldSphere(BoundingSphere bs) {
        this._view.setWorldSphere(bs);
    }

    public void paintToFile(String fileName) {
        this._canvas.paintToFile(fileName);
    }
}

