/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.MathPlus;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class MathPlusTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(MathPlusTest.class);
        TestRunner.run((Test)suite);
    }

    public void test() {
        this.assertEquals(0.0f, MathPlus.sin((float)Math.PI));
        this.assertEquals(0.0, MathPlus.sin(Math.PI));
        this.assertEquals(1.0f, MathPlus.cos((float)Math.PI * 2));
        this.assertEquals(1.0, MathPlus.cos(Math.PI * 2));
        this.assertEquals(1.0f, MathPlus.tan(0.7853982f));
        this.assertEquals(1.0, MathPlus.tan(0.7853981633974483));
        this.assertEquals(1.5707964f, MathPlus.asin(1.0f));
        this.assertEquals(1.5707963267948966, MathPlus.asin(1.0));
        this.assertEquals(1.5707964f, MathPlus.acos(0.0f));
        this.assertEquals(1.5707963267948966, MathPlus.acos(0.0));
        this.assertEquals(0.7853982f, MathPlus.atan(1.0f));
        this.assertEquals(0.7853981633974483, MathPlus.atan(1.0));
        this.assertEquals(1.5707964f, MathPlus.atan2(1.0f, 0.0f));
        this.assertEquals(1.5707963267948966, MathPlus.atan2(1.0, 0.0));
        this.assertEquals(-2.3561945f, MathPlus.atan2(-1.0f, -1.0f));
        this.assertEquals(-2.356194490192345, MathPlus.atan2(-1.0, -1.0));
        this.assertEquals((float)Math.PI, MathPlus.toRadians(180.0f));
        this.assertEquals(Math.PI, MathPlus.toRadians(180.0));
        this.assertEquals(180.0f, MathPlus.toDegrees((float)Math.PI));
        this.assertEquals(180.0, MathPlus.toDegrees(Math.PI));
        this.assertEquals(1.0f, MathPlus.log(MathPlus.exp(1.0f)));
        this.assertEquals(1.0, MathPlus.log(MathPlus.exp(1.0)));
        this.assertEquals(3.0f, MathPlus.sqrt(MathPlus.pow(3.0f, 2.0f)));
        this.assertEquals(3.0, MathPlus.sqrt(MathPlus.pow(3.0, 2.0)));
        this.assertEquals(MathPlus.tanh(1.0f), MathPlus.sinh(1.0f) / MathPlus.cosh(1.0f));
        this.assertEquals(MathPlus.tanh(1.0), MathPlus.sinh(1.0) / MathPlus.cosh(1.0));
        this.assertEquals(4.0f, MathPlus.ceil((float)Math.PI));
        this.assertEquals(4.0, MathPlus.ceil(Math.PI));
        this.assertEquals(-3.0f, MathPlus.ceil((float)(-Math.PI)));
        this.assertEquals(-3.0, MathPlus.ceil(-Math.PI));
        this.assertEquals(3.0f, MathPlus.floor((float)Math.PI));
        this.assertEquals(3.0, MathPlus.floor(Math.PI));
        this.assertEquals(-4.0f, MathPlus.floor((float)(-Math.PI)));
        this.assertEquals(-4.0, MathPlus.floor(-Math.PI));
        this.assertEquals(3.0f, MathPlus.rint((float)Math.PI));
        this.assertEquals(3.0, MathPlus.rint(Math.PI));
        this.assertEquals(-3.0f, MathPlus.rint((float)(-Math.PI)));
        this.assertEquals(-3.0, MathPlus.rint(-Math.PI));
        MathPlusTest.assertEquals((int)3, (int)MathPlus.round((float)Math.PI));
        MathPlusTest.assertEquals((long)3L, (long)MathPlus.round(Math.PI));
        MathPlusTest.assertEquals((int)-3, (int)MathPlus.round((float)(-Math.PI)));
        MathPlusTest.assertEquals((long)-3L, (long)MathPlus.round(-Math.PI));
        MathPlusTest.assertEquals((int)3, (int)MathPlus.round((float)Math.E));
        MathPlusTest.assertEquals((long)3L, (long)MathPlus.round(Math.E));
        MathPlusTest.assertEquals((int)-3, (int)MathPlus.round(-2.7182817f));
        MathPlusTest.assertEquals((long)-3L, (long)MathPlus.round(-2.718281828459045));
        this.assertEquals(1.0f, MathPlus.signum((float)Math.PI));
        this.assertEquals(1.0, MathPlus.signum(Math.PI));
        this.assertEquals(-1.0f, MathPlus.signum((float)(-Math.PI)));
        this.assertEquals(-1.0, MathPlus.signum(-Math.PI));
        this.assertEquals(0.0f, MathPlus.signum(0.0f));
        this.assertEquals(0.0, MathPlus.signum(0.0));
        MathPlusTest.assertEquals((int)2, (int)MathPlus.abs(2));
        MathPlusTest.assertEquals((long)2L, (long)MathPlus.abs(2L));
        this.assertEquals(2.0f, MathPlus.abs(2.0f));
        this.assertEquals(2.0, MathPlus.abs(2.0));
        MathPlusTest.assertEquals((int)2, (int)MathPlus.abs(-2));
        MathPlusTest.assertEquals((long)2L, (long)MathPlus.abs(-2L));
        this.assertEquals(2.0f, MathPlus.abs(-2.0f));
        this.assertEquals(2.0, MathPlus.abs(-2.0));
        MathPlusTest.assertEquals((String)"abs(float) changed sign of 0", (int)0, (int)Float.floatToIntBits(MathPlus.abs(0.0f)));
        MathPlusTest.assertEquals((String)"abs(double) changed sign of 0", (long)0L, (long)Double.doubleToLongBits(MathPlus.abs(0.0)));
        MathPlusTest.assertEquals((int)4, (int)MathPlus.max(1, 3, 4, 2));
        MathPlusTest.assertEquals((long)4L, (long)MathPlus.max(1L, 3L, 4L, 2L));
        this.assertEquals(4.0f, MathPlus.max(1.0f, 3.0f, 4.0f, 2.0f));
        this.assertEquals(4.0, MathPlus.max(1.0, 3.0, 4.0, 2.0));
        MathPlusTest.assertEquals((int)1, (int)MathPlus.min(3, 1, 4, 2));
        MathPlusTest.assertEquals((long)1L, (long)MathPlus.min(3L, 1L, 4L, 2L));
        this.assertEquals(1.0f, MathPlus.min(3.0f, 1.0f, 4.0f, 2.0f));
        this.assertEquals(1.0, MathPlus.min(3.0, 1.0, 4.0, 2.0));
    }

    private void assertEquals(float expected, float actual) {
        float small = 1.0E-6f * MathPlus.max(MathPlus.abs(expected), MathPlus.abs(actual), 1.0f);
        MathPlusTest.assertEquals((float)expected, (float)actual, (float)small);
    }

    private void assertEquals(double expected, double actual) {
        double small = (double)1.0E-12f * MathPlus.max(MathPlus.abs(expected), MathPlus.abs(actual), 1.0);
        MathPlusTest.assertEquals((double)expected, (double)actual, (double)small);
    }
}

