/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Quantiler;
import edu.mines.jtk.util.Stopwatch;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class QuantilerTest
extends TestCase {
    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("bench")) {
            QuantilerTest.bench();
        }
        TestSuite suite = new TestSuite(QuantilerTest.class);
        TestRunner.run((Test)suite);
    }

    public void testLinear() {
        int i;
        int n = 101;
        float[] f = new float[n];
        for (i = 0; i < n; ++i) {
            f[i] = (float)i / (float)(n - 1);
        }
        for (i = 0; i < n; ++i) {
            float q = f[i];
            Quantiler quantiler = new Quantiler(q);
            int nupdate = 20;
            for (int iupdate = 0; iupdate < nupdate; ++iupdate) {
                quantiler.update(f);
            }
            float e = quantiler.estimate();
            float elo = q - 0.01f;
            float ehi = q + 0.01f;
            QuantilerTest.assertTrue((elo <= e ? 1 : 0) != 0);
            QuantilerTest.assertTrue((e <= ehi ? 1 : 0) != 0);
        }
    }

    public void testRandom() {
        int n = 10000;
        float[] f = ArrayMath.randfloat(new Random(314159L), n);
        int ntest = 101;
        for (int itest = 0; itest < ntest; ++itest) {
            float q = (float)itest / (float)(ntest - 1);
            Quantiler quantiler = new Quantiler(q);
            quantiler.update(f);
            float e = quantiler.estimate();
            float elo = q - 0.01f;
            float ehi = q + 0.01f;
            QuantilerTest.assertTrue((elo <= e ? 1 : 0) != 0);
            QuantilerTest.assertTrue((e <= ehi ? 1 : 0) != 0);
        }
    }

    public static void bench() {
        Stopwatch sw = new Stopwatch();
        int n = 1000001;
        double maxtime = 2.0;
        for (int ntrial = 0; ntrial < 3; ++ntrial) {
            float[] f1 = ArrayMath.randfloat(n);
            float q1 = 0.0f;
            sw.restart();
            int nq = 0;
            while (sw.time() < maxtime) {
                Quantiler quantiler = new Quantiler(0.5f);
                quantiler.update(f1);
                q1 = quantiler.estimate();
                ++nq;
            }
            sw.stop();
            int rate = (int)(1.0E-6 * (double)nq * (double)n / sw.time());
            System.out.println("Quantiler:        median=" + q1 + " rate=" + rate);
            float q2 = 0.0f;
            sw.restart();
            nq = 0;
            while (sw.time() < maxtime) {
                float[] f2 = ArrayMath.copy(f1);
                ArrayMath.quickPartialSort(n / 2, f2);
                q2 = f2[n / 2];
                ++nq;
            }
            sw.stop();
            rate = (int)(1.0E-6 * (double)nq * (double)n / sw.time());
            System.out.println("quickPartialSort: median=" + q2 + " rate=" + rate);
        }
    }
}

