/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import math3d.FastMatrixN;
import math3d.Point3d;

public class Implicit_Interpolate_Binary
implements PlugInFilter {
    private double[] lut;
    ImagePlus image;
    public ImplicitSamples[] samples;
    public ImplicitFunction implicitFunction;

    public void run(ImageProcessor ip) {
        int z;
        ImageStack stack = this.image.getStack();
        int sliceCount = stack.getSize();
        if (sliceCount < 3) {
            IJ.error((String)"Too few slices to interpolate!");
            return;
        }
        GenericDialog gd = new GenericDialog("Interpolate");
        gd.addNumericField("step", 30.0, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int step = (int)gd.getNextNumber();
        IJ.showStatus((String)"getting samples");
        this.samples = new ImplicitSamples[sliceCount];
        for (z = 0; z < sliceCount; ++z) {
            ip = stack.getProcessor(z + 1);
            this.samples[z] = ImplicitSamples.from((ByteProcessor)ip, z);
        }
        IJ.showStatus((String)"calculating weights");
        this.getImplicitFunction(step);
        IJ.showStatus((String)"interpolating");
        for (z = 0; z < sliceCount; ++z) {
            if (this.samples[z] == null) {
                this.evaluate((ByteProcessor)stack.getProcessor(z + 1), z);
            }
            IJ.showProgress((int)(z + 1), (int)sliceCount);
        }
    }

    public void getImplicitFunction(int step) {
        int i;
        ArrayList ones = new ArrayList();
        ArrayList zeroes = new ArrayList();
        int n = 0;
        for (int z = 0; z < this.samples.length; ++z) {
            if (this.samples[z] == null) continue;
            Iterator iter = this.samples[z].ones.iterator();
            while (iter.hasNext()) {
                if (n++ % step == 0) {
                    ones.add(iter.next());
                    continue;
                }
                iter.next();
            }
            iter = this.samples[z].zeroes.iterator();
            while (iter.hasNext()) {
                if (n++ % step == 0) {
                    zeroes.add(iter.next());
                    continue;
                }
                iter.next();
            }
        }
        int onesSize = ones.size();
        int zeroesSize = zeroes.size();
        int rank = onesSize + zeroesSize + 4;
        double[][] matrix = new double[rank][rank];
        for (i = 0; i < rank - 4; ++i) {
            Point3d p1 = (Point3d)(i < onesSize ? ones.get(i) : zeroes.get(i - onesSize));
            for (int j = i + 1; j < rank - 4; ++j) {
                Point3d p2 = (Point3d)(j < onesSize ? ones.get(j) : zeroes.get(j - onesSize));
                double d = this.phi(p1, p2);
                matrix[j][i] = d;
                matrix[i][j] = d;
            }
        }
        for (i = 0; i < onesSize + zeroesSize; ++i) {
            Point3d p = (Point3d)(i < onesSize ? ones.get(i) : zeroes.get(i - onesSize));
            matrix[rank - 4][i] = 1.0;
            matrix[i][rank - 4] = 1.0;
            double d = p.x;
            matrix[rank - 3][i] = d;
            matrix[i][rank - 3] = d;
            double d2 = p.y;
            matrix[rank - 2][i] = d2;
            matrix[i][rank - 2] = d2;
            double d3 = p.z;
            matrix[rank - 1][i] = d3;
            matrix[i][rank - 1] = d3;
        }
        IJ.showStatus((String)("inverting " + rank + " x " + rank + " matrix"));
        FastMatrixN.invert((double[][])matrix, (boolean)true);
        this.implicitFunction = new ImplicitFunction(matrix, ones, zeroes);
    }

    public void evaluate(ByteProcessor ip, int z) {
        int w = ip.getWidth();
        int h = ip.getHeight();
        byte[] p = (byte[])ip.getPixels();
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                double v0 = this.implicitFunction.evaluate(i, j, z);
                p[i + j * w] = (byte)(v0 > 0.0 ? 255 : 0);
            }
        }
    }

    public final double phi(Point3d p, Point3d q) {
        return this.phi(p.x, p.y, p.z, q);
    }

    public final double phi(double x, double y, double z, Point3d q) {
        double squared = (x - q.x) * (x - q.x) + (y - q.y) * (y - q.y) + (z - q.z) * (z - q.z);
        return Implicit_Interpolate_Binary.phi(squared);
    }

    public static final double phi(double squared) {
        return squared > 0.0 ? squared * Math.log(Math.sqrt(squared)) : 0.0;
    }

    public final double phiLUT(double squared) {
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        int z = this.image.getStackSize();
        if (this.lut == null) {
            this.lut = new double[w * w + h * h + z * z];
            for (int i = 0; i < this.lut.length; ++i) {
                this.lut[i] = -1.0;
            }
        }
        int key_l = (int)Math.floor(squared);
        int key_u = key_l + 1;
        if (this.lut[key_l] < 0.0) {
            this.lut[key_l] = Implicit_Interpolate_Binary.phi(key_l);
        }
        if (this.lut[key_u] < 0.0) {
            this.lut[key_u] = Implicit_Interpolate_Binary.phi(key_u);
        }
        double value_l = this.lut[key_l];
        double value_u = this.lut[key_u];
        double ret = Math.abs(squared - (double)key_l) * Math.abs(value_u - value_l) / (double)(key_u - key_l) + value_l;
        return ret;
    }

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 1;
    }

    public class ImplicitFunction {
        Point3d[] points;
        double[] weights;
        double p0;
        double pX;
        double pY;
        double pZ;

        ImplicitFunction(double[][] matrix, ArrayList ones, ArrayList zeroes) {
            this.points = new Point3d[matrix.length - 4];
            this.weights = new double[this.points.length];
            int onesSize = ones.size();
            for (int i = 0; i < this.points.length; ++i) {
                this.points[i] = (Point3d)(i < onesSize ? ones.get(i) : zeroes.get(i - onesSize));
                for (int j = 0; j < onesSize; ++j) {
                    int n = i;
                    this.weights[n] = this.weights[n] + matrix[i][j];
                }
            }
            for (int j = 0; j < onesSize; ++j) {
                this.p0 += matrix[matrix.length - 4][j];
                this.pX += matrix[matrix.length - 3][j];
                this.pY += matrix[matrix.length - 2][j];
                this.pZ += matrix[matrix.length - 1][j];
            }
        }

        public double evaluate(Point3d p) {
            return this.evaluate(p.x, p.y, p.z);
        }

        public double evaluate(double x, double y, double z) {
            double result = this.p0 + this.pX * x + this.pY * y + this.pZ * z;
            for (int i = 0; i < this.points.length; ++i) {
                result += Implicit_Interpolate_Binary.this.phi(x, y, z, this.points[i]) * this.weights[i];
            }
            return result;
        }
    }

    public static class ImplicitSamples {
        ArrayList ones = new ArrayList();
        ArrayList zeroes = new ArrayList();

        ImplicitSamples() {
        }

        public static ImplicitSamples from(ByteProcessor ip, int z) {
            ImplicitSamples data = new ImplicitSamples();
            data.initFromSlice(ip, z);
            if (data.ones.size() == 0 && data.zeroes.size() == 0) {
                return null;
            }
            return data;
        }

        public void initFromSlice(ByteProcessor ip, int z) {
            int w = ip.getWidth();
            int h = ip.getHeight();
            byte[] p = (byte[])ip.getPixels();
            for (int j = 1; j < h; ++j) {
                for (int i = 1; i < w; ++i) {
                    byte b0 = p[i - 1 + (j - 1) * w];
                    byte b1 = p[i - 1 + j * w];
                    byte b2 = p[i + (j - 1) * w];
                    byte b3 = p[i + j * w];
                    if (b0 != 0 && b1 == 0 && b2 == 0 && b3 == 0) {
                        this.zeroes.add(new Point3d((double)i - 0.6, (double)j - 0.6, (double)z));
                        this.ones.add(new Point3d((double)i - 0.9, (double)j - 0.9, (double)z));
                        continue;
                    }
                    if (b0 == 0 && b1 != 0 && b2 == 0 && b3 == 0) {
                        this.zeroes.add(new Point3d((double)i - 0.6, (double)j - 0.4, (double)z));
                        this.ones.add(new Point3d((double)i - 0.9, (double)j - 0.1, (double)z));
                        continue;
                    }
                    if (b0 == 0 && b1 == 0 && b2 != 0 && b3 == 0) {
                        this.zeroes.add(new Point3d((double)i - 0.4, (double)j - 0.6, (double)z));
                        this.ones.add(new Point3d((double)i - 0.1, (double)j - 0.9, (double)z));
                        continue;
                    }
                    if (b0 == 0 && b1 == 0 && b2 == 0 && b3 != 0) {
                        this.zeroes.add(new Point3d((double)i - 0.4, (double)j - 0.4, (double)z));
                        this.ones.add(new Point3d((double)i - 0.1, (double)j - 0.1, (double)z));
                        continue;
                    }
                    if (b0 != 0 && b1 != 0 && b2 == 0 && b3 == 0) {
                        this.zeroes.add(new Point3d((double)i - 0.7, (double)j - 0.5, (double)z));
                        this.ones.add(new Point3d((double)(i - 1), (double)j - 0.5, (double)z));
                        continue;
                    }
                    if (b0 != 0 && b1 == 0 && b2 != 0 && b3 == 0) {
                        this.zeroes.add(new Point3d((double)i - 0.5, (double)j - 0.7, (double)z));
                        this.ones.add(new Point3d((double)i - 0.5, (double)(j - 1), (double)z));
                        continue;
                    }
                    if (b0 == 0 && b1 != 0 && b2 == 0 && b3 != 0) {
                        this.zeroes.add(new Point3d((double)i - 0.5, (double)j - 0.3, (double)z));
                        this.ones.add(new Point3d((double)i - 0.5, (double)j, (double)z));
                        continue;
                    }
                    if (b0 == 0 && b1 == 0 && b2 != 0 && b3 != 0) {
                        this.zeroes.add(new Point3d((double)i - 0.3, (double)j - 0.5, (double)z));
                        this.ones.add(new Point3d((double)i, (double)j - 0.5, (double)z));
                        continue;
                    }
                    if (b0 != 0 && b1 == 0 && b2 == 0 && b3 != 0) {
                        this.zeroes.add(new Point3d((double)i - 0.7, (double)j - 0.3, (double)z));
                        this.zeroes.add(new Point3d((double)i - 0.3, (double)j - 0.7, (double)z));
                        this.ones.add(new Point3d((double)i - 0.5, (double)j - 0.5, (double)z));
                        continue;
                    }
                    if (b0 == 0 && b1 != 0 && b2 != 0 && b3 == 0) {
                        this.zeroes.add(new Point3d((double)i - 0.7, (double)j - 0.7, (double)z));
                        this.zeroes.add(new Point3d((double)i - 0.3, (double)j - 0.3, (double)z));
                        this.ones.add(new Point3d((double)i - 0.5, (double)j - 0.5, (double)z));
                        continue;
                    }
                    if (b0 == 0 && b1 != 0 && b2 != 0 && b3 != 0) {
                        this.zeroes.add(new Point3d((double)i - 0.7, (double)j - 0.7, (double)z));
                        this.ones.add(new Point3d((double)i - 0.1, (double)j - 0.1, (double)z));
                        continue;
                    }
                    if (b0 != 0 && b1 == 0 && b2 != 0 && b3 != 0) {
                        this.zeroes.add(new Point3d((double)i - 0.7, (double)j - 0.3, (double)z));
                        this.ones.add(new Point3d((double)i - 0.1, (double)j - 0.9, (double)z));
                        continue;
                    }
                    if (b0 != 0 && b1 != 0 && b2 == 0 && b3 != 0) {
                        this.zeroes.add(new Point3d((double)i - 0.3, (double)j - 0.7, (double)z));
                        this.ones.add(new Point3d((double)i - 0.9, (double)j - 0.1, (double)z));
                        continue;
                    }
                    if (b0 == 0 || b1 == 0 || b2 == 0 || b3 != 0) continue;
                    this.zeroes.add(new Point3d((double)i - 0.3, (double)j - 0.3, (double)z));
                    this.ones.add(new Point3d((double)i - 0.9, (double)j - 0.9, (double)z));
                }
            }
        }
    }
}

