/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import math3d.Point3d;
import vib.FastMatrix;
import vib.InterpolatedImage;

public class AugmentedLandmarkWarp_
implements PlugInFilter {
    ImagePlus image;
    InterpolatedImage ii;
    InterpolatedImage model;
    int labelCount;
    FastMatrix[] matrix;
    Point3d[] center;
    private float x;
    private float y;
    private float z;

    public void run(ImageProcessor ip) {
        try {
            GenericDialog gd = new GenericDialog("Transform Parameters");
            gd.addStringField("Center of materials or label image", "", 15);
            if (!AmiraParameters.addAmiraMeshList((GenericDialog)gd, (String)"Model")) {
                return;
            }
            gd.addStringField("LabelTransformationList", "1 0 0 0 0 1 0 0 0 0 1 0 0 0 0 1");
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            this.ii = new InterpolatedImage(this.image);
            this.model = new InterpolatedImage(WindowManager.getImage((String)gd.getNextChoice()));
            String labelString = gd.getNextString();
            this.matrix = FastMatrix.parseMatrices((String)gd.getNextString());
            ImagePlus labelImp = WindowManager.getImage((String)labelString);
            if (labelImp != null) {
                InterpolatedImage labels = new InterpolatedImage(labelImp);
                this.initCentersFromLabelField(labels);
            } else {
                this.initCentersFromString(labelString);
            }
            this.run();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    void setCenter(Point3d[] center) {
        this.center = center;
        this.labelCount = center.length;
        this.adjustMatricesToPixelCoordinates();
    }

    void initCentersFromString(String s) {
        this.center = Point3d.parsePoints((String)s);
        if (this.center.length != this.matrix.length) {
            IJ.error((String)"Number of center points and matrices must agree");
        }
        this.labelCount = this.center.length;
        this.adjustMatricesToPixelCoordinates();
    }

    void initCentersFromLabelField(InterpolatedImage labels) {
        this.center = new Point3d[256];
        for (int i = 0; i < this.center.length; ++i) {
            this.center[i] = new Point3d();
        }
        long[] volumes = new long[256];
        InterpolatedImage.Iterator iter = labels.iterator(false);
        while (iter.next() != null) {
            int value = labels.getNoInterpol(iter.i, iter.j, iter.k);
            this.center[value].x += (double)iter.i;
            this.center[value].y += (double)iter.j;
            this.center[value].z += (double)iter.k;
            int n = value;
            volumes[n] = volumes[n] + 1L;
        }
        this.labelCount = 256;
        while (this.labelCount > 1 && volumes[this.labelCount - 1] == 0L) {
            --this.labelCount;
        }
        for (int i = 0; i < this.labelCount; ++i) {
            if (volumes[i] > 0L) {
                this.center[i].x /= (double)volumes[i];
                this.center[i].y /= (double)volumes[i];
                this.center[i].z /= (double)volumes[i];
                continue;
            }
            this.matrix[i] = null;
        }
        this.adjustMatricesToPixelCoordinates();
    }

    private void adjustMatricesToPixelCoordinates() {
        FastMatrix fromTemplate = FastMatrix.fromCalibration((ImagePlus)this.ii.image);
        FastMatrix toModel = FastMatrix.fromCalibration((ImagePlus)this.model.image).inverse();
        for (int i = 1; i < this.matrix.length; ++i) {
            if (this.matrix[i] == null) continue;
            this.matrix[i] = toModel.times(this.matrix[i].inverse().times(fromTemplate));
        }
    }

    void transCoord(int i, int j, int k) {
        float total = 0.0f;
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        for (int l = 0; l < this.labelCount; ++l) {
            if (this.matrix[l] == null) continue;
            this.matrix[l].apply((double)i, (double)j, (double)k);
            double x = this.matrix[l].x;
            double y = this.matrix[l].y;
            double z = this.matrix[l].z;
            int xdiff = (int)Math.round(this.center[l].x - (double)i);
            int ydiff = (int)Math.round(this.center[l].y - (double)j);
            int zdiff = (int)Math.round(this.center[l].z - (double)k);
            float factor = xdiff * xdiff + ydiff * ydiff + zdiff * zdiff;
            factor = 1.0f / (factor + 0.01f);
            this.x = (float)((double)this.x + x * (double)factor);
            this.y = (float)((double)this.y + y * (double)factor);
            this.z = (float)((double)this.z + z * (double)factor);
            total += factor;
        }
        this.x /= total;
        this.y /= total;
        this.z /= total;
    }

    void run() {
        InterpolatedImage.Iterator iter = this.ii.iterator(true);
        while (iter.next() != null) {
            this.transCoord(iter.i, iter.j, iter.k);
            this.ii.set(iter.i, iter.j, iter.k, (int)this.model.interpol.get((double)this.x, (double)this.y, (double)this.z));
        }
        new AmiraParameters(this.model.image).setParameters(this.ii.image, false);
        this.ii.image.updateAndDraw();
    }

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 3;
    }
}

