/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GUI;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.PopupMenu;
import java.awt.ScrollPane;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import vib.BenesNamedPoint;
import vib.PointList;

public class Points_Dialog
extends Dialog
implements ActionListener,
PlugIn,
PointList.PointListListener {
    private PointsPanel panel;
    private final PopupMenu popup = this.createPopup();
    private Calibration cal;
    private ImagePlus imp;
    private PointList points;
    private BenesNamedPoint current;

    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        if (imp == null) {
            IJ.error((String)"There's no image to annotate.");
            return;
        }
        new Points_Dialog(imp);
    }

    public Points_Dialog(ImagePlus imp) {
        this(imp, null);
    }

    public Points_Dialog(ImagePlus imp, PointList points) {
        super((Frame)IJ.getInstance(), "Marking up: " + imp.getTitle(), false);
        this.imp = imp;
        this.cal = imp.getCalibration();
        this.points = points;
        if (this.points == null) {
            this.points = new PointList();
        }
        this.points.addPointListListener((PointList.PointListListener)this);
        this.add(this.popup);
        this.setLayout(new BorderLayout());
        this.add((Component)new Label("Mark the current point selection as:"), "North");
        this.panel = new PointsPanel();
        this.panel.update();
        ScrollPane scroll = new ScrollPane();
        scroll.add(this.panel);
        this.add((Component)scroll, "Center");
        Panel buttonsPanel = new Panel();
        Button button = new Button("Load");
        button.addActionListener(this);
        buttonsPanel.add(button);
        button = new Button("Add point");
        button.addActionListener(this);
        buttonsPanel.add(button);
        button = new Button("Save");
        button.addActionListener(this);
        buttonsPanel.add(button);
        button = new Button("Reset");
        button.addActionListener(this);
        buttonsPanel.add(button);
        button = new Button("Close");
        button.addActionListener(this);
        buttonsPanel.add(button);
        this.add((Component)buttonsPanel, "South");
        GUI.center((Window)this);
        this.pack();
        this.setVisible(true);
    }

    private PopupMenu createPopup() {
        PopupMenu popup = new PopupMenu();
        MenuItem mi = new MenuItem("Rename point");
        mi.addActionListener(this);
        popup.add(mi);
        mi = new MenuItem("Remove point");
        mi.addActionListener(this);
        popup.add(mi);
        mi = new MenuItem("Reset point");
        mi.addActionListener(this);
        popup.add(mi);
        return popup;
    }

    public PointList getPointList() {
        return this.points;
    }

    public void setPoints(PointList points) {
        this.points = points;
        this.panel.update();
    }

    public void addEmptyPoint() {
        BenesNamedPoint p = new BenesNamedPoint("point" + this.points.size());
        this.points.add(p);
    }

    public void removePoint(BenesNamedPoint p) {
        this.points.remove(p);
    }

    public void renamePoint(BenesNamedPoint p) {
        String name = IJ.getString((String)"New name", (String)p.name);
        if (name.equals("")) {
            return;
        }
        this.points.rename(p, name);
    }

    public void resetPoint(BenesNamedPoint p) {
        p.set = false;
        this.panel.update();
    }

    public void resetAll() {
        for (BenesNamedPoint p : this.points) {
            p.set = false;
        }
        this.panel.update();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Close")) {
            this.dispose();
        } else if (command.equals("Save")) {
            this.save();
        } else if (command.equals("Reset")) {
            this.resetAll();
        } else if (command.equals("Add point")) {
            this.addEmptyPoint();
        } else if (command.equals("Rename point")) {
            this.renamePoint(this.current);
        } else if (command.equals("Remove point")) {
            this.removePoint(this.current);
        } else if (command.equals("Reset point")) {
            this.resetPoint(this.current);
        } else if (command.equals("Load")) {
            this.load();
        }
    }

    public void save() {
        FileInfo info = this.imp.getOriginalFileInfo();
        if (info == null) {
            IJ.error((String)"There's no original file name that these points refer to.");
            return;
        }
        String fileName = info.fileName;
        String directory = info.directory;
        IJ.showStatus((String)("Saving point annotations to " + directory + fileName));
        this.points.save(directory, fileName);
        IJ.showStatus((String)"Saved point annotations.");
    }

    public void showPoint(BenesNamedPoint p) {
        if (this.imp.getWindow() == null) {
            return;
        }
        if (!p.set) {
            IJ.error((String)"Point is not set yet");
            return;
        }
        int slice = (int)(p.z / this.cal.pixelDepth);
        if (slice < 0) {
            slice = 0;
        }
        if (slice > this.imp.getStackSize()) {
            slice = this.imp.getStackSize() - 1;
        }
        this.imp.setSlice(slice + 1);
        PointRoi roi = new PointRoi((int)(p.x / this.cal.pixelWidth), (int)(p.y / this.cal.pixelHeight), this.imp);
        this.imp.setRoi((Roi)roi);
    }

    public void load() {
        PointList newNamedPoints = PointList.load((ImagePlus)this.imp);
        if (newNamedPoints == null) {
            return;
        }
        for (BenesNamedPoint current : newNamedPoints) {
            boolean foundName = false;
            for (BenesNamedPoint p : this.points) {
                if (!current.name.equals(p.name)) continue;
                p.set(current.x, current.y, current.z);
                p.set = true;
                foundName = true;
            }
            if (foundName) continue;
            this.points.add(current);
        }
    }

    public void mark(BenesNamedPoint point) {
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.getType() == 10) {
            Polygon p = roi.getPolygon();
            if (p.npoints > 1) {
                IJ.error((String)"You can only have one point selected to mark.");
                return;
            }
            double x = (double)p.xpoints[0] * this.cal.pixelWidth;
            double y = (double)p.ypoints[0] * this.cal.pixelHeight;
            double z = (double)(this.imp.getCurrentSlice() - 1) * this.cal.pixelDepth;
            this.points.placePoint(point, x, y, z);
        } else {
            IJ.error((String)("You must have a current point selection in " + this.imp.getTitle() + " in order to mark points."));
        }
    }

    public void added(BenesNamedPoint p) {
        this.panel.update();
    }

    public void removed(BenesNamedPoint p) {
        this.panel.update();
    }

    public void renamed(BenesNamedPoint p) {
        this.panel.update();
    }

    public void moved(BenesNamedPoint p) {
        this.panel.update();
    }

    public void highlighted(BenesNamedPoint p) {
    }

    public void reordered() {
        this.panel.update();
    }

    private class PointsPanel
    extends Panel {
        private PointsPanel() {
        }

        public void update() {
            if (Points_Dialog.this.points.size() == 0) {
                Points_Dialog.this.addEmptyPoint();
            }
            Points_Dialog.this.panel.removeAll();
            Points_Dialog.this.panel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            for (BenesNamedPoint p : Points_Dialog.this.points) {
                this.addRow(p, c);
            }
            Points_Dialog.this.pack();
        }

        private void addRow(final BenesNamedPoint p, GridBagConstraints c) {
            c.gridx = 0;
            c.gridy = -1;
            c.anchor = 21;
            final Button button = new Button(p.name);
            button.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        Points_Dialog.this.current = p;
                        Points_Dialog.this.popup.show(button, e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        Points_Dialog.this.current = p;
                        Points_Dialog.this.popup.show(button, e.getX(), e.getY());
                    }
                }
            });
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Points_Dialog.this.mark(p);
                }
            });
            Points_Dialog.this.panel.add((Component)button, c);
            c.anchor = 21;
            c.gridx = 1;
            Label coordinateLabel = p.set ? new Label(p.coordinatesAsString()) : new Label("     <unset>     ");
            Points_Dialog.this.panel.add((Component)coordinateLabel, c);
            c.anchor = 21;
            c.gridx = 2;
            Button showB = new Button("Show");
            showB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Points_Dialog.this.showPoint(p);
                }
            });
            showB.setEnabled(p.set);
            Points_Dialog.this.panel.add((Component)showB, c);
        }
    }
}

