/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.util.FontUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;

class PlotObject
implements Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    public static final int XY_DATA = 1;
    public static final int ARROWS = 2;
    public static final int LINE = 4;
    public static final int NORMALIZED_LINE = 8;
    public static final int DOTTED_LINE = 16;
    public static final int LABEL = 32;
    public static final int NORMALIZED_LABEL = 64;
    public static final int LEGEND = 128;
    public static final int AXIS_LABEL = 256;
    public static final int FRAME = 512;
    public static final int SHAPES = 1024;
    static final int FONT_STYLE_MASK = 15;
    public static final int CONSTRUCTOR_DATA = 4096;
    public static final int HIDDEN = 8192;
    public int type = 1;
    public int flags;
    public String options;
    public float[] xValues;
    public float[] yValues;
    public float[] xEValues;
    public float[] yEValues;
    public ArrayList shapeData;
    public String shapeType;
    public int shape;
    public float lineWidth;
    public Color color;
    public Color color2;
    public double x;
    public double y;
    public double xEnd;
    public double yEnd;
    public int step;
    public String label;
    public int justification;
    public String macroCode;
    private transient Font font;
    private String fontFamily;
    private float fontSize;

    PlotObject(int type) {
        this.type = type;
    }

    PlotObject(float[] xValues, float[] yValues, float[] yErrorBars, int shape, float lineWidth, Color color, Color color2, String yLabel) {
        this.type = 1;
        this.xValues = xValues;
        this.yValues = yValues;
        this.yEValues = yErrorBars;
        this.shape = shape;
        this.lineWidth = lineWidth;
        this.color = color;
        this.color2 = color2;
        this.label = yLabel;
        if (shape == 9) {
            this.macroCode = yLabel;
        }
    }

    PlotObject(float[] x1, float[] y1, float[] x2, float[] y2, float lineWidth, Color color) {
        this.type = 2;
        this.xValues = x1;
        this.yValues = y1;
        this.xEValues = x2;
        this.yEValues = y2;
        this.lineWidth = lineWidth;
        this.color = color;
    }

    PlotObject(String shapeType, ArrayList shapeData, float lineWidth, Color color, Color color2) {
        this.type = 1024;
        this.shapeData = shapeData;
        this.shapeType = shapeType;
        this.lineWidth = lineWidth;
        this.color = color;
        this.color2 = color2;
    }

    PlotObject(double x, double y, double xEnd, double yEnd, float lineWidth, int step, Color color, int type) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.xEnd = xEnd;
        this.yEnd = yEnd;
        this.lineWidth = lineWidth;
        this.step = step;
        this.color = color;
    }

    PlotObject(String label, double x, double y, int justification, Font font, Color color, int type) {
        this.type = type;
        this.label = label;
        this.x = x;
        this.y = y;
        this.justification = justification;
        this.setFont(font);
        this.color = color;
    }

    PlotObject(float lineWidth, Font font, Color color, int flags) {
        this.type = 128;
        this.lineWidth = lineWidth;
        this.setFont(font);
        this.color = color;
        this.flags = flags;
    }

    PlotObject(float lineWidth) {
        this.type = 512;
        this.color = Color.black;
        this.lineWidth = lineWidth;
    }

    boolean hasFlag(int what) {
        return (this.flags & what) != 0;
    }

    void setFlag(int what) {
        this.flags |= what;
    }

    void unsetFlag(int what) {
        this.flags &= ~what;
    }

    boolean hasCurve() {
        return this.type == 1 && (this.shape == 2 || this.shape == 7 || this.shape == 10);
    }

    boolean hasMarker() {
        return this.type == 1 && (this.shape == 0 || this.shape == 1 || this.shape == 3 || this.shape == 4 || this.shape == 5 || this.shape == 8 || this.shape == 6 || this.shape == 7 || this.shape == 9);
    }

    boolean hasFilledMarker() {
        return this.type == 1 && this.color2 != null && (this.shape == 0 || this.shape == 3 || this.shape == 4 || this.shape == 8 || this.shape == 7);
    }

    int getMarkerSize() {
        if (this.lineWidth <= 1.0f) {
            return 5;
        }
        if (this.lineWidth <= 3.0f) {
            return 7;
        }
        return (int)(this.lineWidth + 4.0f);
    }

    void setFont(Font font) {
        if (font == this.font) {
            return;
        }
        this.font = font;
        if (font == null) {
            this.fontFamily = null;
        } else {
            this.fontFamily = font.getFamily();
            this.flags = this.flags & 0xFFFFFFF0 | font.getStyle();
            this.fontSize = font.getSize2D();
        }
    }

    Font getFont() {
        if (this.font == null && this.fontFamily != null) {
            this.font = FontUtil.getFont(this.fontFamily, this.flags & 0xF, this.fontSize);
        }
        return this.font;
    }

    float getFontSize() {
        return this.fontSize;
    }

    float[][] getAllDataValues() {
        return new float[][]{this.xValues, this.yValues, this.xEValues, this.yEValues};
    }

    public PlotObject clone() {
        try {
            return (PlotObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public PlotObject deepClone() {
        PlotObject po2 = this.clone();
        if (this.xValues != null) {
            po2.xValues = (float[])this.xValues.clone();
        }
        if (this.yValues != null) {
            po2.yValues = (float[])this.yValues.clone();
        }
        if (this.xEValues != null) {
            po2.xEValues = (float[])this.xEValues.clone();
        }
        if (this.yEValues != null) {
            po2.yEValues = (float[])this.yEValues.clone();
        }
        if (this.shapeData != null) {
            po2.shapeData = this.cloneArrayList(this.shapeData);
        }
        return po2;
    }

    private ArrayList cloneArrayList(ArrayList src) {
        ArrayList dest = (ArrayList)src.clone();
        Class[] noClasses = new Class[]{};
        Object[] noObjects = new Object[]{};
        for (int i = 0; i < dest.size(); ++i) {
            Object o = dest.get(i);
            if (o == null) continue;
            try {
                Method cloneMethod = o.getClass().getMethod("clone", noClasses);
                dest.set(i, cloneMethod.invoke(o, noObjects));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dest;
    }

    void updateType() {
        this.type = 1 << this.type;
    }

    public String toString() {
        String s = "PlotObject type=" + this.type + " flags=" + this.flags + " xV:" + (this.xValues == null ? "-" : Integer.valueOf(this.yValues.length)) + " yV:" + (this.yValues == null ? "-" : Integer.valueOf(this.yValues.length)) + " label=" + this.label + " col=" + this.color + " fSize=" + this.fontSize + " ff=" + this.fontFamily;
        return s;
    }
}

