/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.Macro;
import ij.gui.GUI;
import ij.gui.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class SaveChangesDialog
extends Dialog
implements ActionListener,
KeyListener {
    private Button dontSave;
    private Button cancel;
    private Button save;
    private boolean cancelPressed;
    private boolean savePressed;

    public SaveChangesDialog(Frame parent, String fileName) {
        super(parent, "Save?", true);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 10, 10));
        Component message = fileName.startsWith("Save ") ? new Label(fileName) : (fileName.length() > 22 ? new MultiLineLabel("Save changes to\n\"" + fileName + "\"?") : new Label("Save changes to \"" + fileName + "\"?"));
        message.setFont(new Font("Dialog", 1, 12));
        panel.add(message);
        this.add("Center", panel);
        panel = new Panel();
        panel.setLayout(new FlowLayout(1, 8, 8));
        this.save = new Button("  Save  ");
        this.save.addActionListener(this);
        this.save.addKeyListener(this);
        this.cancel = new Button("  Cancel  ");
        this.cancel.addActionListener(this);
        this.cancel.addKeyListener(this);
        this.dontSave = new Button("Don't Save");
        this.dontSave.addActionListener(this);
        this.dontSave.addKeyListener(this);
        if (IJ.isMacintosh()) {
            panel.add(this.dontSave);
            panel.add(this.cancel);
            panel.add(this.save);
        } else {
            panel.add(this.save);
            panel.add(this.dontSave);
            panel.add(this.cancel);
        }
        this.add("South", panel);
        if (IJ.isMacintosh()) {
            this.setResizable(false);
        }
        this.pack();
        GUI.centerOnImageJScreen(this);
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancel) {
            this.cancelPressed = true;
        } else if (e.getSource() == this.save) {
            this.savePressed = true;
        }
        this.closeDialog();
    }

    public boolean cancelPressed() {
        if (this.cancelPressed) {
            Macro.abort();
        }
        return this.cancelPressed;
    }

    public boolean savePressed() {
        return this.savePressed;
    }

    void closeDialog() {
        this.dispose();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        IJ.setKeyDown(keyCode);
        if (keyCode == 10) {
            this.closeDialog();
        } else if (keyCode == 27) {
            this.cancelPressed = true;
            this.closeDialog();
            IJ.resetEscape();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

