/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJRenderViewInteractive;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import java.awt.event.MouseEvent;

public class VJViewerCanvas
extends ImageCanvas {
    protected static final int FINETHRESHOLD = 5;
    protected static final float PIXELSDEGREES = 1.0f;
    protected VJRenderViewInteractive renderView;
    protected long clickTime;
    protected boolean mouseIsDown = false;
    protected int startMouseX;
    protected int startMouseY;

    public VJViewerCanvas(ImagePlus imp) {
        super(imp);
    }

    public void setRenderView(VJRenderViewInteractive renderView) {
        this.renderView = renderView;
    }

    public void effectDragging(int dx, int dy) {
        float roty = this.distanceToAngle(dy);
        float rotx = this.distanceToAngle(dx);
        if (!(this.renderView instanceof VJRenderViewInteractive)) {
            IJ.log((String)"VJViewerCanvas error: renderView not initialize");
        }
        this.renderView.rotateInPlane(roty, -rotx);
    }

    protected float distanceToAngle(int dx) {
        if (Math.abs(dx) >= 5) {
            return (float)dx * 1.0f;
        }
        float corrected = (float)(dx * dx) / 5.0f;
        if (dx < 0) {
            return -corrected;
        }
        return corrected;
    }

    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.mouseIsDown = true;
        this.startMouseX = x;
        this.startMouseY = y;
        this.clickTime = System.currentTimeMillis();
    }

    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.mouseIsDown && (x != this.startMouseX || y != this.startMouseY)) {
            int deltax = x - this.startMouseX;
            int deltay = y - this.startMouseY;
            this.effectDragging(deltax, deltay);
        }
        this.mouseIsDown = false;
    }
}

