/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree.fieldaccess;

import com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.tree.ThisObject;
import net.thisptr.jackson.jq.internal.tree.fieldaccess.FieldAccess;
import net.thisptr.jackson.jq.path.Path;

public class StringFieldAccess
extends FieldAccess {
    private Expression field;

    public StringFieldAccess(Expression obj, Expression field, boolean permissive) {
        super(obj, permissive);
        this.field = field;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!(this.target instanceof ThisObject)) {
            builder.append(this.target.toString());
        }
        builder.append(".");
        builder.append(this.field);
        if (this.permissive) {
            builder.append("?");
        }
        return builder.toString();
    }

    @Override
    public void apply(Scope scope, JsonNode in, Path path, PathOutput output, boolean requirePath) throws JsonQueryException {
        this.field.apply(scope, in, key -> this.target.apply(scope, in, path, (pobj, ppath) -> {
            if (!key.isTextual() && !this.permissive) {
                throw new IllegalStateException();
            }
            StringFieldAccess.emitObjectFieldPath(this.permissive, key.asText(), pobj, ppath, output, requirePath);
        }, requirePath));
    }
}

