/*
 * Decompiled with CFR 0.152.
 */
package emblcmci;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.NewImage;
import ij.gui.Roi;
import ij.measure.CurveFitter;
import ij.plugin.frame.Fitter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;

public class BleachCorrection_ExpoFit {
    ImagePlus imp;
    boolean is3DT = false;
    Roi curROI = null;
    boolean doHeadLess = false;
    boolean verbose = false;

    public BleachCorrection_ExpoFit(ImagePlus imp) {
        this.imp = imp;
    }

    public BleachCorrection_ExpoFit(ImagePlus imp, Roi curROI) {
        this.imp = imp;
        this.curROI = curROI;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setHeadlessProcessing(boolean headless) {
        this.doHeadLess = headless;
    }

    public CurveFitter dcayFitting() {
        double[] xA = new double[this.imp.getStackSize()];
        double[] yA = new double[this.imp.getStackSize()];
        if (this.curROI == null) {
            this.curROI = new Roi(0, 0, this.imp.getWidth(), this.imp.getHeight());
        }
        for (int i = 0; i < this.imp.getStackSize(); ++i) {
            ImageProcessor curip = this.imp.getImageStack().getProcessor(i + 1);
            curip.setRoi(this.curROI);
            ImageStatistics imgstat = curip.getStatistics();
            xA[i] = i;
            yA[i] = imgstat.mean;
        }
        CurveFitter cf = new CurveFitter(xA, yA);
        double firstframeint = yA[0];
        double lastframeint = yA[yA.length - 1];
        double guess_a = firstframeint - lastframeint;
        if (guess_a <= 0.0) {
            IJ.error((String)"This sequence seems to be not decaying");
            return null;
        }
        double guess_c = lastframeint;
        double maxiteration = 2000.0;
        double NumRestarts = 2.0;
        double errotTol = 10.0;
        double[] fitparam = new double[]{-1.0 * guess_a, -1.0E-4, guess_c, maxiteration, NumRestarts, errotTol};
        cf.setInitialParameters(fitparam);
        cf.doFit(11);
        if (this.verbose) {
            IJ.log((String)("without GUI:" + GraphicsEnvironment.isHeadless()));
        }
        if (this.verbose) {
            IJ.log((String)("headless settings:" + this.doHeadLess));
        }
        if (!GraphicsEnvironment.isHeadless() && !this.doHeadLess) {
            Fitter.plot((CurveFitter)cf);
        }
        IJ.log((String)cf.getResultString());
        return cf;
    }

    public CurveFitter decayFitting3D(int zframes, int tframes) {
        double[] xA = new double[tframes];
        double[] yA = new double[tframes];
        double curStackMean = 0.0;
        if (this.curROI == null) {
            this.curROI = new Roi(0, 0, this.imp.getWidth(), this.imp.getHeight());
        }
        for (int i = 0; i < tframes; ++i) {
            curStackMean = 0.0;
            for (int j = 0; j < zframes; ++j) {
                ImageProcessor curip = this.imp.getImageStack().getProcessor(i * zframes + j + 1);
                curip.setRoi(this.curROI);
                ImageStatistics imgstat = curip.getStatistics();
                curStackMean += imgstat.mean;
            }
            xA[i] = i;
            yA[i] = curStackMean /= (double)zframes;
        }
        CurveFitter cf = new CurveFitter(xA, yA);
        double firstframeint = yA[0];
        double lastframeint = yA[yA.length - 1];
        double guess_a = firstframeint - lastframeint;
        if (guess_a <= 0.0) {
            IJ.error((String)"This sequence seems to be not decaying");
            return null;
        }
        double guess_c = lastframeint;
        double maxiteration = 2000.0;
        double NumRestarts = 2.0;
        double errotTol = 10.0;
        double[] fitparam = new double[]{-1.0 * guess_a, -1.0E-4, guess_c, maxiteration, NumRestarts, errotTol};
        cf.setInitialParameters(fitparam);
        cf.doFit(11);
        if (!GraphicsEnvironment.isHeadless() || !this.doHeadLess) {
            Fitter.plot((CurveFitter)cf);
        }
        IJ.log((String)cf.getResultString());
        return cf;
    }

    public double calcExponentialOffset(double a, double b, double c, double x) {
        return a * Math.exp(-b * x) + c;
    }

    public void core() {
        int[] impdimA = this.imp.getDimensions();
        IJ.log((String)("slices" + Integer.toString(impdimA[3]) + "  -- frames" + Integer.toString(impdimA[4])));
        int zframes = impdimA[3];
        int tframes = impdimA[4];
        if (impdimA[3] > 1 && impdimA[4] > 1) {
            this.is3DT = true;
            if (impdimA[3] * impdimA[4] != this.imp.getStackSize()) {
                IJ.showMessage((String)"slice and time frames do not match with the length of the stack. Please correct!");
                return;
            }
        }
        CurveFitter cf = this.is3DT ? this.decayFitting3D(zframes, tframes) : this.dcayFitting();
        double[] respara = cf.getParams();
        double res_a = respara[0];
        double res_b = respara[1];
        double res_c = respara[2];
        double ratio = 0.0;
        System.out.println(res_a + "," + res_b + "," + res_c);
        if (this.is3DT) {
            for (int i = 0; i < tframes; ++i) {
                for (int j = 0; j < zframes; ++j) {
                    ImageProcessor curip = this.imp.getImageStack().getProcessor(i * zframes + j + 1);
                    ratio = this.calcExponentialOffset(res_a, res_b, res_c, 0.0) / this.calcExponentialOffset(res_a, res_b, res_c, i);
                    curip.multiply(ratio);
                }
            }
        } else {
            if (this.verbose) {
                IJ.log((String)"Original Int\tCorrected Int\tRatio");
            }
            for (int i = 0; i < this.imp.getStackSize(); ++i) {
                ImageProcessor curip = this.imp.getImageStack().getProcessor(i + 1);
                double orgint = curip.getStatistics().mean;
                ratio = this.calcExponentialOffset(res_a, res_b, res_c, 0.0) / this.calcExponentialOffset(res_a, res_b, res_c, i);
                curip.multiply(ratio);
                double corint = curip.getStatistics().mean;
                if (!this.verbose) continue;
                String monitor = Double.toString(orgint) + "\t" + Double.toString(corint) + "\t" + Double.toString(ratio);
                IJ.log((String)monitor);
            }
        }
    }

    public static void main(String[] args) {
        int frames = 50;
        ImagePlus imp = NewImage.createByteImage((String)"testBleach", (int)25, (int)25, (int)frames, (int)1);
        BleachCorrection_ExpoFit bce = new BleachCorrection_ExpoFit(imp);
        int offset = 10;
        int amp = 150;
        double exp = 0.05;
        ArrayList<Integer> orgintA = new ArrayList<Integer>();
        for (int f = 0; f < frames; ++f) {
            double intensity = bce.calcExponentialOffset(amp, exp, offset, f);
            ImageProcessor ip = imp.getStack().getProcessor(f + 1);
            int grayscale = (int)intensity;
            ip.setColor(grayscale);
            ip.fill();
            orgintA.add(grayscale);
        }
        ImagePlus dupimp = imp.duplicate();
        bce = new BleachCorrection_ExpoFit(dupimp);
        bce.setVerbose(true);
        bce.core();
        dupimp.show();
        IJ.log((String)"Original Int\tCorrected Int");
        for (int f = 0; f < frames; ++f) {
            double orgstatMean = imp.getStack().getProcessor((int)(f + 1)).getStatistics().mean;
            double corstatMean = dupimp.getStack().getProcessor((int)(f + 1)).getStatistics().mean;
            IJ.log((String)(String.valueOf(orgstatMean) + "\t" + String.valueOf(corstatMean)));
        }
    }
}

