/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.python.core.BytecodeNotification;
import org.python.core.ContainsPyBytecode;
import org.python.core.Py;
import org.python.core.PyBytecode;
import org.python.core.PyCode;
import org.python.core.PyRunnable;
import org.python.core.imp;

public class BytecodeLoader {
    public static Class<?> makeClass(String name, byte[] data, Class<?> ... referents) {
        Loader loader2 = new Loader();
        for (Class<?> referent : referents) {
            try {
                loader2.addParent(referent.getClassLoader());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        Class<?> c = loader2.loadClassFromBytes(name, data);
        if (ContainsPyBytecode.class.isAssignableFrom(c)) {
            try {
                BytecodeLoader.fixPyBytecode(c);
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        BytecodeNotification.notify(name, data, c);
        return c;
    }

    public static Class<?> makeClass(String name, List<Class<?>> referents, byte[] data) {
        if (referents != null) {
            return BytecodeLoader.makeClass(name, data, referents.toArray(new Class[referents.size()]));
        }
        return BytecodeLoader.makeClass(name, data, new Class[0]);
    }

    private static PyCode parseSerializedCode(String code_str) throws IOException, ClassNotFoundException {
        byte[] b = BytecodeLoader.base64decode(code_str);
        ByteArrayInputStream bi = new ByteArrayInputStream(b);
        ObjectInputStream si = new ObjectInputStream(bi);
        PyBytecode meth_code = (PyBytecode)si.readObject();
        si.close();
        bi.close();
        return meth_code;
    }

    private static byte[] base64decode(String src) throws IllegalArgumentException {
        int quantum;
        int L = src.length();
        int tail = L % 4;
        if (tail == 1) {
            throw new IllegalArgumentException("Input length invalid (4n+1)");
        }
        int N = L / 4 * 3 + (tail > 0 ? tail - 1 : 0);
        byte[] data = new byte[N];
        int s = 0;
        int b = 0;
        while (s <= L - 4) {
            quantum = (BytecodeLoader.base64CharToBits(src.charAt(s++)) << 18) + (BytecodeLoader.base64CharToBits(src.charAt(s++)) << 12) + (BytecodeLoader.base64CharToBits(src.charAt(s++)) << 6) + BytecodeLoader.base64CharToBits(src.charAt(s++));
            data[b++] = (byte)(quantum >> 16);
            data[b++] = (byte)(quantum >> 8);
            data[b++] = (byte)quantum;
        }
        if (tail >= 2) {
            quantum = (BytecodeLoader.base64CharToBits(src.charAt(s++)) << 10) + (BytecodeLoader.base64CharToBits(src.charAt(s++)) << 4);
            data[b++] = (byte)(quantum >> 8);
            if (tail == 3) {
                data[b++] = (byte)(quantum += BytecodeLoader.base64CharToBits(src.charAt(s++)) >> 2);
            }
        }
        return data;
    }

    private static int base64CharToBits(char c) throws IllegalArgumentException {
        if (c >= 'a') {
            if (c <= 'z') {
                return c - 71;
            }
        } else if (c >= 'A') {
            if (c <= 'Z') {
                return c - 65;
            }
        } else if (c >= '0') {
            if (c <= '9') {
                return c + 4;
            }
        } else {
            if (c == '+') {
                return 62;
            }
            if (c == '/') {
                return 63;
            }
        }
        throw new IllegalArgumentException("Invalid character " + c);
    }

    public static void fixPyBytecode(Class<? extends ContainsPyBytecode> c) throws IllegalAccessException, NoSuchFieldException, IOException, ClassNotFoundException {
        Field[] fields;
        for (Field fld : fields = c.getDeclaredFields()) {
            Field codeField;
            String fldName = fld.getName();
            if (!fldName.startsWith("___")) continue;
            String[] splt = (fldName = fldName.substring(3)).split("_");
            if (splt[0].equals("0")) {
                codeField = c.getDeclaredField(fldName = fldName.substring(2));
                if (codeField.get(null) != null) continue;
                codeField.set(null, BytecodeLoader.parseSerializedCode((String)fld.get(null)));
                continue;
            }
            if (!splt[1].equals("0") || (codeField = c.getDeclaredField(fldName = fldName.substring(splt[0].length() + splt[1].length() + 2))).get(null) != null) continue;
            int len = Integer.parseInt(splt[0]);
            StringBuilder blt = new StringBuilder((String)fld.get(null));
            int pos = 1;
            while (pos < len) {
                int pos0 = pos;
                for (Field fldPart : fields) {
                    String[] splt2;
                    String partName = fldPart.getName();
                    if (partName.length() == fldName.length() || !partName.startsWith("___") || !partName.endsWith(fldName) || Integer.parseInt((splt2 = partName.substring(3).split("_"))[1]) != pos) continue;
                    blt.append((String)fldPart.get(null));
                    if (++pos == len) break;
                }
                if (pos0 != pos) continue;
                throw new RuntimeException("Invalid PyBytecode splitting in " + c.getName() + ":\nSplit-index " + pos + " wasn't found.");
            }
            codeField.set(null, BytecodeLoader.parseSerializedCode(blt.toString()));
        }
    }

    public static PyCode makeCode(String name, byte[] data, String filename) {
        try {
            Class<?> c = BytecodeLoader.makeClass(name, data, new Class[0]);
            Constructor<?> cons = c.getConstructor(String.class);
            Object instance = cons.newInstance(filename);
            PyCode result2 = ((PyRunnable)instance).getMain();
            return result2;
        }
        catch (Exception e) {
            throw Py.JavaError(e);
        }
    }

    public static class Loader
    extends URLClassLoader {
        private LinkedList<ClassLoader> parents = new LinkedList();

        public Loader() {
            super(new URL[0]);
            this.parents.add(imp.getSyspathJavaLoader());
        }

        public void addParent(ClassLoader referent) {
            if (referent != null && !this.parents.contains(referent)) {
                this.parents.addFirst(referent);
            }
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            for (ClassLoader loader2 : this.parents) {
                try {
                    return loader2.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw new ClassNotFoundException(name);
        }

        public Class<?> loadClassFromBytes(String name, byte[] data) {
            if (name.endsWith("$py")) {
                try {
                    ClassReader cr = new ClassReader(data);
                    name = cr.getClassName().replace('/', '.');
                }
                catch (RuntimeException cr) {
                    // empty catch block
                }
            }
            Class<?> c = this.defineClass(name, data, 0, data.length, this.getClass().getProtectionDomain());
            this.resolveClass(c);
            return c;
        }
    }
}

