/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.awt.widget;

import java.awt.Choice;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import org.scijava.plugin.Plugin;
import org.scijava.ui.awt.widget.AWTInputWidget;
import org.scijava.widget.ChoiceWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class AWTChoiceWidget
extends AWTInputWidget<String>
implements ChoiceWidget<Panel>,
ItemListener {
    private Choice choice;

    public String getValue() {
        return this.choice.getSelectedItem();
    }

    @Override
    public void set(WidgetModel model) {
        String[] items = model.getChoices();
        this.choice = new Choice();
        for (String item : items) {
            this.choice.add(item);
        }
        this.choice.addItemListener(this);
        this.getComponent().add((Component)this.choice, "Center");
        this.refreshWidget();
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isText() && model.isMultipleChoice();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.updateModel();
    }

    public void doRefresh() {
        String value = this.get().getValue().toString();
        if (value.equals(this.choice.getSelectedItem())) {
            return;
        }
        this.choice.select(value);
    }
}

