/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.analyzeSkeleton.ita;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import sc.fiji.analyzeSkeleton.Edge;
import sc.fiji.analyzeSkeleton.Point;
import sc.fiji.analyzeSkeleton.Vertex;
import sc.fiji.analyzeSkeleton.ita.PointUtils;

public final class VertexUtils {
    private VertexUtils() {
    }

    public static List<List<Double>> getNJunctionAngles(Collection<Vertex> vertices) {
        ArrayList<List<Double>> graphAngles = new ArrayList<List<Double>>(vertices.size());
        for (Vertex vertex : vertices) {
            List<Double> junctionAngles = VertexUtils.getAngles(vertex);
            graphAngles.add(junctionAngles);
        }
        return graphAngles;
    }

    public static Map<Integer, List<Vertex>> groupByValence(Collection<Vertex> vertices, int min, int max) throws IllegalArgumentException {
        if (min < 0) {
            throw new IllegalArgumentException("Minimum must be non-negative");
        }
        if (min > max) {
            throw new IllegalArgumentException("Minimum must be less or equal to maximum");
        }
        Predicate<Vertex> isInValenceRange = v -> {
            int valence = v.getBranches().size();
            return min <= valence && valence <= max;
        };
        return vertices.stream().filter(isInValenceRange).collect(Collectors.groupingBy(v -> v.getBranches().size()));
    }

    private static List<Double> getAngles(Vertex junction) {
        ArrayList<Double> angles = new ArrayList<Double>();
        Vector3d centroid = PointUtils.centroid(junction.getPoints());
        ArrayList<Edge> branches = junction.getBranches();
        for (int i = 0; i < branches.size() - 1; ++i) {
            for (int j = i + 1; j < branches.size(); ++j) {
                Vector3d endpoint = VertexUtils.getOppositeCentroid(junction, centroid, (Edge)branches.get(i));
                Vector3d endpoint2 = VertexUtils.getOppositeCentroid(junction, centroid, (Edge)branches.get(j));
                double angle = endpoint.angle((Vector3dc)endpoint2);
                angles.add(angle);
            }
        }
        return angles;
    }

    private static Vector3d getOppositeCentroid(Vertex vertex, Vector3d centroid, Edge edge) {
        ArrayList<Point> points = edge.getOppositeVertex(vertex).getPoints();
        Vector3d endPoint = PointUtils.centroid(points);
        return endPoint.sub((Vector3dc)centroid);
    }
}

