/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.it.fiji.plugins.h5j;

import ij.IJ;
import ij.ImagePlus;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import java.awt.HeadlessException;
import java.io.File;
import org.janelia.it.h5j.fiji.adapter.FijiAdapter;

public class H5j_Reader
extends ImagePlus
implements PlugIn {
    private static final String MESSAGE_PREFIX = "HHMI_H5J_Reader: ";
    private static final String EXTENSION = ".h5j";
    public static final String INFO_PROPERTY = "Info";
    private static final boolean HYPERSTACK = true;
    private boolean asImage = false;
    private boolean asHyperstack = true;

    public void run(String string) {
        try {
            File infile = this.ensureFileAvailable(string);
            if (infile != null) {
                FijiAdapter adapter = new FijiAdapter();
                ImagePlus infileImage = null;
                infileImage = this.asHyperstack ? adapter.getMultiChannelImagePlus(infile) : adapter.getImagePlus(infile);
                if (this.asImage) {
                    this.cloneStack(infileImage, this, this.asHyperstack);
                } else {
                    infileImage.show();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            IJ.showMessage((String)("HHMI_H5J_Reader: Problem reading file data.  Messsage is '" + ex.getLocalizedMessage() + "'."));
        }
    }

    public void setAsHyperStack(boolean asHyperstack) {
        this.asHyperstack = asHyperstack;
    }

    private void cloneStack(ImagePlus infileImage, ImagePlus target, boolean hyperStack) {
        target.setStack(infileImage.getTitle(), infileImage.getStack());
        target.setCalibration(infileImage.getCalibration());
        Object objInfo = infileImage.getProperty(INFO_PROPERTY);
        if (objInfo != null) {
            target.setProperty(INFO_PROPERTY, objInfo);
        }
        target.setFileInfo(infileImage.getFileInfo());
        if (hyperStack) {
            target.setDimensions(infileImage.getNChannels(), infileImage.getNSlices(), infileImage.getNFrames());
        }
        target.setOpenAsHyperStack(hyperStack);
    }

    private File ensureFileAvailable(String putativeFilePath) {
        File rtnVal = null;
        try {
            if (putativeFilePath == null || putativeFilePath.trim().equals("")) {
                rtnVal = this.showFileChooser();
                this.asImage = false;
            } else {
                rtnVal = new File(putativeFilePath);
                if (rtnVal.canRead()) {
                    this.asImage = true;
                } else {
                    rtnVal = this.showFileChooser();
                    this.asImage = false;
                }
            }
        }
        catch (Exception ex) {
            IJ.showMessage((String)("HHMI_H5J_Reader: unable to open " + putativeFilePath));
        }
        return rtnVal;
    }

    private File showFileChooser() throws HeadlessException {
        try {
            OpenDialog od = new OpenDialog("H5J Reader");
            String dir = od.getDirectory();
            String filename = od.getFileName();
            if (filename == null) {
                return null;
            }
            String path = dir + filename;
            File rtnVal = new File(path);
            return rtnVal;
        }
        catch (Exception ex) {
            IJ.error((String)("Exception encountered: " + ex.getMessage()));
            ex.printStackTrace();
            return null;
        }
    }
}

