/*
 * Decompiled with CFR 0.152.
 */
package amira;

import amira.AmiraParameters;
import amira.AmiraTable;
import ij.IJ;
import ij.text.TextPanel;
import ij.text.TextWindow;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

public class AmiraTableEncoder {
    AmiraParameters parameters;
    TextWindow textWindow;
    int columnCount;
    int rowCount;
    String[] headings;
    float[][] values;
    int[] textSizes;
    String[][] text;

    public AmiraTableEncoder(TextWindow window) {
        int i;
        this.textWindow = window;
        TextPanel panel = window.getTextPanel();
        String h = panel.getColumnHeadings();
        this.headings = h.split("\t");
        for (i = 0; i < this.headings.length; ++i) {
            if (!this.headings[i].equals("") && !this.headings[i].equals(" ")) continue;
            this.headings[i] = "column" + i;
        }
        this.columnCount = this.headings.length;
        this.rowCount = panel.getLineCount();
        this.text = new String[this.rowCount][this.columnCount];
        for (i = 0; i < this.rowCount; ++i) {
            this.text[i] = panel.getLine(i).split("\t");
        }
        if (window instanceof AmiraTable) {
            this.parameters = new AmiraParameters(((AmiraTable)window).properties);
        } else {
            String p = "Parameters {\n" + AmiraTable.getParameterString(this.rowCount, this.headings) + "}\n";
            this.parameters = new AmiraParameters(p);
        }
        this.values = new float[this.columnCount][];
        this.textSizes = new int[this.columnCount];
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            this.values[i2] = new float[this.rowCount];
            this.textSizes[i2] = -1;
            for (int j = 0; j < this.rowCount; ++j) {
                try {
                    this.values[i2][j] = Float.parseFloat(this.text[j][i2]);
                    continue;
                }
                catch (NumberFormatException e) {
                    this.values[i2] = null;
                    this.textSizes[i2] = 0;
                    for (j = 0; j < this.rowCount; ++j) {
                        int n = i2;
                        this.textSizes[n] = this.textSizes[n] + (this.text[j][i2].length() + 1);
                    }
                }
            }
        }
    }

    public boolean write(String name) {
        try {
            int i;
            FileWriter writer = new FileWriter(name);
            Date date = new Date();
            writer.write("# AmiraMesh 3D ASCII 2.0\n# CreationDate: " + date + "\n\n");
            for (i = 0; i < this.columnCount; ++i) {
                writer.write("define " + this.headings[i] + " " + (this.values[i] != null ? this.rowCount : this.textSizes[i]) + "\n");
            }
            writer.write("\nParameters {\n" + this.parameters + "\n}\n\n");
            for (i = 0; i < this.columnCount; ++i) {
                writer.write(this.headings[i] + " { " + (this.values[i] != null ? "float" : "byte") + " " + this.headings[i] + " } @" + (i + 1) + "\n");
            }
            writer.write("\n#Data section follows\n");
            for (i = 0; i < this.columnCount; ++i) {
                writer.write("@" + (i + 1) + "\n");
                if (this.values[i] != null) {
                    for (int j = 0; j < this.rowCount; ++j) {
                        writer.write(this.text[j][i] + "\n");
                    }
                } else {
                    this.writeStringColumn(writer, i);
                }
                writer.write("\n");
            }
            writer.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            IJ.error((String)e.toString());
            return false;
        }
    }

    void writeStringColumn(FileWriter writer, int i) throws IOException {
        for (int j = 0; j < this.rowCount; ++j) {
            byte[] b = this.text[j][i].getBytes();
            for (int k = 0; k < b.length; ++k) {
                writer.write(Integer.toString(b[k]) + "\n");
            }
            writer.write("0\n");
        }
    }
}

