/*
 * Decompiled with CFR 0.152.
 */
package distance;

import distance.PixelPairs;

public class Correlation
implements PixelPairs {
    private double sumX;
    private double sumY;
    private double sumXY;
    private double sumXSquared;
    private double sumYSquared;
    private long count;
    private static boolean verbose = false;

    @Override
    public void reset() {
        this.sumXY = 0.0;
        this.sumY = 0.0;
        this.sumX = 0.0;
        this.sumYSquared = 0.0;
        this.sumXSquared = 0.0;
        this.count = 0L;
    }

    @Override
    public void add(float v1, float v2) {
        if (verbose) {
            System.err.println("got " + v1 + " and " + v2);
        }
        this.sumX += (double)v1;
        this.sumY += (double)v2;
        this.sumXY += (double)(v1 * v2);
        this.sumXSquared += (double)(v1 * v1);
        this.sumYSquared += (double)(v2 * v2);
        ++this.count;
    }

    public float correlation() {
        float result = 0.0f;
        double n2 = this.count * this.count;
        double numerator = this.sumXY / (double)this.count - this.sumX * this.sumY / n2;
        double varX = this.sumXSquared / (double)this.count - this.sumX * this.sumX / n2;
        double varY = this.sumYSquared / (double)this.count - this.sumY * this.sumY / n2;
        double denominator = Math.sqrt(varX) * Math.sqrt(varY);
        if (denominator > 1.0E-8) {
            result = (float)(numerator / denominator);
        }
        return result;
    }

    @Override
    public float distance() {
        return 1.0f - this.correlation();
    }
}

