/*
 * Decompiled with CFR 0.152.
 */
package inference;

import inference.LogFuncs;
import java.util.Vector;

public class MAPInference {
    public int[] data;
    public int[] count;
    public short[][] maxpos;
    public short[] boundaries;
    public int Mmax;
    public double[] subEvidences;
    double[] logA;
    double[] logEvidences;

    public void setData(int[] data_) {
        this.data = data_;
        this.initCount();
    }

    public void setData(Vector data_) {
        int size = data_.size();
        this.data = new int[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = (Integer)data_.get(i);
        }
        this.initCount();
    }

    public void initCount() {
        int i;
        this.count = new int[this.K() + 1];
        this.subEvidences = new double[this.K() * this.K()];
        this.count[0] = 0;
        for (i = 1; i <= this.K(); ++i) {
            this.count[i] = this.count[i - 1] + this.data[i - 1];
        }
        for (i = -1; i < this.K() - 1; ++i) {
            for (int j = i + 1; j < this.K(); ++j) {
                int n = this.getCount(i, j);
                this.subEvidences[j + (i + 1) * this.K()] = LogFuncs.LogFactorial(n) - LogFuncs.LogPow(j - i, n);
            }
        }
    }

    public int getCount(int k1, int k2) {
        return this.count[k2 + 1] - this.count[k1 + 1];
    }

    public int K() {
        return this.data.length;
    }

    public int N() {
        return this.count[this.K()];
    }

    private void init(int M) {
        this.logA = new double[this.K()];
        this.logEvidences = new double[M + 1];
        this.maxpos = new short[M][this.K()];
        this.boundaries = new short[M];
        for (int k = 0; k < this.K(); ++k) {
            this.logA[k] = this.subEvidences[k];
        }
        this.logEvidences[0] = this.substep4b(0);
    }

    private double substep4aii(int k, int begin) {
        double a = -1.0E300;
        double maxval = -1.0E300;
        for (int kk = begin; kk < k; ++kk) {
            double curval = this.logA[kk] + this.subEvidences[k + (kk + 1) * this.K()];
            a = LogFuncs.LogAddLogLog(a, curval);
            if (!(curval > maxval)) continue;
            maxval = curval;
            this.maxpos[begin][k] = (short)kk;
        }
        return a;
    }

    private double substep4b(int m) {
        return this.logA[this.K() - 1] + this.defaultLogPrior(m);
    }

    private int step4(int M, boolean stopAtMax) {
        for (int m = 1; m < M; ++m) {
            for (int k = this.K() - 1; k >= m; --k) {
                this.logA[k] = this.substep4aii(k, m - 1);
            }
            this.logEvidences[m] = this.substep4b(m);
            if (!stopAtMax || !(this.logEvidences[m] - this.logEvidences[m - 1] < 0.0)) continue;
            return m - 1;
        }
        return M;
    }

    void step6(int M) {
        this.logA[this.K() - 1] = this.substep4aii(this.K() - 1, M - 1);
        this.logEvidences[M] = this.substep4b(M);
    }

    public void doit(int M, boolean stopAtMax) {
        this.init(M);
        this.Mmax = this.step4(M, stopAtMax);
        if (M == this.Mmax) {
            this.step6(this.Mmax);
        }
        this.computeBoundaries(this.Mmax);
    }

    public double defaultLogPrior(int m) {
        return LogFuncs.LogFactorial(this.K() - 1 - m) + 2.0 * LogFuncs.LogFactorial(m) - LogFuncs.LogFactorial(this.K() - 1) - LogFuncs.LogFactorial(this.N() + m);
    }

    private void computeBoundaries(int M) {
        this.boundaries[M - 1] = this.maxpos[M - 1][this.K() - 1];
        System.err.println("MAPBB " + (M - 1) + ": " + this.boundaries[M - 1]);
        for (int i = M - 2; i >= 0; --i) {
            this.boundaries[i] = this.maxpos[i][this.boundaries[i + 1]];
            System.err.println("MAPBB " + i + ": " + this.boundaries[i]);
        }
    }

    public double getPosteriorProb() {
        int n = this.getCount(-1, this.boundaries[0]);
        double retval = this.defaultLogPrior(this.Mmax);
        retval += LogFuncs.LogFactorial(n) - LogFuncs.LogPow(this.boundaries[0] + 1, n);
        for (int i = 1; i < this.Mmax; ++i) {
            n = this.getCount(this.boundaries[i - 1], this.boundaries[i]);
            retval += LogFuncs.LogFactorial(n) - LogFuncs.LogPow(this.boundaries[i] - this.boundaries[i - 1], n);
        }
        n = this.getCount(this.boundaries[this.Mmax - 1], this.K() - 1);
        retval += LogFuncs.LogFactorial(n) - LogFuncs.LogPow(this.K() - 1 - this.boundaries[this.Mmax - 1], n);
        return Math.exp(retval -= this.logEvidences[this.Mmax]);
    }

    public short getBoundary(int m) {
        if (m >= 0 && m < this.boundaries.length) {
            return this.boundaries[m];
        }
        return -1;
    }

    public int rebin(int originalBin) {
        int i;
        for (i = 0; i < this.boundaries.length && this.boundaries[i] < originalBin; ++i) {
        }
        return i;
    }

    public static void main(String[] args) {
        MAPInference m = new MAPInference();
        for (int i = 1; i < 10000; i *= 10) {
            int[] data = new int[]{i, i, 3 * i, i, 10 * i, 10 * i, 10 * i, 8 * i};
            m.setData(data);
            m.doit(7, true);
            System.err.println("N: " + 44 * i);
            System.err.println("MAP Prob " + m.getPosteriorProb());
            System.err.println();
        }
    }
}

