/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.plugin.RGBStackMerge;
import ij.process.StackConverter;
import vib.TransformedImage;

public class OverlayRegistered {
    public static ImageStack overlayToStack(ImagePlus a, ImagePlus b) {
        int type1;
        TransformedImage ti = new TransformedImage(a, b);
        float[] valueRange = ti.getValuesRange();
        a.getProcessor().setMinAndMax((double)valueRange[0], (double)valueRange[1]);
        b.getProcessor().setMinAndMax((double)valueRange[0], (double)valueRange[1]);
        int width = a.getWidth();
        int height = a.getHeight();
        int depth = a.getStackSize();
        if (width != b.getWidth() || height != b.getHeight() || depth != b.getStackSize()) {
            IJ.error((String)("The dimensions of image stack " + b.getTitle() + " do not match those of " + a.getTitle()));
            return null;
        }
        int type0 = a.getType();
        if (type0 != (type1 = b.getType())) {
            IJ.error((String)"Can't overlay two images of different types.");
            return null;
        }
        float[] range0 = OverlayRegistered.getValuesRange(a);
        float[] range1 = OverlayRegistered.getValuesRange(b);
        a.getProcessor().setMinAndMax((double)range0[0], (double)range0[1]);
        StackConverter converter = new StackConverter(a);
        converter.convertToGray8();
        b.getProcessor().setMinAndMax((double)range1[0], (double)range1[1]);
        converter = new StackConverter(b);
        converter.convertToGray8();
        RGBStackMerge merger = new RGBStackMerge();
        ImageStack merged = merger.mergeStacks(width, height, depth, a.getStack(), b.getStack(), a.getStack(), true);
        return merged;
    }

    public static ImagePlus overlayToImagePlus(ImagePlus a, ImagePlus b) {
        ImageStack merged = OverlayRegistered.overlayToStack(a, b);
        ImagePlus result = new ImagePlus("Merged", merged);
        Calibration ca = a.getCalibration();
        Calibration cb = b.getCalibration();
        if (ca != null || cb != null) {
            if (ca != null) {
                if (!ca.equals(cb)) {
                    IJ.error((String)"The calibrations of the two images differ");
                    return null;
                }
                result.setCalibration(ca);
            } else {
                IJ.error((String)"Calibration is set in one image but not the other.");
                return null;
            }
        }
        return result;
    }

    public static float[] getValuesRange(ImagePlus imagePlus) {
        int stackSize = imagePlus.getStackSize();
        ImageStack stack = imagePlus.getStack();
        int bitDepth = imagePlus.getBitDepth();
        float minValue = Float.MAX_VALUE;
        float maxValue = Float.MIN_VALUE;
        for (int z = 0; z < stackSize; ++z) {
            int value;
            int i;
            Object[] pixels;
            if (8 == bitDepth) {
                pixels = (byte[])stack.getPixels(z + 1);
                for (i = 0; i < pixels.length; ++i) {
                    value = pixels[i] & 0xFF;
                    if ((float)value > maxValue) {
                        maxValue = value;
                    }
                    if (!((float)value < minValue)) continue;
                    minValue = value;
                }
                continue;
            }
            if (16 != bitDepth) continue;
            pixels = (short[])stack.getPixels(z + 1);
            for (i = 0; i < pixels.length; ++i) {
                value = pixels[i];
                if ((float)value > maxValue) {
                    maxValue = value;
                }
                if (!((float)value < minValue)) continue;
                minValue = value;
            }
        }
        float[] result = new float[]{minValue, maxValue};
        return result;
    }
}

