/*
 * Decompiled with CFR 0.152.
 */
package vib.segment;

import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Checkbox;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Vector;
import vib.segment.CustomStackWindow;

public class Thresholder {
    protected CustomStackWindow stackWindow;
    protected ImagePlus image;
    protected ImageProcessor copy;
    protected int minThreshold = 127;
    protected int maxThreshold = 255;
    protected int erodeDilateIterations = 0;
    protected boolean showBinary = false;

    public Thresholder(CustomStackWindow stackWindow) {
        this.stackWindow = stackWindow;
        this.image = stackWindow.getCustomCanvas().getImage();
    }

    public void run() {
        if (this.stackWindow.areAllRoisEmpty()) {
            int w = this.image.getWidth();
            int h = this.image.getHeight();
            for (int i = 1; i <= this.image.getStackSize(); ++i) {
                this.stackWindow.setRoi(i, new Roi(0, 0, w, h));
            }
        }
        this.initializeSlice();
        GenericDialog gd = new GenericDialog("Adjust threshold");
        gd.addSlider("min value", 0.0, 255.0, (double)this.minThreshold);
        gd.addSlider("max value", 0.0, 255.0, (double)this.maxThreshold);
        gd.addSlider("erode/dilate iterations", 0.0, 10.0, (double)this.erodeDilateIterations);
        gd.addCheckbox("show binary", false);
        gd.addSlider("slice", 1.0, (double)this.image.getStackSize(), (double)this.image.getCurrentSlice());
        Vector sliders = gd.getSliders();
        final Scrollbar minSlider = (Scrollbar)sliders.get(0);
        final Scrollbar maxSlider = (Scrollbar)sliders.get(1);
        final Scrollbar iterationSlider = (Scrollbar)sliders.get(2);
        final Checkbox binary = (Checkbox)gd.getCheckboxes().get(0);
        Scrollbar sliceSlider = (Scrollbar)sliders.get(3);
        final AdjustmentListener listener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                Thresholder.this.minThreshold = minSlider.getValue();
                Thresholder.this.maxThreshold = maxSlider.getValue();
                Thresholder.this.erodeDilateIterations = iterationSlider.getValue();
                Thresholder.this.showBinary = binary.getState();
                Thresholder.this.apply();
                Thresholder.this.image.updateAndDraw();
            }
        };
        minSlider.addAdjustmentListener(listener);
        maxSlider.addAdjustmentListener(listener);
        iterationSlider.addAdjustmentListener(listener);
        binary.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                listener.adjustmentValueChanged(null);
            }
        });
        sliceSlider.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                Thresholder.this.restoreSlice();
                Thresholder.this.stackWindow.setCurrentSlice(e.getValue());
                Thresholder.this.initializeSlice();
            }
        });
        this.image.updateAndDraw();
        gd.showDialog();
        this.restoreSlice();
        this.image.updateAndDraw();
        if (gd.wasCanceled()) {
            return;
        }
        this.minThreshold = (int)gd.getNextNumber();
        this.maxThreshold = (int)gd.getNextNumber();
        this.erodeDilateIterations = (int)gd.getNextNumber();
        int dummy = (int)gd.getNextNumber();
        this.select();
    }

    void select() {
        ImageProcessor ip = this.copy.duplicate();
        ImagePlus dummy = new ImagePlus("dummy", ip);
        byte[] p = (byte[])ip.getPixels();
        ThresholdToSelection ts = new ThresholdToSelection();
        for (int i = 1; i <= this.image.getStackSize(); ++i) {
            Roi roi = this.stackWindow.getRoi(i);
            if (roi == null) continue;
            this.copy = this.image.getStack().getProcessor(i);
            Arrays.fill(p, (byte)0);
            this.apply(ip, roi, this.minThreshold, this.maxThreshold, this.erodeDilateIterations, true);
            ip.setThreshold(255.0, 255.0, 2);
            ts.setup("", dummy);
            ts.run(ip);
            this.stackWindow.setRoi(i, dummy.getRoi());
        }
    }

    protected void initializeSlice() {
        this.copy = this.image.getProcessor().duplicate();
        this.apply();
    }

    protected void restoreSlice() {
        this.image.setProcessor(null, this.copy);
    }

    protected void apply() {
        Roi roi = this.image.getRoi();
        if (roi == null) {
            return;
        }
        ImageProcessor ip = this.image.getProcessor();
        this.apply(ip, roi, this.minThreshold, this.maxThreshold, this.erodeDilateIterations, this.showBinary);
    }

    protected void apply(ImageProcessor ip, Roi roi, int min, int max, int erodeDilateIterations, boolean makeBinary) {
        byte[] p = (byte[])ip.getPixels();
        byte[] c = (byte[])this.copy.getPixels();
        int w = ip.getWidth();
        int h = ip.getHeight();
        Rectangle bounds = roi.getBoundingRect();
        int x1 = Math.min(0, bounds.x);
        int y1 = Math.min(0, bounds.y);
        int x2 = Math.max(w, x1 + bounds.width);
        int y2 = Math.max(h, y1 + bounds.height);
        if (erodeDilateIterations > 0) {
            int i;
            int y;
            ByteProcessor bp = new ByteProcessor(w, h);
            byte[] p1 = (byte[])bp.getPixels();
            for (y = y1; y < y2; ++y) {
                System.arraycopy(p, y * w + x1, p1, y * w + x1, x2 - x1);
            }
            this.apply((ImageProcessor)bp, roi, min, max, 0, true);
            for (i = 0; i < erodeDilateIterations; ++i) {
                bp.erode(1, 0);
            }
            for (i = 0; i < erodeDilateIterations; ++i) {
                bp.dilate(1, 0);
            }
            for (y = y1; y < y2; ++y) {
                for (int x = x1; x < x2; ++x) {
                    int index = y * w + x;
                    p[index] = p1[index] != 0 ? -1 : (makeBinary ? 0 : c[index]);
                }
            }
            return;
        }
        for (int y = y1; y < y2; ++y) {
            for (int x = x1; x < x2; ++x) {
                int index = y * w + x;
                p[index] = roi.contains(x, y) && (c[index] & 0xFF) >= min && (c[index] & 0xFF) <= max ? -1 : (makeBinary ? 0 : c[index]);
            }
        }
    }
}

