/*
 * Decompiled with CFR 0.152.
 */
package de.biomedical_imaging.ij.steger;

import de.biomedical_imaging.ij.steger.Chord;
import de.biomedical_imaging.ij.steger.LinesUtil;
import de.biomedical_imaging.ij.steger.Region;

public class Threshold {
    static void threshold(byte[] image, int min, int width, int height, Region out) {
        int i;
        boolean inside = false;
        int num = 0;
        int num_max = 100;
        Chord[] rl = new Chord[num_max];
        for (i = 0; i < num_max; ++i) {
            rl[i] = new Chord();
        }
        out.rl = null;
        out.num = 0;
        for (int r = 0; r < height; ++r) {
            int i2;
            for (int c = 0; c < width; ++c) {
                int l = LinesUtil.LINCOOR(r, c, width);
                byte grey = image[l];
                if (grey >= min) {
                    if (inside) continue;
                    inside = true;
                    rl[num].r = (short)r;
                    rl[num].cb = (short)c;
                    continue;
                }
                if (!inside) continue;
                inside = false;
                rl[num].ce = (short)(c - 1);
                if (++num < num_max) continue;
                num_max = (int)Math.floor(num_max * 2);
                Chord[] rlh = new Chord[num_max];
                for (i2 = 0; i2 < rlh.length; ++i2) {
                    rlh[i2] = i2 < rl.length ? rl[i2] : new Chord();
                }
                rl = rlh;
            }
            if (!inside) continue;
            inside = false;
            rl[num].ce = (short)(width - 1);
            if (++num < num_max) continue;
            num_max = (int)Math.floor(num_max * 2);
            Chord[] rlh = new Chord[num_max];
            for (i2 = 0; i2 < rlh.length; ++i2) {
                rlh[i2] = i2 < rl.length ? rl[i2] : new Chord();
            }
            rl = rlh;
        }
        out.rl = new Chord[num];
        for (i = 0; i < num; ++i) {
            out.rl[i] = rl[i];
        }
        out.num = num;
    }
}

