/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import mpicbg.spim.io.ConfigurationParserException;
import mpicbg.spim.io.ProgramConfiguration;
import mpicbg.spim.io.TextFileAccess;

public class ConfigurationParserGeneral {
    public static ProgramConfiguration parseFile(String confFileName) throws ConfigurationParserException {
        String[] words;
        String line;
        ProgramConfiguration conf = new ProgramConfiguration();
        String[] knownDatatypes = new String[]{"int", "double", "String", "float"};
        confFileName = confFileName.replace('\\', '/');
        String confFilePath = "";
        try {
            confFilePath = confFileName.indexOf("/") != -1 ? confFileName.substring(0, confFileName.lastIndexOf("/") + 1) : "";
        }
        catch (Exception e) {
            throw new ConfigurationParserException("Error parsing confFileName-String: '" + e.getMessage() + "'");
        }
        BufferedReader assignFile = null;
        BufferedReader confFile = null;
        try {
            confFile = TextFileAccess.openFileReadEx(confFileName);
        }
        catch (IOException e) {
            throw new ConfigurationParserException("Configuration file not found: '" + confFileName + "'");
        }
        try {
            while (confFile.ready() && assignFile == null) {
                String line2 = confFile.readLine().trim();
                if (!line2.startsWith("<") || !line2.endsWith(">") || (assignFile = TextFileAccess.openFileRead(confFilePath + line2.substring(1, line2.length() - 1))) != null) continue;
                throw new ConfigurationParserException("Variables Assignment file not found: '" + line2.substring(1, line2.length() - 2) + "'");
            }
        }
        catch (Exception e) {
            throw new ConfigurationParserException("Error finding assignment file entry: '" + e.getMessage() + "'");
        }
        ArrayList<Object> assignments = new ArrayList<Object>();
        Field[] fields = conf.getClass().getDeclaredFields();
        int lineCount = 0;
        try {
            while (assignFile.ready()) {
                int i;
                ++lineCount;
                line = assignFile.readLine().trim();
                if (line.startsWith("#") || line.length() <= 0) continue;
                words = line.split("=");
                if (words.length != 2) {
                    throw new ConfigurationParserException("Wrong format in assignment file, should be 'entry = datatype name'");
                }
                ArrayList<Object> temp = new ArrayList<Object>();
                temp.add(words[0].trim());
                words = words[1].trim().split(" ");
                if (words.length != 2) {
                    throw new ConfigurationParserException("Wrong format in assignment file, datatype and name on right side MUST have no spaces");
                }
                words[0] = words[0].trim();
                words[1] = words[1].trim();
                boolean positiveMatch = false;
                for (int i2 = 0; i2 < knownDatatypes.length; ++i2) {
                    if (words[0].compareTo(knownDatatypes[i2]) != 0) continue;
                    positiveMatch = true;
                }
                if (!positiveMatch) {
                    String datatypes = "";
                    for (i = 0; i < knownDatatypes.length; ++i) {
                        datatypes = datatypes + knownDatatypes[i] + " ";
                    }
                    throw new ConfigurationParserException("Unknown datatype '" + words[0] + "', available datatypes are: " + datatypes);
                }
                temp.add(words[0]);
                int variablesPosition = -1;
                for (i = 0; i < fields.length; ++i) {
                    if (words[1].compareTo(fields[i].getName()) != 0) continue;
                    variablesPosition = i;
                }
                if (variablesPosition == -1) {
                    String variables = "";
                    for (int i3 = 0; i3 < fields.length; ++i3) {
                        variables = variables + fields[i3].getName() + "\n";
                    }
                    throw new ConfigurationParserException("Unknown variable '" + words[1] + "', available variables are:\n" + variables);
                }
                temp.add(words[1]);
                temp.add(new Integer(variablesPosition));
                assignments.add(temp);
            }
        }
        catch (Exception e) {
            throw new ConfigurationParserException("Error reading/parsing assignment file at line " + lineCount + ":\n" + e.getMessage());
        }
        lineCount = 0;
        try {
            while (confFile.ready()) {
                ++lineCount;
                line = confFile.readLine().trim();
                if (line.startsWith("#") || line.length() <= 0) continue;
                words = line.split("=");
                if (words.length != 2) {
                    throw new ConfigurationParserException("Wrong format in configuration file, should be 'entry = value'");
                }
                words[0] = words[0].trim();
                words[1] = words[1].trim();
                int entryPos = ConfigurationParserGeneral.findEntry(assignments, words[0]);
                if (entryPos == -1) {
                    throw new ConfigurationParserException("Entry '" + words[0] + "' does not exist!\nFollowing entries are available:\n" + ConfigurationParserGeneral.getAllEntries(assignments));
                }
                int varFieldPos = ConfigurationParserGeneral.getVariableFieldPosition(assignments, entryPos);
                if (ConfigurationParserGeneral.getDatatype(assignments, entryPos).compareTo("int") == 0) {
                    fields[varFieldPos].setInt(conf, Integer.parseInt(words[1]));
                    continue;
                }
                if (ConfigurationParserGeneral.getDatatype(assignments, entryPos).compareTo("double") == 0) {
                    if (words[1].toLowerCase().compareTo("nan") == 0) {
                        fields[varFieldPos].setDouble(conf, Double.NaN);
                        continue;
                    }
                    fields[varFieldPos].setDouble(conf, Double.parseDouble(words[1]));
                    continue;
                }
                if (ConfigurationParserGeneral.getDatatype(assignments, entryPos).compareTo("String") == 0) {
                    if (words[1].startsWith("\"") && words[1].endsWith("\"")) {
                        fields[varFieldPos].set(conf, words[1].substring(1, words[1].length() - 1));
                        continue;
                    }
                    throw new ConfigurationParserException("Strings have to be surrounded by  \"\"");
                }
                if (ConfigurationParserGeneral.getDatatype(assignments, entryPos).compareTo("float") == 0) {
                    if (words[1].toLowerCase().compareTo("nan") == 0) {
                        fields[varFieldPos].setFloat(conf, Float.NaN);
                        continue;
                    }
                    fields[varFieldPos].setFloat(conf, Float.parseFloat(words[1]));
                    continue;
                }
                throw new ConfigurationParserException("Unknown datatype '" + ConfigurationParserGeneral.getDatatype(assignments, entryPos) + "'");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationParserException("Error reading/parsing configuration file at line " + lineCount + ":\n" + e.getMessage());
        }
        conf.baseFolder = conf.baseFolder.replace('\\', '/');
        conf.baseFolder = conf.baseFolder.trim();
        if (conf.baseFolder.length() > 0 && !conf.baseFolder.endsWith("/")) {
            conf.baseFolder = conf.baseFolder + "/";
        }
        conf.binariesFolder = conf.binariesFolder.replace('\\', '/');
        conf.binariesFolder = conf.binariesFolder.trim();
        if (conf.binariesFolder.length() > 0 && !conf.binariesFolder.endsWith("/")) {
            conf.binariesFolder = conf.binariesFolder + "/";
        }
        conf.librariesFolder = conf.librariesFolder.replace('\\', '/');
        conf.librariesFolder = conf.librariesFolder.trim();
        if (conf.librariesFolder.length() > 0 && !conf.librariesFolder.endsWith("/")) {
            conf.librariesFolder = conf.librariesFolder + "/";
        }
        conf.jobFolder = conf.jobFolder.replace('\\', '/');
        conf.jobFolder = conf.jobFolder.trim();
        if (conf.jobFolder.length() > 0 && !conf.jobFolder.endsWith("/")) {
            conf.jobFolder = conf.jobFolder + "/";
        }
        conf.configFolder = conf.configFolder.replace('\\', '/');
        conf.configFolder = conf.configFolder.trim();
        if (conf.configFolder.length() > 0 && !conf.configFolder.endsWith("/")) {
            conf.configFolder = conf.configFolder + "/";
        }
        conf.parseTimePoints();
        try {
            assignFile.close();
            confFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return conf;
    }

    private static int findEntry(ArrayList<Object> list, String entry) {
        int pos = -1;
        for (int i = 0; i < list.size() && pos == -1; ++i) {
            if (ConfigurationParserGeneral.getEntry(list, i).toLowerCase().compareTo(entry.toLowerCase()) != 0) continue;
            pos = i;
        }
        return pos;
    }

    private static String getAllEntries(ArrayList<Object> list) {
        String entries = "";
        for (int i = 0; i < list.size(); ++i) {
            entries = entries + ConfigurationParserGeneral.getEntry(list, i) + "\n";
        }
        return entries;
    }

    private static String getEntry(ArrayList<Object> list, int pos) {
        return (String)((ArrayList)list.get(pos)).get(0);
    }

    private static String getDatatype(ArrayList<Object> list, int pos) {
        return (String)((ArrayList)list.get(pos)).get(1);
    }

    private static int getVariableFieldPosition(ArrayList<Object> list, int pos) {
        return (Integer)((ArrayList)list.get(pos)).get(3);
    }
}

