/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.explorer.popup;

import bdv.BigDataViewer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.Pair;
import spim.fiji.plugin.Apply_Transformation;
import spim.fiji.plugin.apply.ApplyParameters;
import spim.fiji.spimdata.explorer.ViewSetupExplorerPanel;
import spim.fiji.spimdata.explorer.popup.ViewExplorerSetable;

public class ReorientSamplePopup
extends JMenuItem
implements ViewExplorerSetable {
    private static final long serialVersionUID = 5234649267634013390L;
    public static boolean showWarning = true;
    ViewSetupExplorerPanel<? extends AbstractSpimData<? extends AbstractSequenceDescription<?, ?, ?>>, ?> panel;

    public ReorientSamplePopup() {
        super("Interactively Reorient Sample ...");
        this.addActionListener(new MyActionListener());
    }

    @Override
    public JMenuItem setViewExplorer(ViewSetupExplorerPanel<? extends AbstractSpimData<? extends AbstractSequenceDescription<?, ?, ?>>, ?> panel) {
        this.panel = panel;
        return this;
    }

    public class MyActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (ReorientSamplePopup.this.panel == null) {
                IOFunctions.println("Panel not set for " + this.getClass().getSimpleName());
                return;
            }
            if (!SpimData.class.isInstance(ReorientSamplePopup.this.panel.getSpimData())) {
                IOFunctions.println("Only supported for SpimData objects: " + this.getClass().getSimpleName());
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    List<ViewId> viewIds = ReorientSamplePopup.this.panel.selectedRowsViewId();
                    SpimData data = (SpimData)ReorientSamplePopup.this.panel.getSpimData();
                    Apply_Transformation t = new Apply_Transformation();
                    ApplyParameters params = new ApplyParameters();
                    params.sameModelAngles = true;
                    params.sameModelChannels = true;
                    params.sameModelIlluminations = true;
                    params.sameModelTimePoints = true;
                    params.model = 2;
                    params.applyTo = 2;
                    params.defineAs = 2;
                    Map<ViewDescription, Pair<double[], String>> modelLinks = t.queryBigDataViewer(data, viewIds, params);
                    if (modelLinks == null) {
                        return;
                    }
                    AffineTransform3D applied = new AffineTransform3D();
                    applied.set((double[])modelLinks.values().iterator().next().getA());
                    applied = applied.inverse();
                    t.applyModels(data, params.minResolution, params.applyTo, modelLinks);
                    ReorientSamplePopup.this.panel.updateContent();
                    BigDataViewer bdv = ViewSetupExplorerPanel.bdvPopup().bdv;
                    if (bdv != null && bdv.getViewerFrame().isVisible()) {
                        AffineTransform3D transform = new AffineTransform3D();
                        bdv.getViewer().getState().getViewerTransform(transform);
                        transform = transform.concatenate(applied);
                        bdv.getViewer().setCurrentViewerTransform(transform);
                        ViewSetupExplorerPanel.bdvPopup().updateBDV();
                    }
                }
            }).start();
        }
    }
}

