/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.deconvolution;

import java.util.concurrent.Callable;
import net.imglib2.Cursor;
import net.imglib2.EuclideanSpace;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import spim.process.fusion.FusionHelper;
import spim.process.fusion.ImagePortion;
import spim.process.fusion.weights.Blending;

public class TransformInputAndWeights
implements Callable<String> {
    final ImagePortion portion;
    final RandomAccessibleInterval<FloatType> img;
    final AffineTransform3D transform;
    final RandomAccessibleInterval<FloatType> weightImg;
    final RandomAccessibleInterval<FloatType> transformedImg;
    final Blending blending;
    final int offsetX;
    final int offsetY;
    final int offsetZ;
    final int imgSizeX;
    final int imgSizeY;
    final int imgSizeZ;

    public TransformInputAndWeights(ImagePortion portion, RandomAccessibleInterval<FloatType> img, Blending blending, AffineTransform3D transform, RandomAccessibleInterval<FloatType> transformedImg, RandomAccessibleInterval<FloatType> weightImg, long[] offset) {
        this.portion = portion;
        this.img = img;
        this.weightImg = weightImg;
        this.transform = transform;
        this.transformedImg = transformedImg;
        this.blending = blending;
        this.offsetX = (int)offset[0];
        this.offsetY = (int)offset[1];
        this.offsetZ = (int)offset[2];
        this.imgSizeX = (int)img.dimension(0);
        this.imgSizeY = (int)img.dimension(1);
        this.imgSizeZ = (int)img.dimension(2);
    }

    @Override
    public String call() throws Exception {
        NLinearInterpolatorFactory f = new NLinearInterpolatorFactory();
        RealRandomAccess ir = Views.interpolate((EuclideanSpace)Views.extendMirrorSingle(this.img), (InterpolatorFactory)f).realRandomAccess();
        RealRandomAccess<FloatType> wr = this.blending.realRandomAccess();
        Cursor cursor = Views.iterable(this.transformedImg).localizingCursor();
        Cursor cursorW = Views.iterable(this.weightImg).cursor();
        float[] s = new float[3];
        float[] t = new float[3];
        cursor.jumpFwd(this.portion.getStartPosition());
        cursorW.jumpFwd(this.portion.getStartPosition());
        int j = 0;
        while ((long)j < this.portion.getLoopSize()) {
            TransformInputAndWeights.loop((Cursor<FloatType>)cursor, (Cursor<FloatType>)cursorW, (RealRandomAccess<FloatType>)ir, wr, this.transform, s, t, this.offsetX, this.offsetY, this.offsetZ, this.imgSizeX, this.imgSizeY, this.imgSizeZ);
            ++j;
        }
        return this.portion + " finished successfully (transform input & precompute weights).";
    }

    private static final void loop(Cursor<FloatType> cursor, Cursor<FloatType> cursorW, RealRandomAccess<FloatType> ir, RealRandomAccess<FloatType> wr, AffineTransform3D transform, float[] s, float[] t, int offsetX, int offsetY, int offsetZ, int imgSizeX, int imgSizeY, int imgSizeZ) {
        FloatType v = (FloatType)cursor.next();
        cursor.localize(s);
        FloatType w = (FloatType)cursorW.next();
        s[0] = s[0] + (float)offsetX;
        s[1] = s[1] + (float)offsetY;
        s[2] = s[2] + (float)offsetZ;
        transform.applyInverse(t, s);
        if (FusionHelper.intersects(t[0], t[1], t[2], imgSizeX, imgSizeY, imgSizeZ)) {
            ir.setPosition(t);
            v.set(Math.max(1.0E-4f, ((FloatType)ir.get()).get()));
        }
        wr.setPosition(t);
        w.set((FloatType)wr.get());
    }
}

