/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.weightedavg;

import java.util.ArrayList;
import java.util.List;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.generic.sequence.ImgLoaderHints;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.ImgLoader;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.img.Img;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.ViewSetupUtils;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.weights.Blending;
import spim.process.fusion.weights.ContentBased;

public abstract class ProcessFusion {
    public static float[] defaultBlendingRange = new float[]{40.0f, 40.0f, 40.0f};
    public static float[] defaultBlendingBorder = new float[]{0.0f, 0.0f, 0.0f};
    public static boolean defaultAdjustBlendingForAnisotropy = true;
    public static double[] defaultContentBasedSigma1 = new double[]{20.0, 20.0, 20.0};
    public static double[] defaultContentBasedSigma2 = new double[]{40.0, 40.0, 40.0};
    public static boolean defaultAdjustContentBasedSigmaForAnisotropy = true;
    protected final SpimData2 spimData;
    final List<ViewId> viewIdsToProcess;
    final BoundingBoxGUI bb;
    final boolean useBlending;
    final boolean useContentBased;

    public ProcessFusion(SpimData2 spimData, List<ViewId> viewIdsToProcess, BoundingBoxGUI bb, boolean useBlending, boolean useContentBased) {
        this.spimData = spimData;
        this.viewIdsToProcess = viewIdsToProcess;
        this.bb = bb;
        this.useBlending = useBlending;
        this.useContentBased = useContentBased;
    }

    public abstract <T extends RealType<T> & NativeType<T>> Img<T> fuseStack(T var1, InterpolatorFactory<T, RandomAccessible<T>> var2, TimePoint var3, Channel var4);

    protected Blending getBlending(Interval interval, ViewDescription desc, ImgLoader imgLoader) {
        float[] blending = (float[])defaultBlendingRange.clone();
        float[] border = (float[])defaultBlendingBorder.clone();
        float minRes = (float)ProcessFusion.getMinRes(desc, imgLoader);
        VoxelDimensions voxelSize = ViewSetupUtils.getVoxelSizeOrLoad(desc.getViewSetup(), desc.getTimePoint(), imgLoader);
        if (defaultAdjustBlendingForAnisotropy) {
            for (int d = 0; d < 2; ++d) {
                int n = d;
                blending[n] = blending[n] / ((float)voxelSize.dimension(d) / minRes);
                int n2 = d;
                border[n2] = border[n2] / ((float)voxelSize.dimension(d) / minRes);
            }
        }
        return new Blending(interval, border, blending);
    }

    protected <T extends RealType<T>> ContentBased<T> getContentBased(RandomAccessibleInterval<T> img, ViewDescription desc, ImgLoader imgLoader) {
        double[] sigma1 = (double[])defaultContentBasedSigma1.clone();
        double[] sigma2 = (double[])defaultContentBasedSigma2.clone();
        double minRes = ProcessFusion.getMinRes(desc, imgLoader);
        VoxelDimensions voxelSize = ViewSetupUtils.getVoxelSizeOrLoad(desc.getViewSetup(), desc.getTimePoint(), imgLoader);
        if (defaultAdjustContentBasedSigmaForAnisotropy) {
            for (int d = 0; d < 2; ++d) {
                int n = d;
                sigma1[n] = sigma1[n] / (voxelSize.dimension(d) / minRes);
                int n2 = d;
                sigma2[n2] = sigma2[n2] / (voxelSize.dimension(d) / minRes);
            }
        }
        return new ContentBased<T>(img, this.bb.getImgFactory(new ComplexFloatType()), sigma1, sigma2);
    }

    protected <T extends RealType<T>> ArrayList<RealRandomAccessible<FloatType>> getAllWeights(RandomAccessibleInterval<T> img, ViewDescription desc, ImgLoader imgLoader) {
        ArrayList<RealRandomAccessible<FloatType>> weigheners = new ArrayList<RealRandomAccessible<FloatType>>();
        if (this.useBlending) {
            weigheners.add(this.getBlending((Interval)new FinalInterval(img), desc, imgLoader));
        }
        if (this.useContentBased) {
            weigheners.add(this.getContentBased(img, desc, imgLoader));
        }
        return weigheners;
    }

    public static double getMinRes(ViewDescription desc, ImgLoader imgLoader) {
        VoxelDimensions size = ViewSetupUtils.getVoxelSizeOrLoad(desc.getViewSetup(), desc.getTimePoint(), imgLoader);
        return Math.min(size.dimension(0), Math.min(size.dimension(1), size.dimension(2)));
    }

    protected AffineTransform3D getTransform(ViewDescription inputData) {
        return this.spimData.getViewRegistrations().getViewRegistration((ViewId)inputData).getModel();
    }

    protected AffineTransform3D[] getTransforms(ArrayList<ViewDescription> inputData) {
        int numViews = inputData.size();
        AffineTransform3D[] transforms = new AffineTransform3D[numViews];
        for (int i = 0; i < numViews; ++i) {
            transforms[i] = this.getTransform(inputData.get(i));
        }
        return transforms;
    }

    public static <T extends RealType<T>> RandomAccessibleInterval<T> getImage(T type, SpimData2 spimData, ViewId view, boolean normalize) {
        return ProcessFusion.getImage(type, (ImgLoader)((SequenceDescription)spimData.getSequenceDescription()).getImgLoader(), view, normalize);
    }

    public static <T extends RealType<T>> RandomAccessibleInterval<T> getImage(T type, ImgLoader imgLoader, ViewId view, boolean normalize) {
        if (type instanceof FloatType) {
            return imgLoader.getSetupImgLoader(view.getViewSetupId()).getFloatImage(view.getTimePointId(), normalize, new ImgLoaderHint[]{ImgLoaderHints.LOAD_COMPLETELY});
        }
        if (type instanceof UnsignedShortType) {
            return imgLoader.getSetupImgLoader(view.getViewSetupId()).getImage(view.getTimePointId(), new ImgLoaderHint[]{ImgLoaderHints.LOAD_COMPLETELY});
        }
        return null;
    }
}

